/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.logging.Logger;

public class RunAt {
    static L10N L = new L10N(RunAt.class);
    private static final Logger log = Log.open(RunAt.class);
    private QDate _cal = QDate.createLocal();
    private long _period = -1L;
    private IntArray _hourTimes;
    private IntArray _minuteTimes;

    public void addText(String runAt) throws ConfigException {
        this.configureRunAt(runAt);
    }

    public void setPeriod(Period period) throws ConfigException {
        this._period = period.getPeriod();
    }

    public long getNextTimeout(long now) {
        long delta;
        long time;
        int i;
        this._cal.setGMTTime(now);
        long zone = this._cal.getZoneOffset();
        if (this._period > 0L) {
            return Period.periodEnd(now + zone, this._period) - zone;
        }
        now -= now % 60000L;
        long local = now + zone;
        long dayMinutes = local / 60000L % 1440L;
        long hourMinutes = dayMinutes % 60L;
        long nextDelta = Long.MAX_VALUE;
        for (i = 0; this._hourTimes != null && i < this._hourTimes.size(); ++i) {
            time = this._hourTimes.get(i);
            delta = (time - dayMinutes + 1440L) % 1440L;
            if (delta == 0L) {
                delta = 1440L;
            }
            if (delta >= nextDelta || delta <= 0L) continue;
            nextDelta = delta;
        }
        for (i = 0; this._minuteTimes != null && i < this._minuteTimes.size(); ++i) {
            time = this._minuteTimes.get(i);
            delta = (time - hourMinutes + 60L) % 60L;
            if (delta == 0L) {
                delta = 60L;
            }
            if (delta >= nextDelta || delta <= 0L) continue;
            nextDelta = delta;
        }
        if (nextDelta < Integer.MAX_VALUE) {
            return now + nextDelta * 60000L;
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }

    private void configureRunAt(String string) throws ConfigException {
        int len = string.length();
        char ch = '\u0000';
        int i = 0;
        while (true) {
            if (i < len && (Character.isWhitespace(ch = string.charAt(i)) || ch == ',')) {
                ++i;
                continue;
            }
            if (i >= len) {
                return;
            }
            if ((ch < '0' || ch > '9') && ch != ':') {
                throw new ConfigException(L.l("illegal run-at time `{0}'.  Run-at values are either hour (0:00, 6:30, 12:15) or minute (:15, :30, :45).", (Object)string));
            }
            int hour = 0;
            int minute = 0;
            boolean hasHour = false;
            while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                hasHour = true;
                hour = 10 * hour + ch - 48;
                ++i;
            }
            if (ch == ':') {
                ++i;
                while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                    minute = 10 * minute + ch - 48;
                    ++i;
                }
            }
            if (hasHour) {
                if (this._hourTimes == null) {
                    this._hourTimes = new IntArray();
                }
                this._hourTimes.add(60 * hour + minute);
                continue;
            }
            if (this._minuteTimes == null) {
                this._minuteTimes = new IntArray();
            }
            this._minuteTimes.add(minute);
        }
    }
}

