/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Icon;
import com.caucho.config.types.InitParam;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.naming.Jndi;
import com.caucho.remote.server.ProtocolServletFactory;
import com.caucho.server.connection.StubServletRequest;
import com.caucho.server.connection.StubServletResponse;
import com.caucho.server.dispatch.CometServletFilterChain;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.RunAt;
import com.caucho.server.dispatch.SecurityRoleMapFilterChain;
import com.caucho.server.dispatch.SecurityRoleRef;
import com.caucho.server.dispatch.ServletFilterChain;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletProtocolConfig;
import com.caucho.server.dispatch.SingleThreadServletFilterChain;
import com.caucho.server.dispatch.WebServiceFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.servlet.comet.CometServlet;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletConfigImpl
implements ServletConfig,
AlarmListener {
    static L10N L = new L10N(ServletConfigImpl.class);
    protected static final Logger log = Logger.getLogger(ServletConfigImpl.class.getName());
    private String _location;
    private String _jndiName;
    private String _var;
    private String _servletName;
    private String _servletClassName;
    private Class _servletClass;
    private String _jspFile;
    private String _displayName;
    private int _loadOnStartup = Integer.MIN_VALUE;
    private boolean _allowEL = true;
    private HashMap<String, String> _initParams = new HashMap();
    private HashMap<String, String> _roleMap;
    private ContainerProgram _init;
    private RunAt _runAt;
    private ServletProtocolConfig _protocolConfig;
    private ProtocolServletFactory _protocolFactory;
    private Alarm _alarm;
    private ComponentImpl _comp;
    private ServletContext _servletContext;
    private ServletManager _servletManager;
    private ServletException _initException;
    private long _nextInitTime;
    private Object _servlet;
    private FilterChain _servletChain;

    public void setConfigLocation(String location, int line) {
        this._location = location + ":" + line + ": ";
    }

    public void setId(String id) {
    }

    public void setServletName(String name) {
        this._servletName = name;
    }

    public String getServletName() {
        return this._servletName;
    }

    public String getServletClassName() {
        return this._servletClassName;
    }

    public void setServletClass(String servletClassName) {
        this._servletClassName = servletClassName;
        if ("javax.faces.webapp.FacesServlet".equals(this._servletClassName)) {
            if (this._loadOnStartup < 0) {
                this._loadOnStartup = 1;
            }
            if (this._servletContext instanceof WebApp) {
                ((WebApp)this._servletContext).createJsp().setLoadTldOnInit(true);
            }
        }
    }

    public Class getServletClass() {
        if (this._servletClassName == null) {
            return null;
        }
        if (this._servletClass == null) {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                this._servletClass = Class.forName(this._servletClassName, false, loader);
            }
            catch (Exception e) {
                throw this.error(L.l("'{0}' is not a known servlet class.  Servlets belong in the classpath, for example WEB-INF/classes.", (Object)this._servletClassName), e);
            }
        }
        return this._servletClass;
    }

    public void setJspFile(String jspFile) {
        this._jspFile = jspFile;
    }

    public String getJspFile() {
        return this._jspFile;
    }

    public void setAllowEL(boolean allowEL) {
        this._allowEL = allowEL;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public InitParam createInitParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._allowEL);
        return initParam;
    }

    public void setInitParam(InitParam initParam) {
        this._initParams.putAll(initParam.getParameters());
    }

    public Map getInitParamMap() {
        return this._initParams;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this._loadOnStartup = loadOnStartup;
    }

    public int getLoadOnStartup() {
        if (this._loadOnStartup > Integer.MIN_VALUE) {
            return this._loadOnStartup;
        }
        if (this._runAt != null) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public RunAt createRunAt() {
        if (this._runAt == null) {
            this._runAt = new RunAt();
        }
        return this._runAt;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public RunAt getRunAt() {
        return this._runAt;
    }

    public void addSecurityRoleRef(SecurityRoleRef ref) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap(8);
        }
        this._roleMap.put(ref.getRoleName(), ref.getRoleLink());
    }

    public HashMap<String, String> getRoleMap() {
        return this._roleMap;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
    }

    public void setIcon(Icon icon) {
    }

    public void setProtocol(ServletProtocolConfig protocol) {
        this._protocolConfig = protocol;
    }

    public void setInitException(ServletException exn) {
        UnavailableException unExn;
        this._initException = exn;
        this._nextInitTime = 0x3FFFFFFFFFFFFFFFL;
        if (exn instanceof UnavailableException && !(unExn = (UnavailableException)((Object)exn)).isPermanent()) {
            this._nextInitTime = Alarm.getCurrentTime() + 1000L * (long)unExn.getUnavailableSeconds();
        }
    }

    public Object getServlet() {
        return this._servlet;
    }

    @PostConstruct
    public void init() throws ServletException {
        Object servlet;
        if (this._runAt != null) {
            this._alarm = new Alarm((AlarmListener)this);
        }
        if (this._servletName == null) {
            if (this._protocolConfig != null) {
                String protocolName = this._protocolConfig.getUri();
                this.setServletName(this._servletClassName + "-" + protocolName);
            } else {
                this.setServletName(this._servletClassName);
            }
        }
        if (this._jndiName != null) {
            this.validateClass(true);
            servlet = this.createServlet(false);
            try {
                Jndi.bindDeepShort(this._jndiName, servlet);
            }
            catch (NamingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (this._var != null) {
            this.validateClass(true);
            servlet = this.createServlet(false);
            WebBeansContainer webBeans = WebBeansContainer.create();
            webBeans.addSingleton(servlet, this._var);
        }
    }

    protected void validateClass(boolean requireClass) throws ServletException {
        if (this._runAt != null || this._loadOnStartup >= 0) {
            requireClass = true;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (this._servletClassName != null && !this._servletClassName.equals("invoker")) {
            try {
                this._servletClass = Class.forName(this._servletClassName, false, loader);
            }
            catch (ClassNotFoundException e) {
                if (e instanceof CompileException) {
                    throw this.error(e);
                }
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._servletClass == null) {
                if (requireClass) {
                    throw this.error(L.l("'{0}' is not a known servlet.  Servlets belong in the classpath, often in WEB-INF/classes.", (Object)this._servletClassName));
                }
                String location = this._location != null ? this._location : "";
                log.warning(L.l(location + "'{0}' is not a known servlet.  Servlets belong in the classpath, often in WEB-INF/classes.", (Object)this._servletClassName));
                return;
            }
            Config.checkCanInstantiate(this._servletClass);
            if (!Servlet.class.isAssignableFrom(this._servletClass) && this._protocolConfig == null) {
                throw this.error(L.l("'{0}' must implement javax.servlet.Servlet or have a <protocol>.  All servlets must implement the Servlet interface.", (Object)this._servletClassName));
            }
        }
    }

    public void checkConstructor() throws ServletException {
        Constructor<?>[] constructors = this._servletClass.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null) {
            throw this.error(L.l("'{0}' must have a zero arg constructor.  Servlets must have public zero-arg constructors.\n{1} is not a valid constructor.", (Object)this._servletClassName, constructors[0]));
        }
        if (!Modifier.isPublic(zeroArg.getModifiers())) {
            throw this.error(L.l("'{0}' must be public.  '{1}' must have a public, zero-arg constructor.", zeroArg, (Object)this._servletClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        long nextTime22;
        try {
            try {
                log.fine(this + " cron");
                FilterChain chain = this.createServletChain();
                StubServletRequest req = new StubServletRequest();
                StubServletResponse res = new StubServletResponse();
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var6_7 = null;
                long nextTime22 = this._runAt.getNextTimeout(Alarm.getCurrentTime());
                Alarm nextAlarm = this._alarm;
                if (nextAlarm == null) return;
                alarm.queue(nextTime22 - Alarm.getCurrentTime());
                return;
            }
            Object var6_6 = null;
            nextTime22 = this._runAt.getNextTimeout(Alarm.getCurrentTime());
            Alarm nextAlarm = this._alarm;
            if (nextAlarm == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            long nextTime22 = this._runAt.getNextTimeout(Alarm.getCurrentTime());
            Alarm nextAlarm = this._alarm;
            if (nextAlarm == null) throw throwable;
            alarm.queue(nextTime22 - Alarm.getCurrentTime());
            throw throwable;
        }
        alarm.queue(nextTime22 - Alarm.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChain createServletChain() throws ServletException {
        ServletConfigImpl servletConfigImpl = this;
        synchronized (servletConfigImpl) {
            if (this._servletChain != null) {
                return this._servletChain;
            }
            return this.createServletChainImpl();
        }
    }

    private FilterChain createServletChainImpl() throws ServletException {
        String jspFile = this.getJspFile();
        Object servletChain = null;
        if (jspFile != null) {
            QServlet jsp = (QServlet)this._servletManager.createServlet("resin-jsp");
            servletChain = new PageFilterChain(this._servletContext, jsp, jspFile, this);
            return servletChain;
        }
        this.validateClass(true);
        Class servletClass = this.getServletClass();
        if (servletClass == null) {
            throw new IllegalStateException(L.l("servlet class for {0} can't be null", (Object)this.getServletName()));
        }
        servletChain = QServlet.class.isAssignableFrom(servletClass) ? new PageFilterChain(this._servletContext, (QServlet)this.createServlet(false)) : (SingleThreadModel.class.isAssignableFrom(servletClass) ? new SingleThreadServletFilterChain(this) : (this._protocolConfig != null ? new WebServiceFilterChain(this) : (CometServlet.class.isAssignableFrom(servletClass) ? new CometServletFilterChain(this) : new ServletFilterChain(this))));
        if (this._roleMap != null) {
            servletChain = new SecurityRoleMapFilterChain((FilterChain)servletChain, this._roleMap);
        }
        return servletChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object createServlet(boolean isNew) throws ServletException {
        if (this._servlet != null && !isNew) {
            return this._servlet;
        }
        Object servlet = null;
        if (Alarm.getCurrentTime() < this._nextInitTime) {
            throw this._initException;
        }
        try {
            ServletConfigImpl servletConfigImpl = this;
            synchronized (servletConfigImpl) {
                if (!isNew && this._servlet != null) {
                    return this._servlet;
                }
                servlet = this.createServletImpl();
                if (!isNew) {
                    this._servlet = servlet;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.finer("Servlet[" + this._servletName + "] active");
            }
            if (!isNew) {
                try {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("type", this._servlet.getClass().getSimpleName());
                    props.put("name", this._servletName);
                    Jmx.register(this._servlet, props);
                }
                catch (Exception e) {
                    log.finest(e.toString());
                }
                if (this._runAt != null && this._alarm != null) {
                    long nextTime = this._runAt.getNextTimeout(Alarm.getCurrentTime());
                    this._alarm.queue(nextTime - Alarm.getCurrentTime());
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.finer("Servlet[" + this._servletName + "] active");
            }
            return servlet;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    Servlet createProtocolServlet() throws ServletException {
        try {
            Object service = this.createServletImpl();
            if (this._protocolFactory == null) {
                this._protocolFactory = this._protocolConfig.createFactory();
            }
            Servlet servlet = this._protocolFactory.createServlet(this._servletClass, service);
            servlet.init((ServletConfig)this);
            return servlet;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Object createServletImpl() throws Exception {
        Object servlet;
        Class servletClass = this.getServletClass();
        if (this._jspFile != null) {
            servlet = this.createJspServlet(this._servletName, this._jspFile);
            if (servlet == null) {
                throw new ServletException(L.l("'{0}' is a missing JSP file.", (Object)this._jspFile));
            }
        } else if (servletClass != null) {
            WebBeansContainer webBeans = WebBeansContainer.create();
            this._comp = (ComponentImpl)webBeans.createTransient(servletClass);
            servlet = this._comp.createNoInit();
        } else {
            throw new ServletException(L.l("Null servlet class for '{0}'.", (Object)this._servletName));
        }
        this.configureServlet(servlet);
        try {
            if (!(servlet instanceof Page) && servlet instanceof Servlet) {
                Object servletObj = servlet;
                servletObj.init((ServletConfig)this);
            }
        }
        catch (UnavailableException e) {
            this.setInitException((ServletException)((Object)e));
            throw e;
        }
        return servlet;
    }

    void configureServlet(Object servlet) {
        ContainerProgram init = this.getInit();
        if (init != null) {
            init.configure(servlet);
        }
        Config.init(servlet);
    }

    private Servlet createJspServlet(String servletName, String jspFile) throws ServletException {
        try {
            ServletConfigImpl jspConfig = this._servletManager.getServlet("resin-jsp");
            QServlet jsp = (QServlet)jspConfig.createServlet(false);
            Page page = jsp.getPage(servletName, jspFile, this);
            return page;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void killServlet() {
        Object servlet = this._servlet;
        this._servlet = null;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        if (this._comp != null) {
            this._comp.destroy(servlet);
        }
        if (servlet instanceof Servlet) {
            ((Servlet)servlet).destroy();
        }
    }

    public void close() {
        this.killServlet();
        this._alarm = null;
    }

    protected ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    protected ConfigException error(String msg, Throwable e) {
        if (this._location != null) {
            return new LineConfigException(this._location + msg, e);
        }
        return new ConfigException(msg, e);
    }

    protected RuntimeException error(Throwable e) {
        if (this._location != null) {
            return new LineConfigException(this._location + e.getMessage(), e);
        }
        return ConfigException.create((Throwable)e);
    }

    public String toString() {
        return "ServletConfigImpl[name=" + this._servletName + ",class=" + this._servletClass + "]";
    }
}

