/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.AbstractFilterChain;
import com.caucho.server.dispatch.ServletConfigImpl;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletFilterChain
extends AbstractFilterChain {
    public static String SERVLET_NAME = "javax.servlet.error.servlet_name";
    private ServletConfigImpl _config;
    private Servlet _servlet;

    public ServletFilterChain(ServletConfigImpl config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._config = config;
    }

    public String getServletName() {
        return this._config.getServletName();
    }

    public HashMap<String, String> getRoleMap() {
        return this._config.getRoleMap();
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._servlet == null) {
            try {
                this._servlet = (Servlet)this._config.createServlet(false);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            this._servlet.service(request, response);
        }
        catch (UnavailableException e) {
            this._servlet = null;
            this._config.setInitException((ServletException)((Object)e));
            this._config.killServlet();
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (ServletException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (IOException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (RuntimeException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
    }

    @Override
    public boolean doResume(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getServletName() + "]";
    }
}

