/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.servlet.comet.CometFilterChain;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletInvocation {
    static final Logger log = Logger.getLogger(ServletInvocation.class.getName());
    static final L10N L = new L10N(ServletInvocation.class);
    private final boolean _isFiner;
    private static final ThreadLocal<ServletRequest> _requestThreadLocal = new ThreadLocal();
    private ClassLoader _classLoader;
    private String _contextPath = "";
    private String _contextUri;
    private String _servletPath;
    private String _pathInfo;
    private String _queryString;
    private String _servletName;
    private FilterChain _filterChain;
    private AtomicLong _requestCount = new AtomicLong();
    private HashMap<String, String> _securityRoleMap;

    public ServletInvocation() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this._isFiner = log.isLoggable(Level.FINER);
    }

    public final String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String path) {
        this._contextPath = path;
    }

    public void setContextURI(String contextURI) {
        this._contextUri = contextURI;
        this._servletPath = contextURI;
    }

    public final String getContextURI() {
        return this._contextUri;
    }

    public final String getServletPath() {
        return this._servletPath;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public final String getPathInfo() {
        return this._pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public final String getQueryString() {
        return this._queryString;
    }

    public final void setQueryString(String queryString) {
        this._queryString = queryString;
    }

    public void setClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setFilterChain(FilterChain chain) {
        this._filterChain = chain;
    }

    public FilterChain getFilterChain() {
        return this._filterChain;
    }

    public HashMap<String, String> getSecurityRoleMap() {
        return this._securityRoleMap;
    }

    public void setSecurityRoleMap(HashMap<String, String> roleMap) {
        this._securityRoleMap = roleMap;
    }

    public long getRequestCount() {
        return this._requestCount.get();
    }

    public static ServletRequest getContextRequest() {
        return _requestThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this._requestCount.incrementAndGet();
        ThreadLocal<ServletRequest> requestThreadLocal = _requestThreadLocal;
        ServletRequest oldRequest = requestThreadLocal.get();
        try {
            requestThreadLocal.set(request);
            if (this._isFiner) {
                log.finer("Dispatch '" + this._contextUri + "' to " + this._filterChain);
            }
            this._filterChain.doFilter(request, response);
            Object var6_5 = null;
            requestThreadLocal.set(oldRequest);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            requestThreadLocal.set(oldRequest);
            throw throwable;
        }
    }

    public boolean doResume(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this._filterChain instanceof CometFilterChain) {
            CometFilterChain filterChain = (CometFilterChain)this._filterChain;
            return filterChain.doResume(request, response);
        }
        return false;
    }

    public void copyFrom(ServletInvocation invocation) {
        this._classLoader = invocation._classLoader;
        this._contextPath = invocation._contextPath;
        this._contextUri = invocation._contextUri;
        this._servletPath = invocation._servletPath;
        this._pathInfo = invocation._pathInfo;
        this._queryString = invocation._queryString;
        this._servletName = invocation._servletName;
        this._filterChain = invocation._filterChain;
        this._securityRoleMap = invocation._securityRoleMap;
    }

    public String toString() {
        return "ServletInvocation[" + this._contextUri + "]";
    }
}

