/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class ServletManager {
    static final Logger log = Logger.getLogger(ServletManager.class.getName());
    static final L10N L = new L10N(ServletManager.class);
    private HashMap<String, ServletConfigImpl> _servlets = new HashMap();
    private ArrayList<ServletConfigImpl> _servletList = new ArrayList();
    private ArrayList<ServletConfigImpl> _cronList = new ArrayList();
    private boolean _isLazyValidate;

    public void setLazyValidate(boolean isLazy) {
        this._isLazyValidate = isLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServlet(ServletConfigImpl config) throws ServletException {
        if (config.getServletContext() == null) {
            throw new NullPointerException();
        }
        config.setServletManager(this);
        HashMap<String, ServletConfigImpl> hashMap = this._servlets;
        synchronized (hashMap) {
            if (this._servlets.get(config.getServletName()) != null) {
                for (int i = this._servletList.size() - 1; i >= 0; --i) {
                    ServletConfigImpl oldConfig = this._servletList.get(i);
                    if (!config.getServletName().equals(oldConfig.getServletName())) continue;
                    this._servletList.remove(i);
                    break;
                }
            }
            try {
                config.validateClass(!this._isLazyValidate);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, e.toString(), e);
                }
                if (e instanceof ConfigException) {
                    log.config(e.getMessage());
                }
                log.config(e.toString());
            }
            this._servlets.put(config.getServletName(), config);
            this._servletList.add(config);
        }
    }

    public ServletConfigImpl getServlet(String servletName) {
        return this._servlets.get(servletName);
    }

    @PostConstruct
    public void init() throws ServletException {
        ServletConfigImpl config;
        ArrayList<ServletConfigImpl> loadOnStartup = new ArrayList<ServletConfigImpl>();
        for (int j = 0; j < this._servletList.size(); ++j) {
            int i;
            config = this._servletList.get(j);
            if (config.getLoadOnStartup() == Integer.MIN_VALUE) continue;
            for (i = 0; i < loadOnStartup.size(); ++i) {
                ServletConfigImpl config2 = (ServletConfigImpl)loadOnStartup.get(i);
                if (config.getLoadOnStartup() >= config2.getLoadOnStartup()) continue;
                loadOnStartup.add(i, config);
                break;
            }
            if (i == loadOnStartup.size()) {
                loadOnStartup.add(config);
            }
            if (config.getRunAt() == null) continue;
            this._cronList.add(config);
        }
        for (int i = 0; i < loadOnStartup.size(); ++i) {
            config = (ServletConfigImpl)loadOnStartup.get(i);
            try {
                config.createServlet(false);
                continue;
            }
            catch (ServletException e) {
                if (config.getJspFile() == null) {
                    throw e;
                }
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public FilterChain createServletChain(String servletName) throws ServletException {
        ServletConfigImpl config = this._servlets.get(servletName);
        if (config == null) {
            throw new ServletConfigException(L.l("'{0}' is not a known servlet.  Servlets must be defined by <servlet> before being used.", (Object)servletName));
        }
        return config.createServletChain();
    }

    public Servlet createServlet(String servletName) throws ServletException {
        ServletConfigImpl config = this._servlets.get(servletName);
        if (config == null) {
            throw new ServletException(L.l("'{0}' is not a known servlet.  Servlets must be defined by <servlet> before being used.", (Object)servletName));
        }
        return (Servlet)config.createServlet(false);
    }

    ServletConfigImpl getServletConfig(String servletName) {
        return this._servlets.get(servletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<ServletConfigImpl> servletList = new ArrayList<ServletConfigImpl>();
        if (this._servletList != null) {
            ArrayList<ServletConfigImpl> arrayList = this._servletList;
            synchronized (arrayList) {
                servletList.addAll(this._servletList);
            }
        }
        for (int i = 0; i < servletList.size(); ++i) {
            ServletConfigImpl config = (ServletConfigImpl)servletList.get(i);
            try {
                config.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

