/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.log.Log;
import com.caucho.make.DependencyContainer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.PrecompilePageFilterChain;
import com.caucho.server.dispatch.RedirectFilterChain;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.SubInvocation;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMapper {
    static final Logger log = Log.open(ServletMapper.class);
    static final L10N L = new L10N(ServletMapper.class);
    private ServletContext _servletContext;
    private ServletManager _servletManager;
    private UrlMap<String> _servletMap = new UrlMap();
    private ArrayList<String> _welcomeFileList = new ArrayList();
    private HashMap<String, ServletMapping> _regexpMap = new HashMap();
    private ArrayList<String> _ignorePatterns = new ArrayList();
    private String _defaultServlet;

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void addUrlRegexp(String regexp, ServletMapping mapping) throws ServletException {
        this._servletMap.addRegexp(regexp, regexp);
        this._regexpMap.put(regexp, mapping);
    }

    void addUrlMapping(String urlPattern, String servletName, ServletMapping mapping) throws ServletException {
        try {
            if (servletName == null) {
                throw new ServletConfigException(L.l("servlet needs a servlet-name."));
            }
            if (!(servletName.equals("invoker") || servletName.equals("plugin_match") || servletName.equals("plugin-match"))) {
                if (servletName.equals("plugin_ignore") || servletName.equals("plugin-ignore")) {
                    if (urlPattern != null) {
                        this._ignorePatterns.add(urlPattern);
                    }
                    return;
                }
                if (this._servletManager.getServlet(servletName) == null) {
                    throw new ServletConfigException(L.l("`{0}' is an unknown servlet-name.  servlet-mapping requires that the named servlet be defined in a <servlet> configuration before the <servlet-mapping>.", (Object)servletName));
                }
            }
            if ("/".equals(urlPattern)) {
                this._defaultServlet = servletName;
            } else if (mapping.isStrictMapping()) {
                this._servletMap.addStrictMap(urlPattern, null, servletName);
            } else {
                this._servletMap.addMap(urlPattern, servletName);
            }
            log.config("servlet-mapping " + urlPattern + " -> " + servletName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setDefaultServlet(String servletName) throws ServletException {
        this._defaultServlet = servletName;
    }

    public void addWelcomeFile(String fileName) {
        this._welcomeFileList.add(fileName);
    }

    public void setWelcomeFileList(ArrayList<String> list) {
        this._welcomeFileList.clear();
        this._welcomeFileList.addAll(list);
    }

    public FilterChain mapServlet(ServletInvocation invocation) throws ServletException {
        FilterChain chain;
        ServletConfigImpl config;
        ServletMapping servletRegexp;
        String contextURI = invocation.getContextURI();
        String servletName = null;
        ArrayList<String> vars = new ArrayList<String>();
        invocation.setClassLoader(Thread.currentThread().getContextClassLoader());
        if (this._servletMap != null && (servletRegexp = this._regexpMap.get(servletName = this._servletMap.map(contextURI, vars))) != null) {
            servletName = servletRegexp.initRegexp(this._servletContext, this._servletManager, vars);
        }
        if (servletName == null) {
            try {
                InputStream is = this._servletContext.getResourceAsStream(contextURI);
                if (is != null) {
                    is.close();
                    servletName = this._defaultServlet;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (servletName == null) {
            for (int i = 0; i < this._welcomeFileList.size(); ++i) {
                String file = this._welcomeFileList.get(i);
                try {
                    String welcomeURI = contextURI.endsWith("/") ? contextURI + file : contextURI + '/' + file;
                    InputStream is = this._servletContext.getResourceAsStream(welcomeURI);
                    if (is != null) {
                        is.close();
                    }
                    if (is == null) continue;
                    if (!contextURI.endsWith("/") && !(invocation instanceof SubInvocation)) {
                        String contextPath = invocation.getContextPath();
                        return new RedirectFilterChain(contextPath + contextURI + "/");
                    }
                    servletName = this._servletMap.map(welcomeURI, vars);
                    if (servletName == null && this._defaultServlet == null) continue;
                    contextURI = welcomeURI;
                    if (!(invocation instanceof Invocation)) break;
                    Invocation inv = (Invocation)invocation;
                    inv.setContextURI(contextURI);
                    break;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (servletName == null) {
            servletName = this._defaultServlet;
            vars.clear();
            vars.add(contextURI);
            this.addWelcomeFileDependency(invocation);
        }
        if (servletName == null) {
            log.fine(L.l("'{0}' has no default servlet defined", (Object)contextURI));
            return new ErrorFilterChain(404);
        }
        String servletPath = vars.get(0);
        invocation.setServletPath(servletPath);
        if (servletPath.length() < contextURI.length()) {
            invocation.setPathInfo(contextURI.substring(servletPath.length()));
        } else {
            invocation.setPathInfo(null);
        }
        ServletMapping regexp = this._regexpMap.get(servletName);
        if (regexp != null) {
            servletName = regexp.initRegexp(this._servletContext, this._servletManager, vars);
        }
        if (servletName.equals("invoker")) {
            servletName = this.handleInvoker(invocation);
        }
        invocation.setServletName(servletName);
        if (log.isLoggable(Level.FINE)) {
            log.fine("invoke (uri:" + contextURI + " -> " + servletName + ")");
        }
        if ((config = this._servletManager.getServlet(servletName)) != null) {
            invocation.setSecurityRoleMap(config.getRoleMap());
        }
        if ((chain = this._servletManager.createServletChain(servletName)) instanceof PageFilterChain) {
            PageFilterChain pageChain = (PageFilterChain)chain;
            chain = PrecompilePageFilterChain.create(invocation, pageChain);
        }
        return chain;
    }

    private void addWelcomeFileDependency(ServletInvocation servletInvocation) {
        if (!(servletInvocation instanceof Invocation)) {
            return;
        }
        Invocation invocation = (Invocation)servletInvocation;
        String contextURI = invocation.getContextURI();
        DependencyContainer dependencyList = new DependencyContainer();
        WebApp app = (WebApp)this._servletContext;
        Path contextPath = app.getAppDir().lookup(app.getRealPath(contextURI));
        if (!contextPath.isDirectory()) {
            return;
        }
        for (int i = 0; i < this._welcomeFileList.size(); ++i) {
            String file = this._welcomeFileList.get(i);
            String realPath = app.getRealPath(contextURI + "/" + file);
            Path path = app.getAppDir().lookup(realPath);
            dependencyList.add((Dependency)new Depend(path));
        }
        dependencyList.clearModified();
        invocation.setDependency(dependencyList);
    }

    private String handleInvoker(ServletInvocation invocation) throws ServletException {
        String tail = invocation.getPathInfo() != null ? invocation.getPathInfo() : invocation.getServletPath();
        if (!tail.startsWith("/")) {
            throw new ServletException("expected '/' starting  sp:" + invocation.getServletPath() + " pi:" + invocation.getPathInfo() + " sn:invocation" + invocation);
        }
        int next = tail.indexOf(47, 1);
        String servletName = next < 0 ? tail.substring(1) : tail.substring(1, next);
        if (servletName.startsWith("com.caucho")) {
            throw new ServletConfigException(L.l("servlet `{0}' forbidden from invoker. com.caucho.* classes must be defined explicitly in a <servlet> declaration.", (Object)servletName));
        }
        if (servletName.equals("")) {
            throw new ServletConfigException(L.l("invoker needs a servlet name in URL `{0}'.", (Object)invocation.getContextURI()));
        }
        this.addServlet(servletName);
        String servletPath = invocation.getServletPath();
        if (invocation.getPathInfo() != null) {
            if (next < 0) {
                invocation.setServletPath(servletPath + tail);
                invocation.setPathInfo(null);
            } else if (next < tail.length()) {
                invocation.setServletPath(servletPath + tail.substring(0, next));
                invocation.setPathInfo(tail.substring(next));
            } else {
                invocation.setServletPath(servletPath + tail);
                invocation.setPathInfo(null);
            }
        }
        return servletName;
    }

    public String getServletPattern(String uri) {
        ArrayList<String> vars = new ArrayList<String>();
        String value = null;
        if (this._servletMap != null) {
            value = this._servletMap.map(uri, vars);
        }
        if (value == null) {
            return null;
        }
        return uri;
    }

    public ArrayList<String> getURLPatterns() {
        ArrayList<String> patterns = this._servletMap.getURLPatterns();
        return patterns;
    }

    public ArrayList<String> getIgnorePatterns() {
        return this._ignorePatterns;
    }

    private void addServlet(String servletName) throws ServletException {
        if (this._servletManager.getServlet(servletName) != null) {
            return;
        }
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this._servletContext);
        config.setServletName(servletName);
        try {
            config.setServletClass(servletName);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        config.init();
        this._servletManager.addServlet(config);
    }

    public void destroy() {
        this._servletManager.destroy();
    }
}

