/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.el.ELContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMapping
extends ServletConfigImpl {
    private static final L10N L = new L10N(ServletMapping.class);
    private ArrayList<Mapping> _mappingList = new ArrayList();
    private boolean _isStrictMapping;

    public void addURLPattern(String pattern) {
        if (pattern.indexOf(10) > -1) {
            throw new ConfigException(L.l("`{0}' cannot contain newline", (Object)"url-pattern"));
        }
        this._mappingList.add(new Mapping(pattern, null));
        if (this.getServletName() == null) {
            this.setServletName(pattern);
        }
    }

    public void addURLRegexp(String pattern) {
        this._mappingList.add(new Mapping(null, pattern));
    }

    public boolean isStrictMapping() {
        return this._isStrictMapping;
    }

    public void setStrictMapping(boolean isStrictMapping) {
        this._isStrictMapping = isStrictMapping;
    }

    public void init(ServletMapper mapper) throws ServletException {
        boolean hasInit = false;
        for (int i = 0; i < this._mappingList.size(); ++i) {
            Mapping mapping = this._mappingList.get(i);
            String urlPattern = mapping.getUrlPattern();
            String urlRegexp = mapping.getUrlRegexp();
            if (this.getServletName() == null && this.getServletClassName() != null && urlPattern != null) {
                this.setServletName(urlPattern);
            }
            if (urlPattern != null && !hasInit) {
                hasInit = true;
                super.init();
                if (this.getServletClassName() != null) {
                    mapper.getServletManager().addServlet(this);
                }
            }
            if (urlPattern != null) {
                mapper.addUrlMapping(urlPattern, this.getServletName(), this);
                continue;
            }
            mapper.addUrlRegexp(urlRegexp, this);
        }
    }

    String initRegexp(ServletContext webApp, ServletManager manager, ArrayList<String> vars) throws ServletException {
        ELContext env = EL.getEnvironment();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext(new MapVariableResolver(map));
        String rawName = this.getServletName();
        String rawClassName = this.getServletClassName();
        if (rawName == null) {
            rawName = rawClassName;
        }
        if (rawClassName == null) {
            rawClassName = rawName;
        }
        try {
            String servletName = EL.evalString(rawName, mapEnv);
            if (manager.getServletConfig(servletName) != null) {
                return servletName;
            }
            String className = EL.evalString(rawClassName, mapEnv);
            try {
                WebApp app = (WebApp)this.getServletContext();
                Class<?> cl = Class.forName(className, false, app.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
            ServletConfigImpl config = new ServletConfigImpl();
            config.setServletName(servletName);
            config.setServletClass(className);
            config.setServletContext(webApp);
            ContainerProgram program = this.getInit();
            if (program != null) {
                config.setInit(program);
            }
            config.init();
            manager.addServlet(config);
            return servletName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServletMapping[");
        for (int i = 0; i < this._mappingList.size(); ++i) {
            Mapping mapping = this._mappingList.get(i);
            if (mapping.getUrlPattern() != null) {
                builder.append("url-pattern=");
                builder.append(mapping.getUrlPattern());
                builder.append(", ");
                continue;
            }
            if (mapping.getUrlRegexp() == null) continue;
            builder.append("url-regexp=");
            builder.append(mapping.getUrlRegexp());
            builder.append(", ");
        }
        builder.append(", name=");
        builder.append(this.getServletName());
        builder.append("]");
        return builder.toString();
    }

    static class Mapping {
        private final String _urlPattern;
        private final String _urlRegexp;

        Mapping(String urlPattern, String urlRegexp) {
            this._urlPattern = urlPattern;
            this._urlRegexp = urlRegexp;
        }

        String getUrlPattern() {
            return this._urlPattern;
        }

        String getUrlRegexp() {
            return this._urlRegexp;
        }

        public String toString() {
            return "ServletMapping[" + this._urlPattern + ", " + this._urlRegexp + "]";
        }
    }
}

