/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigELContext;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.el.ELContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRegexp {
    private static final L10N L = new L10N(ServletRegexp.class);
    private String _urlRegexp;
    private String _servletName;
    private String _servletClassName;
    private ContainerProgram _program = new ContainerProgram();

    public void setURLRegexp(String pattern) {
        this._urlRegexp = pattern;
    }

    public String getURLRegexp() {
        return this._urlRegexp;
    }

    public void setServletName(RawString string) {
        this._servletName = string.getValue();
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletClass(RawString string) {
        this._servletClassName = string.getValue();
    }

    public String getServletClass() {
        return this._servletClassName;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public ContainerProgram getBuilderProgram() {
        return this._program;
    }

    String initRegexp(ServletContext application, ServletManager manager, ArrayList<String> vars) throws ServletException {
        ELContext env = EL.getEnvironment();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext(new MapVariableResolver(map));
        String rawName = this._servletName;
        String rawClassName = this._servletClassName;
        if (rawName == null) {
            rawName = rawClassName;
        }
        try {
            String servletName = EL.evalString(rawName, mapEnv);
            if (manager.getServletConfig(servletName) != null) {
                return servletName;
            }
            String className = EL.evalString(rawClassName, mapEnv);
            ServletConfigImpl config = new ServletConfigImpl();
            config.setServletName(servletName);
            config.setServletClass(className);
            config.setServletContext(application);
            this._program.configure(config);
            config.init();
            manager.addServlet(config);
            return servletName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String toString() {
        return "ServletRegexp[" + this._urlRegexp + "]";
    }
}

