/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.ServletConfigImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(WebServiceFilterChain.class.getName());
    public static final String SERVLET_NAME = "javax.servlet.error.servlet_name";
    private ServletConfigImpl _config;
    private Servlet _skeleton;

    public WebServiceFilterChain(ServletConfigImpl config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._config = config;
    }

    public String getServletName() {
        return this._config.getServletName();
    }

    public HashMap<String, String> getRoleMap() {
        return this._config.getRoleMap();
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._skeleton == null) {
            this._skeleton = this._config.createProtocolServlet();
        }
        try {
            this._skeleton.service(request, response);
        }
        catch (UnavailableException e) {
            this._skeleton = null;
            this._config.setInitException((ServletException)((Object)e));
            this._config.killServlet();
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (ServletException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (IOException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (RuntimeException e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw e;
        }
        catch (Exception e) {
            request.setAttribute(SERVLET_NAME, (Object)this._config.getServletName());
            throw new ServletException((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._skeleton + "]";
    }
}

