/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.Config;
import com.caucho.log.Log;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.server.e_app.EntAppClient;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientDeployController
extends ExpandDeployController<EntAppClient> {
    private static final Logger log = Log.open(AppClientDeployController.class);
    private static final L10N L = new L10N(AppClientDeployController.class);
    private String _name = "";
    private JarPath _clientJar;
    private ArrayList<Path> _configList = new ArrayList();
    private boolean _isInit;

    public AppClientDeployController() {
        super("client");
    }

    @Override
    public void setRootDirectory(Path path) {
        super.setRootDirectory(path);
    }

    public void addConfig(Path path) {
        this._configList.add(path);
    }

    public void addEar(Path path) {
        System.out.println("ADD EAR: " + path);
        JarPath jar = JarPath.create(path);
        Path app = jar.lookup("META-INF/application.xml");
        System.out.println("  APP: " + app + " " + app.exists());
        if (app.exists()) {
            this.addConfig(app);
        }
        app = jar.lookup("META-INF/resin-application.xml");
        System.out.println("  APP: " + app + " " + app.exists());
        if (app.exists()) {
            this.addConfig(app);
        }
    }

    public void main(String[] args) throws Throwable {
        System.out.println("MAIN()");
        this.init();
        this.start();
        EntAppClient appClient = (EntAppClient)this.request();
        if (appClient != null) {
            appClient.main(args);
        }
    }

    public void main(String mainClass, String[] args) throws Throwable {
        System.out.println("MAIN: " + mainClass);
        this.init();
        this.start();
        EntAppClient appClient = (EntAppClient)this.request();
        System.out.println("MAIN: " + appClient + " " + mainClass);
        if (appClient != null) {
            appClient.main(mainClass, args);
        }
    }

    public ClassLoader getLoader() {
        this.init();
        this.start();
        EntAppClient appClient = (EntAppClient)this.request();
        if (appClient != null) {
            return appClient.getClassLoader();
        }
        return null;
    }

    @Override
    protected EntAppClient instantiateDeployInstance() {
        return new EntAppClient(this, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(EntAppClient appClient) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path rootDir = null;
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            appClient.setArchivePath(this.getArchivePath());
            rootDir = this.getRootDirectory();
            if (rootDir == null) {
                throw new NullPointerException("Null root-directory");
            }
            appClient.setRootDirectory(rootDir);
            thread.setContextClassLoader(appClient.getClassLoader());
            Vfs.setPwd(rootDir);
            this.addManifestClassPath();
            this.configApplication(appClient);
            Path curr = rootDir;
            for (String s : curr) {
                Path path = curr.lookup(s);
                if (path.isDirectory() || !s.endsWith(".jar")) continue;
                appClient.getClassLoader().addJar(path);
                this._clientJar = JarPath.create(path);
                this.configClientApplication(appClient);
            }
            for (int i = 0; i < this._configList.size(); ++i) {
                this.configClientConfig(appClient, this._configList.get(i));
            }
            appClient.init();
            Object var10_10 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void configApplication(EntAppClient appClient) throws Exception {
        Path rootDir = this.getRootDirectory();
        Path xml = rootDir.lookup("META-INF/application.xml");
        if (xml.canRead()) {
            new Config().configureBean((Object)appClient, xml);
        }
        if ((xml = rootDir.lookup("META-INF/resin-application.xml")).canRead()) {
            new Config().configureBean((Object)appClient, xml);
        }
    }

    private void configClientApplication(EntAppClient appClient) throws Exception {
        if (this._clientJar == null) {
            return;
        }
        Path xml = this._clientJar.lookup("META-INF/application-client.xml");
        if (!xml.canRead()) {
            return;
        }
        new Config().configureBean((Object)appClient, xml, "com/caucho/server/e_app/app-client.rnc");
    }

    private void configClientConfig(EntAppClient appClient, Path xml) throws Exception {
        if (!xml.canRead()) {
            return;
        }
        new Config().configureBean((Object)appClient, xml);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AppClientDeployController)) {
            return false;
        }
        AppClientDeployController controller = (AppClientDeployController)o;
        return this.getId().equals(controller.getId());
    }

    @Override
    public String toString() {
        return "AppClientDeployController[" + this.getId() + "]";
    }
}

