/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.log.Log;
import com.caucho.management.j2ee.J2EEApplication;
import com.caucho.management.j2ee.J2EEManagedObject;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.e_app.EarAdmin;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployController
extends EnvironmentDeployController<EnterpriseApplication, EarConfig> {
    private static final Logger log = Log.open(EarDeployController.class);
    private static final L10N L = new L10N(EarDeployController.class);
    private WebAppContainer _container;
    private Path _earRootDir;
    private ArrayList<EarConfig> _eAppDefaults = new ArrayList();
    private EarAdmin _admin = new EarAdmin(this);
    private J2EEApplication _j2eeAdmin;

    EarDeployController(String name, WebAppContainer container, EarConfig config) {
        super(config);
        this._container = container;
        if (container != null) {
            this._eAppDefaults.addAll(container.getEarDefaultList());
        }
    }

    EarDeployController(String name, Path rootDirectory, WebAppContainer container) {
        super(name, rootDirectory);
        this._container = container;
        if (container != null) {
            this._eAppDefaults.addAll(container.getEarDefaultList());
        }
    }

    public void setId(String name) {
        this.getVariableMap().put("name", name);
    }

    public Path getEarRootDir() {
        return this._earRootDir;
    }

    public void setEarRootDir(Path rootDir) {
        this._earRootDir = rootDir;
    }

    @Override
    protected DeployControllerAdmin getDeployAdmin() {
        return this._admin;
    }

    @Override
    protected void initEnd() {
        super.initEnd();
        this._j2eeAdmin = new J2EEApplication(this);
        J2EEManagedObject.register(this._j2eeAdmin);
    }

    public WebAppController findWebAppController(String name) {
        try {
            EnterpriseApplication eApp = (EnterpriseApplication)this.request();
            if (eApp != null) {
                return eApp.findWebAppEntry(name);
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    @Override
    protected EnterpriseApplication instantiateDeployInstance() {
        return new EnterpriseApplication(this._container, this, this.getId());
    }

    protected Path calculateRootDirectory() throws ELException {
        Path rootDir = this.getRootDirectory();
        EnterpriseApplication eApp = (EnterpriseApplication)this.getDeployInstance();
        if (rootDir == null && eApp != null) {
            rootDir = eApp.getRootDirectory();
        }
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            J2EEManagedObject.unregister(this._j2eeAdmin);
            Object var4_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return super.destroy();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EarDeployController)) {
            return false;
        }
        EarDeployController entry = (EarDeployController)o;
        return this.getId().equals(entry.getId());
    }

    @Override
    public String toString() {
        return "EarDeployController[" + this.getId() + "]";
    }
}

