/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeployGenerator;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGeneratorAdmin;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.vfs.Path;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployGenerator
extends ExpandDeployGenerator<EarDeployController> {
    private final EarDeployGeneratorAdmin _admin = new EarDeployGeneratorAdmin(this);
    private String _urlPrefix = "";
    private WebAppContainer _parentContainer;
    private EarConfig _earDefault;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();

    public EarDeployGenerator(DeployContainer<EarDeployController> deployContainer, WebAppContainer parentContainer) {
        super(deployContainer, parentContainer.getRootDirectory());
        try {
            this.setExpandPrefix("_ear_");
            this.setExtension(".ear");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._parentContainer = parentContainer;
        this._earDefaultList.addAll(parentContainer.getEarDefaultList());
    }

    WebAppContainer getContainer() {
        return this._parentContainer;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setURLPrefix(String prefix) {
        this._urlPrefix = prefix;
    }

    public void addEarDefault(EarConfig config) {
        this._earDefaultList.add(config);
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
    }

    @Override
    protected void startImpl() throws ConfigException {
        super.startImpl();
        this._admin.register();
    }

    @Override
    protected String archiveNameToEntryName(String archiveName) {
        if (!archiveName.endsWith(".ear")) {
            return null;
        }
        return archiveName.substring(0, archiveName.length() - 4);
    }

    @Override
    public EarDeployController createController(String name) {
        Path rootDirectory;
        String archiveName = name + this.getExtension();
        Path archivePath = this.getArchiveDirectory().lookup(archiveName);
        if (archivePath.isDirectory()) {
            rootDirectory = this.getExpandDirectory().lookup(archiveName);
            archivePath = null;
        } else {
            rootDirectory = this.getExpandDirectory().lookup(this.getExpandName(name));
            if (!archivePath.canRead() && !rootDirectory.canRead()) {
                return null;
            }
        }
        EarDeployController controller = new EarDeployController(name, rootDirectory, this._parentContainer);
        controller.setArchivePath(archivePath);
        for (EarConfig config : this._earDefaultList) {
            controller.addConfigDefault(config);
        }
        return controller;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        super.destroyImpl();
    }
}

