/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.EjbRef;
import com.caucho.ejb.AbstractStubLoader;
import com.caucho.ejb.EJBClientInterface;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.e_app.AppClientConfig;
import com.caucho.server.e_app.AppClientDeployController;
import com.caucho.server.e_app.ApplicationConfig;
import com.caucho.server.e_app.WebModule;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class EntAppClient
implements DeployInstance,
EnvironmentBean {
    static final L10N L = new L10N(EntAppClient.class);
    static final Logger log = Log.open(EntAppClient.class);
    private EnvironmentClassLoader _loader;
    private String _name;
    private Path _rootDir;
    private Path _archivePath;
    private String _mainClass;
    private String _prefix = "";
    private AppClientDeployController _entry;
    private AbstractStubLoader _stubLoader;
    private ApplicationConfig _config;
    private JarPath _clientJar;
    private EJBClientInterface _ejbClient;
    private AppClientConfig _appClientConfig;
    private ArrayList<EjbLink> _links = new ArrayList();
    private HashMap<String, EjbRef> _ejbRefMap = new HashMap();
    private Throwable _configException;
    private Alarm _alarm;
    private final Lifecycle _lifecycle;

    private static void log(String message) {
        System.out.println(EntAppClient.class.getSimpleName() + ": " + message);
    }

    EntAppClient(AppClientDeployController entry, String name) {
        this._entry = entry;
        this._name = name;
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        this._loader = new EnvironmentClassLoader(parentLoader);
        this._loader.setId("EntAppClient[" + name + "]");
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        if (entry.getArchivePath() != null) {
            Environment.addDependency((Dependency)new Depend(entry.getArchivePath()), (ClassLoader)this._loader);
        }
    }

    public void setName(String name) {
        this._name = name;
        this._loader.setId("EntAppClient[" + name + "]");
    }

    public String getName() {
        return this._name;
    }

    public EJBClientInterface getEJBClient() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this._ejbClient == null) {
            Class<?> cl = Class.forName("com.caucho.iiop.IiopClient");
            this._ejbClient = (EJBClientInterface)cl.newInstance();
        }
        return this._ejbClient;
    }

    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setArchivePath(Path archivePath) {
        this._archivePath = archivePath;
    }

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public Module createModule() {
        return new Module();
    }

    public void addEjbRef(EjbRef ejbRef) {
        this._ejbRefMap.put(ejbRef.getEjbRefName(), ejbRef);
        this.addIiopStub(ejbRef.getHome());
        this.addIiopStub(ejbRef.getRemote());
    }

    private void addIiopStub(Class stubClass) {
        if (stubClass == null) {
            return;
        }
        try {
            if (this._stubLoader == null) {
                Class<?> iiopClass = Class.forName("com.caucho.iiop.IiopStubLoader");
                this._stubLoader = (AbstractStubLoader)iiopClass.newInstance();
                this._stubLoader.setPath(WorkDir.getLocalWorkDir());
                this._loader.addLoader(this._stubLoader);
            }
            this._stubLoader.addStubClass(stubClass.getName());
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.info(e.toString());
        }
    }

    Class getEjbHome(String ejbName) throws ConfigException {
        EjbRef ref = this._ejbRefMap.get(ejbName);
        if (ref != null) {
            return ref.getHome();
        }
        return null;
    }

    public void setMainClass(String mainClass) {
        this._mainClass = mainClass;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._loader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public EjbLink createEjbLink() {
        EjbLink link = new EjbLink();
        this._links.add(link);
        return link;
    }

    public SecurityRole createSecurityRole() {
        return new SecurityRole();
    }

    public void setSchemaLocation(String s) {
    }

    public void setVersion(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        EntAppClient.log("INIT: " + this._links);
        if (!this._lifecycle.toInit()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this._loader);
                Path rootDir = this.getRootDirectory();
                Vfs.setPwd(rootDir);
                Path workDir = this.getRootDirectory().lookup("META-INF/work");
                this._loader.addJar(workDir);
                WorkDir.setLocalWorkDir(workDir);
                for (EjbLink link : this._links) {
                    link.deploy();
                }
                Object var8_8 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.log(Level.WARNING, e.toString(), e);
                this._configException = e;
                Object var8_9 = null;
                thread.setContextClassLoader(oldLoader);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void configResinBinding() throws Exception {
        Path rootDir = this.getRootDirectory();
        Path xml = rootDir.lookup("META-INF/resin-client.xml");
        if (!xml.canRead()) {
            return;
        }
        new Config().configure((Object)this, xml);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isModifiedNow() {
        return false;
    }

    public boolean logModified(Logger log) {
        return false;
    }

    public boolean isDeployError() {
        return this._configException != null;
    }

    public boolean isDeployIdle() {
        return false;
    }

    public void start() {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
    }

    public void main(String[] args) throws Throwable {
        if (this._mainClass == null) {
            throw new IllegalStateException(L.l("main() method require a main class"));
        }
        this.main(this._mainClass, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String mainClassName, String[] args) throws Throwable {
        this.start();
        EntAppClient.log("MAIN: " + mainClassName);
        EntAppClient.log("C: " + System.getProperty("java.class.path"));
        if (this._configException != null) {
            throw this._configException;
        }
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0} is not active.", (Object)this));
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            Class<?> mainClass = Class.forName(mainClassName, false, this._loader);
            EntAppClient.log("MAIN:");
            Method main = mainClass.getMethod("main", String[].class);
            try {
                Class<?> cl = Class.forName("com.sun.ts.lib.implementation.sun.common.SunRIURL", false, this._loader);
                EntAppClient.log("CL: " + cl);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            main.invoke(null, new Object[]{args});
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
    }

    public String toString() {
        return "EntAppClient[" + this.getName() + "]";
    }

    public class Module {
        public void setId(String id) {
        }

        public void addWeb(WebModule web) throws Exception {
        }

        public void addEjb(Path path) throws Exception {
            EntAppClient.this.getClassLoader().addJar(path);
            EntAppClient.this.getEJBClient().addEJBJar(path);
            EntAppClient.this.getEJBClient().initEJBs();
        }

        public void addJava(Path path) throws Exception {
            if (!path.canRead()) {
                throw new ConfigException(L.l("<java> module {0} must be a valid path.", (Object)path));
            }
            EntAppClient.this.getClassLoader().addJar(path);
            EntAppClient.this._clientJar = JarPath.create(path);
            Manifest manifest = EntAppClient.this._clientJar.getManifest();
            String mainClass = manifest.getMainAttributes().getValue("Main-Class");
            EntAppClient.this.setMainClass(mainClass);
            Path appClient = EntAppClient.this._clientJar.lookup("META-INF/application-client.xml");
            if (appClient.canRead()) {
                new Config().configureBean((Object)EntAppClient.this, appClient);
            }
        }

        public void addConnector(String path) {
        }

        public void addAltDD(String path) {
        }
    }

    public class SecurityRole {
        public void setId(String id) {
        }

        public void addDescription(String description) {
        }

        public void setRoleName(String roleName) {
        }

        public void setRoleLink(String roleLink) {
        }
    }

    public class EjbLink {
        private String _ejbName;
        private String _jndiName;
        private Class _api;

        public void setEjbName(String ejbName) throws ConfigException {
            this._ejbName = ejbName;
        }

        public void setJndiName(String jndiName) {
            this._jndiName = jndiName;
        }

        public void deploy() throws Exception {
            EntAppClient.log("LINK: " + this._jndiName + " " + this._ejbName);
            String orbHost = System.getProperty("org.omg.CORBA.ORBInitialHost");
            String orbPort = System.getProperty("org.omg.CORBA.ORBInitialPort");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            env.put("java.naming.provider.url", "iiop://" + orbHost + ":" + orbPort);
            InitialContext ic = new InitialContext(env);
            Object ior = ic.lookup(this._jndiName);
            this._api = EntAppClient.this.getEjbHome(this._ejbName);
            if (this._api == null) {
                throw new ConfigException(L.l("'{0}' is an unknown ejb name.", (Object)this._ejbName));
            }
            Object value = PortableRemoteObject.narrow((Object)ior, (Class)this._api);
            EntAppClient.log("VALUE: " + value + " " + value.getClass() + " " + this._api);
            Jndi.rebindDeepShort(this._ejbName, value);
        }
    }
}

