/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.Icon;
import com.caucho.server.e_app.SecurityRole;
import com.caucho.server.e_app.WebModule;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseApplication
implements EnvironmentBean,
EnvironmentDeployInstance {
    static final L10N L = new L10N(EnterpriseApplication.class);
    static final Logger log = Logger.getLogger(EnterpriseApplication.class.getName());
    private static final EnvironmentLocal<EnterpriseApplication> _localEApp = new EnvironmentLocal();
    private EnvironmentClassLoader _loader;
    private String _name;
    private String _ejbServerJndiName = "java:comp/env/cmp";
    private Path _rootDir;
    private Path _earPath;
    private String _prefix = "";
    private EarDeployController _controller;
    private Path _webappsPath;
    private WebAppContainer _container;
    private String _version;
    private String _libraryDirectory;
    private boolean _hasModule;
    private ArrayList<Path> _ejbPaths = new ArrayList();
    private ArrayList<WebModule> _webConfigList = new ArrayList();
    private ArrayList<WebAppController> _webApps = new ArrayList();
    private Throwable _configException;
    private final Lifecycle _lifecycle;

    EnterpriseApplication(WebAppContainer container, EarDeployController controller, String name) {
        if (container == null || controller == null) {
            throw new NullPointerException();
        }
        this._container = container;
        this._controller = controller;
        this._name = name;
        ClassLoader parentLoader = container != null ? container.getClassLoader() : Thread.currentThread().getContextClassLoader();
        this._loader = new EnvironmentClassLoader(parentLoader);
        this._loader.setId("eapp:" + name);
        this._webappsPath = this._controller.getRootDirectory().lookup("webapps");
        WorkDir.setLocalWorkDir(this._controller.getRootDirectory().lookup("META-INF/work"), this._loader);
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        if (controller.getArchivePath() != null) {
            Environment.addDependency((Dependency)new Depend(controller.getArchivePath()), (ClassLoader)this._loader);
        }
        _localEApp.set(this, this._loader);
    }

    public static EnterpriseApplication getLocal() {
        return _localEApp.get();
    }

    public void setName(String name) {
        this._name = name;
        this._loader.setId("eapp:" + name + "");
    }

    public String getName() {
        return this._name;
    }

    public void setLibraryDirectory(String libraryDirectory) {
        this._libraryDirectory = libraryDirectory;
    }

    public String getLibraryDirectory() {
        return this._libraryDirectory;
    }

    public void setEjbServerJndiName(String name) {
        this._ejbServerJndiName = name;
    }

    @Override
    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._loader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setEarPath(Path earPath) {
        this._earPath = earPath;
    }

    public void setWebapps(Path webappsPath) {
        this._webappsPath = webappsPath;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void setId(String id) {
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setSchemaLocation(String schema) {
    }

    public void setDisplayName(String name) {
    }

    public void setDescription(String description) {
    }

    public void setIcon(Icon icon) {
    }

    public Module createModule() {
        this._hasModule = true;
        return new Module();
    }

    WebModule findWebModule(String webUri) {
        for (int i = 0; i < this._webConfigList.size(); ++i) {
            WebModule web = this._webConfigList.get(i);
            if (!webUri.equals(web.getWebURI())) continue;
            return web;
        }
        return null;
    }

    void addWebModule(WebModule webModule) {
        this._webConfigList.add(webModule);
    }

    public void addSecurityRole(SecurityRole role) {
    }

    @Override
    public boolean isModified() {
        return this._loader.isModified();
    }

    @Override
    public boolean isModifiedNow() {
        return this._loader.isModifiedNow();
    }

    @Override
    public boolean logModified(Logger log) {
        return this._loader.logModified(log);
    }

    @Override
    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        return false;
    }

    @Override
    public void setConfigException(Throwable e) {
        this._configException = e;
        for (WebAppController controller : this._webApps) {
            controller.setConfigException(e);
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        if (!this._lifecycle.toInit()) {
            return;
        }
        Vfs.setPwd(this._rootDir, this._loader);
        this._loader.addJarManifestClassPath(this._rootDir);
        if ("1.4".equals(this._version)) {
            this.fillDefaultLib();
        } else {
            this.fillDefaultModules();
        }
        if (this._ejbPaths.size() != 0) {
            EjbContainer ejbContainer = EjbContainer.create();
            for (Path path : this._ejbPaths) {
                ejbContainer.addRoot(path);
                this._loader.addJar(path);
            }
            this._loader.validate();
        }
        if (this._container != null) {
            this._container.clearCache();
        }
    }

    private void fillDefaultModules() {
        try {
            this.fillDefaultLib();
            for (String file : this._rootDir.list()) {
                if (file.endsWith(".jar")) {
                    Path path = this._rootDir.lookup(file);
                    JarPath jar = JarPath.create(path);
                    try {
                        if (jar.lookup("META-INF/application-client.xml").canRead()) continue;
                        if (jar.lookup("META-INF/ejb-jar.xml").canRead()) {
                            this.addEjbPath(path);
                            this._loader.addJar(path);
                            this._loader.addJarManifestClassPath(path);
                            continue;
                        }
                        this.addEjbPath(path);
                        this._loader.addJar(path);
                    }
                    catch (ZipException e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    continue;
                }
                if (!file.endsWith(".war")) continue;
                Module module = this.createModule();
                WebModule web = new WebModule();
                web.setWebURI(file);
                module.addWeb(web);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void fillDefaultLib() throws Exception {
        String libDir = "lib";
        if (this._libraryDirectory != null) {
            libDir = this._libraryDirectory;
        }
        if (this._rootDir.lookup(libDir).isDirectory()) {
            Path lib = this._rootDir.lookup(libDir);
            for (String file : lib.list()) {
                if (!file.endsWith(".jar")) continue;
                this._loader.addJar(lib.lookup(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            for (int i = 0; i < this._webConfigList.size(); ++i) {
                WebModule web = this._webConfigList.get(i);
                this.initWeb(web);
            }
            this.getClassLoader().start();
            for (WebAppController webApp : this._webApps) {
                this._container.getWebAppGenerator().update(webApp.getContextPath());
            }
            Object var6_6 = null;
            this._lifecycle.toActive();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        thread.setContextClassLoader(oldLoader);
    }

    void initWeb(WebModule web) {
        int p;
        String name;
        String webUri = web.getWebURI();
        String contextUrl = web.getContextRoot();
        Path path = this._rootDir.lookup(webUri);
        Path archivePath = null;
        if (contextUrl == null) {
            contextUrl = webUri;
        }
        WebAppController controller = null;
        if (webUri.endsWith(".war")) {
            name = webUri.substring(0, webUri.length() - 4);
            p = name.lastIndexOf(47);
            if (p > 0) {
                name = name.substring(p + 1);
            }
            if (contextUrl.equals("")) {
                contextUrl = "/" + name;
            }
            if (contextUrl.endsWith(".war")) {
                contextUrl = contextUrl.substring(0, contextUrl.length() - 4);
            }
            Path expandPath = this._webappsPath;
            try {
                expandPath.mkdirs();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            archivePath = path;
            path = expandPath.lookup(name);
        } else {
            if (contextUrl.equals("")) {
                name = webUri;
                p = name.lastIndexOf(47);
                if (p > 0) {
                    name = name.substring(p + 1);
                }
                contextUrl = "/" + name;
            }
            if (contextUrl.endsWith(".war")) {
                contextUrl = contextUrl.substring(0, contextUrl.length() - 4);
            }
        }
        controller = this.findWebAppEntry(contextUrl);
        if (controller == null) {
            controller = new WebAppController(contextUrl, contextUrl, path, this._container);
            this._webApps.add(controller);
        }
        if (archivePath != null) {
            controller.setArchivePath(archivePath);
        }
        controller.setDynamicDeploy(true);
        if (this._configException != null) {
            controller.setConfigException(this._configException);
        }
        for (WebAppConfig config : web.getWebAppList()) {
            controller.addConfigDefault(config);
        }
    }

    public WebAppController findWebAppEntry(String name) {
        for (int i = 0; i < this._webApps.size(); ++i) {
            WebAppController controller = this._webApps.get(i);
            if (!controller.isNameMatch(name)) continue;
            return controller;
        }
        return null;
    }

    private void addDepend(Path path) {
        this._loader.addDependency((Dependency)new Depend(path));
    }

    public ArrayList<WebAppController> getApplications() {
        return this._webApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this._lifecycle.toStopping()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._loader.stop();
            Object var4_3 = null;
            this._lifecycle.toStop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        thread.setContextClassLoader(oldLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            log.fine(this + " destroying");
            ArrayList<WebAppController> webApps = this._webApps;
            this._webApps = null;
            if (webApps != null) {
                for (WebAppController webApp : webApps) {
                    this._container.getWebAppGenerator().update(webApp.getContextPath());
                }
            }
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
            this._loader.destroy();
            log.fine(this + " destroyed");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            this._loader.destroy();
            log.fine(this + " destroyed");
            throw throwable;
        }
    }

    public String getClientRefs() {
        EjbContainer ejbContainer = EjbContainer.create();
        return ejbContainer.getClientRemoteConfig();
    }

    public String toString() {
        return "EnterpriseApplication[" + this.getName() + "]";
    }

    private void addEjbPath(Path ejbPath) {
        if (this._ejbPaths.contains(ejbPath)) {
            return;
        }
        this._ejbPaths.add(ejbPath);
    }

    public class Module {
        public void setId(String id) {
        }

        public void addWeb(WebModule web) throws Exception {
            String webUri = web.getWebURI();
            WebModule oldWeb = EnterpriseApplication.this.findWebModule(webUri);
            if (oldWeb != null) {
                String contextUrl = web.getContextRoot();
                if (contextUrl != null && !"".equals(contextUrl)) {
                    oldWeb.setContextRoot(contextUrl);
                }
                oldWeb.addWebAppList(web.getWebAppList());
            } else {
                EnterpriseApplication.this.addWebModule(web);
            }
        }

        public void addEjb(Path path) throws Exception {
            EnterpriseApplication.this.addEjbPath(path);
            EnterpriseApplication.this._loader.addJar(path);
            EnterpriseApplication.this._loader.addJarManifestClassPath(path);
        }

        public void addJava(Path path) throws ConfigException {
            if (!path.canRead()) {
                throw new ConfigException(L.l("<java> module {0} must be a valid path.", (Object)path));
            }
        }

        public void addConnector(String path) {
        }

        public void addAltDD(String path) {
        }
    }
}

