/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.embed;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Server;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.resin.Resin;
import com.caucho.server.webapp.WebAppConfig;
import java.io.IOException;
import java.io.InputStream;

public class ResinEmbed {
    private static final String EMBED_CONF = "com/caucho/server/embed/resin-embed.xml";
    private Resin _resin = new Resin();
    private Cluster _cluster;
    private ClusterServer _clusterServer;
    private Host _host;
    private Server _server;
    private Lifecycle _lifecycle = new Lifecycle();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResinEmbed() {
        InputStream is = null;
        try {
            try {
                Config config = new Config();
                is = this._resin.getClassLoader().getResourceAsStream(EMBED_CONF);
                config.configure((Object)this._resin, is);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            Object var4_4 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        this._cluster = this._resin.findCluster("");
        this._clusterServer = this._cluster.findServer("");
    }

    public void setHttpPort(int port) {
        this._clusterServer.createHttp().setPort(port);
    }

    public void addWebApp(String contextPath, String rootDirectory) {
        try {
            this.start();
            WebAppConfig config = new WebAppConfig();
            config.setContextPath(contextPath);
            config.setRootDirectory(new RawString(rootDirectory));
            this._host.addWebApp(config);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this._resin.start();
            this._server = this._resin.getServer();
            HostConfig hostConfig = new HostConfig();
            this._server.addHost(hostConfig);
            this._host = this._server.getHost("", 0);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            this._resin.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            this._resin.destroy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

