/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.connection.Connection;
import com.caucho.server.hmux.HmuxExtension;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ServerRequest;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class HmuxProtocol
extends Protocol {
    private static EnvironmentLocal<HmuxProtocol> _localManager = new EnvironmentLocal();
    private String _protocolName = "hmux";
    private ClassLoader _classLoader;
    private HashMap<Integer, WeakReference<HmuxExtension>> _extensionMap = new HashMap();

    public HmuxProtocol() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        _localManager.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HmuxProtocol getLocal() {
        EnvironmentLocal<HmuxProtocol> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            return _localManager.get();
        }
    }

    public String getProtocolName() {
        return this._protocolName;
    }

    public void setProtocolName(String name) {
        this._protocolName = name;
    }

    public ServerRequest createRequest(Connection conn) {
        return new HmuxRequest(this.getServer(), conn, this);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public HmuxExtension getExtension(Integer id) {
        WeakReference<HmuxExtension> ref = this._extensionMap.get(id);
        if (ref != null) {
            return (HmuxExtension)ref.get();
        }
        return null;
    }

    public void putExtension(Integer id, HmuxExtension extension) {
        this._extensionMap.put(id, new WeakReference<HmuxExtension>(extension));
    }
}

