/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.security.BasicPrincipal;
import com.caucho.server.cluster.BackingManager;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.hmux.AbstractClusterRequest;
import com.caucho.server.hmux.HmuxDispatchRequest;
import com.caucho.server.hmux.HmuxExtension;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.server.hmux.HmuxResponse;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmuxRequest
extends AbstractHttpRequest
implements ServerRequest {
    private static final Logger log = Logger.getLogger(HmuxRequest.class.getName());
    public static final int HMUX_CHANNEL = 67;
    public static final int HMUX_ACK = 65;
    public static final int HMUX_ERROR = 69;
    public static final int HMUX_YIELD = 89;
    public static final int HMUX_QUIT = 81;
    public static final int HMUX_EXIT = 88;
    public static final int HMUX_DATA = 68;
    public static final int HMUX_URI = 85;
    public static final int HMUX_STRING = 83;
    public static final int HMUX_HEADER = 72;
    public static final int HMUX_PROTOCOL = 80;
    public static final int HMUX_META_HEADER = 77;
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_REMOTE_USER = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int HMUX_FLUSH = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int HMUX_METHOD = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int HMUX_STATUS = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_SERVER_TYPE = 117;
    public static final int HMUX_SERVER_NAME = 118;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_DATA = 68;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_ACK = 65;
    public static final int CSE_END = 90;
    public static final int CSE_CLOSE = 88;
    public static final int CSE_QUERY = 81;
    public static final int CSE_PING = 80;
    public static final int HMUX_CLUSTER_PROTOCOL = 257;
    public static final int HMUX_DISPATCH_PROTOCOL = 258;
    public static final int HMUX_JMS_PROTOCOL = 259;
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    private static final int HEADER_CAPACITY = 256;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    private final CharBuffer _method;
    private String _methodString;
    private CharBuffer _host;
    private int _port;
    private ByteBuffer _uri;
    private CharBuffer _protocol;
    private int _version;
    private CharBuffer _remoteAddr;
    private CharBuffer _remoteHost;
    private CharBuffer _serverName;
    private CharBuffer _serverPort;
    private CharBuffer _remotePort;
    private boolean _isSecure;
    private ByteBuffer _clientCert;
    private CharBuffer[] _headerKeys;
    private CharBuffer[] _headerValues;
    private int _headerSize;
    private byte[] _lengthBuf;
    private int _serverType;
    private WriteStream _rawWrite;
    private WriteStream _writeStream;
    private ServletFilter _filter;
    private int _pendingData;
    private InvocationKey _invocationKey = new InvocationKey();
    private CharBuffer _cb1;
    private CharBuffer _cb2;
    private boolean _hasRequest;
    private AbstractClusterRequest _clusterRequest;
    private HmuxDispatchRequest _dispatchRequest;
    private BackingManager _backingManager;
    private Cluster _cluster;
    private HmuxProtocol _hmuxProtocol;
    private ErrorPageManager _errorManager = new ErrorPageManager();
    private int _srunIndex;

    public HmuxRequest(DispatchServer server, Connection conn, HmuxProtocol protocol) {
        super(server, conn);
        this._hmuxProtocol = protocol;
        this._response = new HmuxResponse(this);
        this._rawWrite = conn.getWriteStream();
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
        this._cluster = Cluster.getLocal();
        if (this._cluster != null) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.hmux.HmuxClusterRequest");
                this._clusterRequest = (AbstractClusterRequest)cl.newInstance();
                this._clusterRequest.setRequest(this);
                this._clusterRequest.setCluster(this._cluster);
            }
            catch (ClassNotFoundException e) {
                log.finer(e.toString());
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this._dispatchRequest = new HmuxDispatchRequest(this);
        this._uri = new ByteBuffer();
        this._method = new CharBuffer();
        this._host = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerKeys = new CharBuffer[256];
        this._headerValues = new CharBuffer[this._headerKeys.length];
        for (int i = 0; i < this._headerKeys.length; ++i) {
            this._headerKeys[i] = new CharBuffer();
            this._headerValues[i] = new CharBuffer();
        }
        this._remoteHost = new CharBuffer();
        this._remoteAddr = new CharBuffer();
        this._serverName = new CharBuffer();
        this._serverPort = new CharBuffer();
        this._remotePort = new CharBuffer();
        this._clientCert = new ByteBuffer();
        this._cb1 = new CharBuffer();
        this._cb2 = new CharBuffer();
        this._lengthBuf = new byte[16];
        this._filter = new ServletFilter();
    }

    @Override
    public boolean isWaitForRead() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest() throws IOException {
        block85: {
            boolean e6;
            boolean bl;
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(this._server.getClassLoader());
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + "start request");
            }
            this._filter.init(this, this._rawRead, this._rawWrite);
            this._writeStream.init((StreamImpl)this._filter);
            this._response.init(this._writeStream);
            this._serverType = 0;
            this._uri.setLength(0);
            boolean hasRequest = false;
            this.startInvocation();
            this.start();
            this._response.start();
            if (this.scanHeaders()) break block68;
            this.killKeepalive();
            boolean bl2 = false;
            Object var6_14 = null;
            this.finishInvocation();
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            {
                block68: {
                    return bl2;
                }
                if (this._uri.size() != 0) break block71;
                bl = true;
            }
            Object var6_15 = null;
            this.finishInvocation();
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            {
                block71: {
                    return bl;
                    catch (InterruptedIOException e4) {
                        this.killKeepalive();
                        log.fine(this.dbgId() + "interrupted keepalive");
                        boolean bl3 = false;
                        Object var6_16 = null;
                        this.finishInvocation();
                        if (!hasRequest) {
                            this._response.setHeaderWritten(true);
                        }
                        try {
                            this.finish();
                            this._response.finish();
                        }
                        catch (ClientDisconnectException e2) {
                            throw e2;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, this.dbgId() + e3, e3);
                        }
                        try {
                            this._writeStream.setDisableClose(false);
                            this._writeStream.close();
                        }
                        catch (ClientDisconnectException e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, this.dbgId() + e3, e3);
                            throw e3;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, this.dbgId() + e3, e3);
                        }
                        try {
                            this._readStream.setDisableClose(false);
                            this._readStream.close();
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, this.dbgId() + e3, e3);
                        }
                        return bl3;
                    }
                }
                if (this._isSecure) {
                    this.getClientCertificate();
                }
                hasRequest = true;
                if (this._server != null && !this._server.isDestroyed()) break block84;
                log.fine(this.dbgId() + "server is closed");
                try {
                    this._writeStream.setDisableClose(false);
                    this._writeStream.close();
                }
                catch (Throwable e5) {
                    // empty catch block
                }
                try {
                    this._readStream.setDisableClose(false);
                    this._readStream.close();
                }
                catch (Throwable e6) {
                    // empty catch block
                }
                e6 = false;
            }
            Object var6_17 = null;
            this.finishInvocation();
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            {
                block84: {
                    return e6;
                }
                this._filter.setPending(this._pendingData);
                try {
                    if (this._method.getLength() == 0) {
                        throw new RuntimeException("HTTP protocol exception");
                    }
                    this._invocationKey.init(this._isSecure, (CharSequence)this.getHost(), this.getServerPort(), this._uri.getBuffer(), this._uri.getLength());
                    Invocation invocation = this._server.getInvocation(this._invocationKey);
                    if (invocation == null) {
                        invocation = this._server.createInvocation();
                        if (this._host != null) {
                            invocation.setHost(this._host.toString());
                        }
                        invocation.setPort(this.getServerPort());
                        InvocationDecoder decoder = this._server.getInvocationDecoder();
                        decoder.splitQueryAndUnescape(invocation, this._uri.getBuffer(), this._uri.getLength());
                        invocation = this._server.buildInvocation(this._invocationKey.clone(), invocation);
                    }
                    invocation = invocation.getRequestInvocation(this);
                    this.setInvocation(invocation);
                    invocation.service((ServletRequest)this, (ServletResponse)this._response);
                }
                catch (ClientDisconnectException e7) {
                    throw e7;
                }
                catch (Throwable e8) {
                    try {
                        this._errorManager.sendServletError(e8, (ServletRequest)this, (ServletResponse)this._response);
                    }
                    catch (ClientDisconnectException e1) {
                        throw e1;
                    }
                    catch (Exception e1) {
                        log.log(Level.FINE, e1.toString(), e1);
                    }
                    boolean bl4 = false;
                    Object var6_18 = null;
                    this.finishInvocation();
                    if (!hasRequest) {
                        this._response.setHeaderWritten(true);
                    }
                    try {
                        this.finish();
                        this._response.finish();
                    }
                    catch (ClientDisconnectException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.killKeepalive();
                        log.log(Level.FINE, this.dbgId() + e3, e3);
                    }
                    try {
                        this._writeStream.setDisableClose(false);
                        this._writeStream.close();
                    }
                    catch (ClientDisconnectException e3) {
                        this.killKeepalive();
                        log.log(Level.FINE, this.dbgId() + e3, e3);
                        throw e3;
                    }
                    catch (Exception e3) {
                        this.killKeepalive();
                        log.log(Level.FINE, this.dbgId() + e3, e3);
                    }
                    try {
                        this._readStream.setDisableClose(false);
                        this._readStream.close();
                    }
                    catch (Exception e3) {
                        this.killKeepalive();
                        log.log(Level.FINE, this.dbgId() + e3, e3);
                    }
                    return bl4;
                }
            }
            Object var6_19 = null;
            this.finishInvocation();
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, this.dbgId() + e3, e3);
            }
            break block85;
            catch (Throwable throwable) {
                Object var6_20 = null;
                this.finishInvocation();
                if (!hasRequest) {
                    this._response.setHeaderWritten(true);
                }
                try {
                    this.finish();
                    this._response.finish();
                }
                catch (ClientDisconnectException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, this.dbgId() + e3, e3);
                }
                try {
                    this._writeStream.setDisableClose(false);
                    this._writeStream.close();
                }
                catch (ClientDisconnectException e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, this.dbgId() + e3, e3);
                    throw e3;
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, this.dbgId() + e3, e3);
                }
                try {
                    this._readStream.setDisableClose(false);
                    this._readStream.close();
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, this.dbgId() + e3, e3);
                }
                throw throwable;
            }
        }
        boolean allowKeepalive = this.isKeepalive();
        if (log.isLoggable(Level.FINE)) {
            if (allowKeepalive) {
                log.fine(this.dbgId() + "complete request - keepalive");
            } else {
                log.fine(this.dbgId() + "complete request");
            }
        }
        return allowKeepalive;
    }

    @Override
    protected boolean initStream(ReadStream readStream, ReadStream rawStream) throws IOException {
        readStream.init((StreamImpl)this._filter, null);
        return true;
    }

    private void getClientCertificate() {
        String keySize;
        String cipher = this.getHeader("SSL_CIPHER");
        if (cipher == null) {
            cipher = this.getHeader("HTTPS_CIPHER");
        }
        if (cipher != null) {
            this.setAttribute("javax.servlet.request.cipher_suite", cipher);
        }
        if ((keySize = this.getHeader("SSL_CIPHER_USEKEYSIZE")) == null) {
            keySize = this.getHeader("SSL_SECRETKEYSIZE");
        }
        if (keySize != null) {
            this.setAttribute("javax.servlet.request.key_size", keySize);
        }
        if (this._clientCert.size() == 0) {
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = this._clientCert.createInputStream();
            Certificate cert = cf.generateCertificate(is);
            is.close();
            this.setAttribute("javax.servlet.request.X509Certificate", cert);
            this.setAttribute("com.caucho.servlet.login.name", ((X509Certificate)cert).getSubjectDN());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void start() throws IOException {
        super.start();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._version = 0;
        this._uri.clear();
        this._host.clear();
        this._port = 0;
        this._headerSize = 0;
        this._remoteHost.clear();
        this._remoteAddr.clear();
        this._serverName.clear();
        this._serverPort.clear();
        this._remotePort.clear();
        this._clientCert.clear();
        this._pendingData = 0;
        this._isSecure = this._conn.isSecure();
    }

    private boolean scanHeaders() throws IOException {
        boolean hasURI = false;
        CharBuffer cb = this._cb;
        boolean isLoggable = log.isLoggable(Level.FINE);
        ReadStream is = this._rawRead;
        block25: while (true) {
            int code = is.read();
            switch (code) {
                case -1: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "end of file");
                    }
                    return false;
                }
                case 67: {
                    int channel = (is.read() << 8) + is.read();
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + "channel " + channel);
                    break;
                }
                case 81: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of request");
                    }
                    return hasURI;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of socket");
                    }
                    this.killKeepalive();
                    return hasURI;
                }
                case 80: {
                    int len = (is.read() << 8) + is.read();
                    if (len != 4) {
                        log.fine(this.dbgId() + (char)code + ": protocol length (" + len + ") must be 4.");
                        this.killKeepalive();
                        return false;
                    }
                    int value = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
                    int result = 88;
                    boolean isKeepalive = false;
                    if (value == 257) {
                        if (isLoggable) {
                            log.fine(this.dbgId() + (char)code + ": cluster protocol");
                        }
                        this._filter.setClientClosed(true);
                        if (this._server == null || this._server.isDestroyed()) {
                            return false;
                        }
                        result = this._clusterRequest.handleRequest(is, this._rawWrite);
                    } else if (value == 258) {
                        if (isLoggable) {
                            log.fine(this.dbgId() + (char)code + ": dispatch protocol");
                        }
                        this._filter.setClientClosed(true);
                        if (this._server == null || this._server.isDestroyed()) {
                            return false;
                        }
                        isKeepalive = this._dispatchRequest.handleRequest(is, this._rawWrite);
                        result = isKeepalive ? 81 : 88;
                    } else {
                        if (this._server == null || this._server.isDestroyed()) {
                            return false;
                        }
                        HmuxExtension ext = this._hmuxProtocol.getExtension(value);
                        if (ext != null) {
                            if (isLoggable) {
                                log.fine(this.dbgId() + (char)code + ": extension " + ext);
                            }
                            this._filter.setClientClosed(true);
                            result = ext.handleRequest(this, is, this._rawWrite);
                        } else {
                            log.fine(this.dbgId() + (char)code + ": unknown protocol (" + value + ")");
                            result = 88;
                        }
                    }
                    if (result == 89) continue block25;
                    if (result == 81 && !this.allowKeepalive()) {
                        result = 88;
                    }
                    if (result == 81) {
                        this._rawWrite.write(81);
                        this._rawWrite.flush();
                    } else {
                        this._rawWrite.write(88);
                        this._rawWrite.close();
                    }
                    return result == 81;
                }
                case 85: {
                    hasURI = true;
                    int len = (is.read() << 8) + is.read();
                    this._uri.setLength(len);
                    this._rawRead.readAll(this._uri.getBuffer(), 0, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + ":uri " + this._uri);
                    break;
                }
                case 109: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._method, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + ":method " + this._method);
                    break;
                }
                case 107: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    code = this._rawRead.read();
                    if (code != 83) {
                        throw new IOException("protocol expected HMUX_STRING");
                    }
                    this._cb2.clear();
                    this._rawRead.readAll(this._cb2, this.readLength());
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " " + this._cb1.toString() + "->" + this._cb2.toString());
                    break;
                }
                case 104: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remoteHost, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " " + this._remoteHost);
                    break;
                }
                case 105: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remoteAddr, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " " + this._remoteAddr);
                    break;
                }
                case 118: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._serverName, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " server-host: " + this._serverName);
                    break;
                }
                case 106: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remotePort, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " remote-port: " + this._remotePort);
                    break;
                }
                case 103: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._serverPort, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " server-port: " + this._serverPort);
                    break;
                }
                case 101: {
                    int len = (is.read() << 8) + is.read();
                    if (len <= 0) continue block25;
                    this._uri.add(63);
                    this._uri.ensureCapacity(this._uri.getLength() + len);
                    this._rawRead.readAll(this._uri.getBuffer(), this._uri.getLength(), len);
                    this._uri.setLength(this._uri.getLength() + len);
                    break;
                }
                case 99: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._protocol, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " protocol: " + this._protocol);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= len) continue block25;
                        char ch = this._protocol.charAt(i);
                        if (ch >= '0' && ch <= '9') {
                            this._version = 16 * this._version + ch - 48;
                        } else if (ch == '.') {
                            this._version = 16 * this._version;
                        }
                        ++i;
                    }
                }
                case 72: {
                    int len = (is.read() << 8) + is.read();
                    int headerSize = this._headerSize;
                    CharBuffer key = this._headerKeys[headerSize];
                    key.clear();
                    CharBuffer valueCb = this._headerValues[headerSize];
                    valueCb.clear();
                    this._rawRead.readAll(key, len);
                    code = this._rawRead.read();
                    if (code != 83) {
                        throw new IOException("protocol expected HMUX_STRING at " + (char)code);
                    }
                    this._rawRead.readAll(valueCb, this.readLength());
                    if (isLoggable) {
                        log.fine(this.dbgId() + "H " + key + "=" + valueCb);
                    }
                    if (!this.addHeaderInt(key.getBuffer(), 0, key.length(), (CharSegment)valueCb)) continue block25;
                    ++this._headerSize;
                    break;
                }
                case 112: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Length");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " content-length=" + this._headerValues[this._headerSize]);
                    }
                    ++this._headerSize;
                    break;
                }
                case 113: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Type");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " content-type=" + this._headerValues[this._headerSize]);
                    }
                    ++this._headerSize;
                    break;
                }
                case 114: {
                    int len = (is.read() << 8) + is.read();
                    this._isSecure = true;
                    if (isLoggable) {
                        log.fine(this.dbgId() + "secure");
                    }
                    this._rawRead.skip((long)len);
                    break;
                }
                case 116: {
                    int len = (is.read() << 8) + is.read();
                    this._clientCert.clear();
                    this._clientCert.setLength(len);
                    this._rawRead.readAll(this._clientCert.getBuffer(), 0, len);
                    if (!isLoggable) continue block25;
                    log.fine(this.dbgId() + (char)code + " cert=" + this._clientCert + " len:" + len);
                    break;
                }
                case 117: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " server=" + this._cb1);
                    }
                    if (this._cb1.length() <= 0) continue block25;
                    this._serverType = this._cb1.charAt(0);
                    break;
                }
                case 100: {
                    int len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    this._rawRead.readAll(this._cb, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " " + this._cb);
                    }
                    this.setAttribute("com.caucho.servlet.login.name", new BasicPrincipal(this._cb.toString()));
                    break;
                }
                case 68: {
                    int len;
                    this._pendingData = len = (is.read() << 8) + is.read();
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " post-data: " + len);
                    }
                    return hasURI;
                }
                default: {
                    int len = (is.read() << 8) + is.read();
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " " + len);
                    }
                    is.skip((long)len);
                }
            }
        }
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this._headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this._headerSize * 2];
        for (i = 0; i < this._headerSize; ++i) {
            newKeys[i] = this._headerKeys[i];
            newValues[i] = this._headerValues[i];
        }
        for (i = this._headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this._headerKeys = newKeys;
        this._headerValues = newValues;
    }

    private int readLength() throws IOException {
        return (this._rawRead.read() << 8) + this._rawRead.read();
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals((CharSegment)_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals((CharSegment)_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals((CharSegment)_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    protected CharBuffer getHost() {
        if (this._host.length() > 0) {
            return this._host;
        }
        this._host.append(this._serverName);
        this._host.toLowerCase();
        return this._host;
    }

    @Override
    public final byte[] getUriBuffer() {
        return this._uri.getBuffer();
    }

    @Override
    public final int getUriLength() {
        return this._uri.getLength();
    }

    @Override
    public String getProtocol() {
        return this._protocol.toString();
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    final int getVersion() {
        return this._version;
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this._headerSize; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this._headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this._headerSize; ++i) {
            int j;
            CharBuffer test = this._headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void setHeader(String key, String value) {
        if (this._headerKeys.length <= this._headerSize) {
            this.resizeHeaders();
        }
        this._headerKeys[this._headerSize].clear();
        this._headerKeys[this._headerSize].append(key);
        this._headerValues[this._headerSize].clear();
        this._headerValues[this._headerSize].append(value);
        ++this._headerSize;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        CharBuffer cb = this._cb;
        cb.clear();
        cb.append(key);
        int size = this._headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase((CharSegment)cb)) continue;
            values.add((CharSegment)this._headerValues[i]);
        }
    }

    @Override
    public Enumeration getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            names.add(this._headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public String getRequestURI() {
        if (this._serverType == 82) {
            return super.getRequestURI();
        }
        String _rawURI = super.getRequestURI();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < _rawURI.length(); ++i) {
            char ch = _rawURI.charAt(i);
            if (ch <= ' ' || ch >= '\u0080' || ch == '%') {
                this.addHex(cb, ch);
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    private void addHex(CharBuffer cb, int ch) {
        cb.append('%');
        int d = ch >> 4 & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = ch & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
    }

    @Override
    public String getServerName() {
        CharBuffer host = this.getHost();
        if (host == null) {
            InetAddress addr = this.getConnection().getRemoteAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    @Override
    public int getServerPort() {
        int len = this._serverPort.length();
        int port = 0;
        for (int i = 0; i < len; ++i) {
            char ch = this._serverPort.charAt(i);
            port = 10 * port + ch - 48;
        }
        return port;
    }

    @Override
    public String getRemoteAddr() {
        return this._remoteAddr.toString();
    }

    public void getRemoteAddr(CharBuffer cb) {
        cb.append(this._remoteAddr);
    }

    @Override
    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        char[] buf = this._remoteAddr.getBuffer();
        int len = this._remoteAddr.getLength();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)buf[i];
        }
        return offset + len;
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost.toString();
    }

    @Override
    protected void connectionClose() {
    }

    void writeStatus(CharBuffer message) throws IOException {
        int channel = 2;
        WriteStream os = this._rawWrite;
        os.write(67);
        os.write(channel >> 8);
        os.write(channel);
        this.writeString(115, message);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String key, String value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void writeHeader(String key, CharBuffer value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void writeString(int code, String value) throws IOException {
        int len = value.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + value);
        }
    }

    void writeString(int code, CharBuffer cb) throws IOException {
        int len = cb.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(cb.getBuffer(), 0, len);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + cb);
        }
    }

    @Override
    public void protocolCloseEvent() {
    }

    @Override
    public final String dbgId() {
        String id = this._server.getServerId();
        if (id.equals("")) {
            return "Hmux[" + this.getConnection().getId() + "] ";
        }
        return "Hmux[" + id + ":" + this.getConnection().getId() + "] ";
    }

    public String toString() {
        return "HmuxRequest" + this.dbgId();
    }

    static class ServletFilter
    extends StreamImpl {
        HmuxRequest _request;
        ReadStream _is;
        WriteStream _os;
        byte[] _buffer = new byte[16];
        int _pendingData;
        boolean _needsAck;
        boolean _isClosed;
        boolean _isClientClosed;

        ServletFilter() {
        }

        void init(HmuxRequest request, ReadStream nextRead, WriteStream nextWrite) {
            this._request = request;
            this._is = nextRead;
            this._os = nextWrite;
            this._pendingData = 0;
            this._isClosed = false;
            this._isClientClosed = false;
            this._needsAck = false;
        }

        void setPending(int pendingData) {
            this._pendingData = pendingData;
        }

        void setClientClosed(boolean isClientClosed) {
            this._isClientClosed = isClientClosed;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() {
            return this._pendingData;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int sublen = this._pendingData;
            ReadStream is = this._is;
            if (sublen <= 0) {
                return -1;
            }
            if (length < sublen) {
                sublen = length;
            }
            int readLen = is.read(buf, offset, sublen);
            this._pendingData -= readLen;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(new String(buf, offset, readLen));
            }
            while (this._pendingData == 0) {
                int len;
                if (this._needsAck) {
                    int channel = 2;
                    this._os.write(65);
                    this._os.write(channel >> 8);
                    this._os.write(channel);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "A:ack channel 2");
                    }
                }
                this._needsAck = false;
                int code = is.read();
                if (code == 68) {
                    len = (is.read() << 8) + is.read();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "D:post-data " + len);
                    }
                    this._pendingData = len;
                    continue;
                }
                if (code == 81) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "Q:quit");
                    }
                    return readLen;
                }
                if (code == 88) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "X:exit");
                    }
                    this._request.killKeepalive();
                    return readLen;
                }
                if (code == 89) {
                    this._needsAck = true;
                    continue;
                }
                if (code == 67) {
                    int channel = (is.read() << 8) + is.read();
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(this._request.dbgId() + "channel " + channel);
                    continue;
                }
                if (code < 0) {
                    this._request.killKeepalive();
                    return readLen;
                }
                this._request.killKeepalive();
                len = (is.read() << 8) + is.read();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._request.dbgId() + "unknown `" + (char)code + "' " + len);
                }
                is.skip((long)len);
            }
            return readLen;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'D' + ":data " + length);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this._request.dbgId() + "data <" + new String(buf, offset, length) + ">");
                }
            }
            byte[] tempBuf = this._buffer;
            while (length > 0) {
                int sublen = length;
                if (32768 < sublen) {
                    sublen = 32768;
                }
                tempBuf[0] = 68;
                tempBuf[1] = (byte)(sublen >> 8);
                tempBuf[2] = (byte)sublen;
                this._os.write(tempBuf, 0, 3);
                this._os.write(buf, offset, sublen);
                length -= sublen;
                offset += sublen;
            }
        }

        public void flush() throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'f' + ":flush");
            }
            this._os.write(102);
            this._os.write(0);
            this._os.write(0);
            this._os.flush();
        }

        public void close() throws IOException {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            if (this._pendingData > 0) {
                this._is.skip((long)this._pendingData);
                this._pendingData = 0;
            }
            boolean keepalive = this._request.allowKeepalive();
            if (!this._isClientClosed) {
                if (log.isLoggable(Level.FINE)) {
                    if (keepalive) {
                        log.fine(this._request.dbgId() + 'Q' + ": quit channel");
                    } else {
                        log.fine(this._request.dbgId() + 'X' + ": exit socket");
                    }
                }
                if (keepalive) {
                    this._os.write(81);
                } else {
                    this._os.write(88);
                }
            }
            if (keepalive) {
                this._os.flush();
            } else {
                this._os.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtocolResult {
        QUIT,
        EXIT,
        YIELD;

    }
}

