/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.log.Log;
import com.caucho.server.hmux.HmuxPath;
import com.caucho.server.hmux.HmuxStreamWrapper;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class HmuxStream
extends StreamImpl {
    private static final Logger log = Log.open(HmuxStream.class);
    private static HashMap<String, String> _reserved;
    private static final Object LOCK;
    private static HmuxStream _savedStream;
    private static long _saveTime;
    private long _socketTimeout = 30000L;
    private boolean _isSSL;
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;
    private ReadStream _rs;
    private WriteStream _ws;
    private String _host;
    private int _port;
    private String _virtualHost;
    private String _method;
    private boolean _isHead;
    private boolean _isPost;
    private MemoryStream _tempStream;
    private boolean _isKeepalive = true;
    private boolean _didGet;
    private int _chunkLength;
    private boolean _isRequestDone;
    private HashMap<String, Object> _attributes;
    private byte[] _tempBuffer;

    private HmuxStream(Path path, String host, int port, Socket s) throws IOException {
        this._s = s;
        this._host = host;
        this._port = port;
        this._is = this._s.getInputStream();
        this._os = this._s.getOutputStream();
        this._ws = VfsStream.openWrite((OutputStream)this._os);
        this._rs = VfsStream.openRead((InputStream)this._is, (WriteStream)this._ws);
        this._attributes = new HashMap();
        this.init(path);
    }

    static HmuxStreamWrapper openRead(HmuxPath path) throws IOException {
        HmuxStream stream = HmuxStream.createStream(path);
        stream._isPost = false;
        return new HmuxStreamWrapper(stream);
    }

    static HmuxStreamWrapper openReadWrite(HmuxPath path) throws IOException {
        HmuxStream stream = HmuxStream.createStream(path);
        stream._isPost = true;
        return new HmuxStreamWrapper(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HmuxStream createStream(HmuxPath path) throws IOException {
        Socket s;
        String host = path.getHost();
        int port = path.getPort();
        HmuxStream stream = null;
        long streamTime = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (_savedStream != null && host.equals(_savedStream.getHost()) && port == _savedStream.getPort()) {
                stream = _savedStream;
                streamTime = _saveTime;
                _savedStream = null;
            }
        }
        if (stream != null) {
            if (Alarm.getCurrentTime() < streamTime + 5000L) {
                stream.init((Path)path);
                return stream;
            }
            try {
                stream._isKeepalive = false;
                stream.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        try {
            s = new Socket(host, port);
        }
        catch (ConnectException e) {
            throw new ConnectException(path.getURL() + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new ConnectException(path.getURL() + ": " + e.toString());
        }
        int socketTimeout = 300000;
        try {
            s.setSoTimeout(socketTimeout);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new HmuxStream((Path)path, host, port, s);
    }

    private void init(Path path) {
        this._isRequestDone = false;
        this._didGet = false;
        this._isPost = false;
        this._isHead = false;
        this._method = null;
        this._attributes.clear();
        this.setPath(path);
        if (path instanceof HmuxPath) {
            this._virtualHost = ((HmuxPath)path).getVirtualHost();
        }
    }

    public void setSSL(boolean isSSL) {
        this._isSSL = isSSL;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setHead(boolean isHead) {
        this._isHead = isHead;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public Object getAttribute(String name) throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        return this._attributes.get(name.toLowerCase());
    }

    public Iterator getAttributeNames() throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        return this._attributes.keySet().iterator();
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("method")) {
            this.setMethod((String)value);
        } else if (name.equals("socket-timeout")) {
            int socketTimeout;
            if (value instanceof Integer && (socketTimeout = ((Integer)value).intValue()) > 0) {
                try {
                    if (this._s != null) {
                        this._s.setSoTimeout(socketTimeout);
                    }
                }
                catch (Exception e) {}
            }
        } else {
            this._attributes.put(name.toLowerCase(), value);
        }
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name.toLowerCase());
    }

    public void setSocketTimeout(long timeout) throws SocketException {
        if (this._s != null) {
            this._s.setSoTimeout((int)timeout);
        }
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (!this._isPost) {
            return;
        }
        if (this._tempStream == null) {
            this._tempStream = new MemoryStream();
        }
        this._tempStream.write(buf, offset, length, isEnd);
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            return this.readInt(buf, offset, length);
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    public int readInt(byte[] buf, int offset, int length) throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        if (this._isRequestDone) {
            return -1;
        }
        try {
            int len = length;
            if (this._chunkLength == 0 && !this.readData()) {
                this._chunkLength = -1;
            }
            if (this._chunkLength < 0) {
                return -1;
            }
            if (this._chunkLength < len) {
                len = this._chunkLength;
            }
            if ((len = this._rs.read(buf, offset, len)) >= 0) {
                this._chunkLength -= len;
            }
            return len;
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    private void getConnInput() throws IOException {
        if (this._didGet) {
            return;
        }
        try {
            this.getConnInputImpl();
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    private void getConnInputImpl() throws IOException {
        if (this._didGet) {
            return;
        }
        this._didGet = true;
        this._ws.write(67);
        this._ws.write(0);
        this._ws.write(0);
        if (this._method != null) {
            this.writeString(109, this._method);
        } else if (this._isPost) {
            this.writeString(109, "POST");
        } else if (this._isHead) {
            this.writeString(109, "HEAD");
        } else {
            this.writeString(109, "GET");
        }
        if (this._virtualHost != null) {
            this.writeString(118, this._virtualHost);
        } else {
            this.writeString(118, this._path.getHost());
            this._ws.print(this._path.getHost());
            if (this._path.getPort() != 80) {
                this.writeString(103, String.valueOf(this._path.getPort()));
            }
        }
        this.writeString(85, this._path.getPath());
        if (this._path.getQuery() != null) {
            this.writeString(101, this._path.getQuery());
        }
        Iterator iter = this.getAttributeNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (_reserved.get(name.toLowerCase()) != null) continue;
            this.writeString(72, name);
            this.writeString(83, this.getAttribute(name));
        }
        if (this._isPost) {
            MemoryStream tempStream = this._tempStream;
            this._tempStream = null;
            if (tempStream != null) {
                int sublen;
                TempBuffer tb = TempBuffer.allocate();
                byte[] buffer = tb.getBuffer();
                ReadStream postIn = tempStream.openReadAndSaveBuffer();
                while ((sublen = postIn.read(buffer, 0, buffer.length)) > 0) {
                    this._ws.write(68);
                    this._ws.write(sublen >> 8);
                    this._ws.write(sublen);
                    this._ws.write(buffer, 0, sublen);
                }
                tempStream.destroy();
                TempBuffer.free((TempBuffer)tb);
                Object var3_3 = null;
            }
        }
        this._attributes.clear();
        this._ws.write(81);
        this.readData();
        if (this._isHead) {
            this._isRequestDone = true;
        }
    }

    private void writeString(int code, String string) throws IOException {
        WriteStream ws = this._ws;
        ws.write((int)((byte)code));
        int len = string.length();
        ws.write(len >> 8);
        ws.write(len);
        ws.print(string);
    }

    private void writeString(int code, Object obj) throws IOException {
        String string = String.valueOf(obj);
        WriteStream ws = this._ws;
        ws.write((int)((byte)code));
        int len = string.length();
        ws.write(len >> 8);
        ws.write(len);
        ws.print(string);
    }

    private boolean readData() throws IOException {
        int code;
        boolean isDebug = log.isLoggable(Level.FINE);
        ReadStream is = this._rs;
        block7: while ((code = is.read()) > 0) {
            switch (code) {
                case 67: {
                    is.read();
                    is.read();
                    continue block7;
                }
                case 81: 
                case 88: {
                    is.close();
                    if (isDebug) {
                        log.fine("HMUX: " + (char)code);
                    }
                    return false;
                }
                case 89: {
                    continue block7;
                }
                case 115: {
                    String value = this.readString(is);
                    this._attributes.put("status", value.substring(0, 3));
                    if (!isDebug) continue block7;
                    log.fine("HMUX: " + (char)code + " " + value);
                    continue block7;
                }
                case 68: {
                    this._chunkLength = 256 * (is.read() & 0xFF) + (is.read() & 0xFF);
                    if (isDebug) {
                        log.fine("HMUX: " + (char)code + " " + this._chunkLength);
                    }
                    return true;
                }
            }
            int len = 256 * (is.read() & 0xFF) + (is.read() & 0xFF);
            if (isDebug) {
                log.fine("HMUX: " + (char)code + " " + len);
            }
            is.skip((long)len);
        }
        return false;
    }

    private String readString(ReadStream is) throws IOException {
        int len = 256 * (is.read() & 0xFF) + is.read();
        char[] buf = new char[len];
        is.readAll(buf, 0, len);
        return new String(buf);
    }

    public int getAvailable() throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        return this._rs.getAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        block26: {
            if (this._isKeepalive) {
                if (!this._didGet) {
                    this.getConnInput();
                }
                if (!this._isRequestDone) {
                    if (this._tempBuffer == null) {
                        this._tempBuffer = new byte[256];
                    }
                    try {
                        while (this.read(this._tempBuffer, 0, this._tempBuffer.length) > 0) {
                        }
                    }
                    catch (IOException e) {
                        this._isKeepalive = false;
                    }
                }
            }
            if (CauchoSystem.isTesting()) {
                this._isKeepalive = false;
            }
            if (this._isKeepalive) {
                HmuxStream oldSaved;
                long now = Alarm.getCurrentTime();
                Object object = LOCK;
                synchronized (object) {
                    oldSaved = _savedStream;
                    _savedStream = this;
                    _saveTime = now;
                }
                if (oldSaved == null) return;
                if (oldSaved == this) return;
                oldSaved._isKeepalive = false;
                oldSaved.close();
                return;
            }
            try {
                try {
                    if (this._ws != null) {
                        this._ws.close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this._ws = null;
                try {
                    if (this._rs != null) {
                        this._rs.close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this._rs = null;
                try {
                    if (this._os != null) {
                        this._os.close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this._os = null;
                try {
                    if (this._is != null) {
                        this._is.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this._is = null;
                Object var7_9 = null;
                if (this._s == null) break block26;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (this._s != null) {
                    this._s.close();
                }
                this._s = null;
                throw throwable;
            }
            this._s.close();
        }
        this._s = null;
    }

    static {
        LOCK = new Object();
        _reserved = new HashMap();
        _reserved.put("user-agent", "");
        _reserved.put("content-length", "");
        _reserved.put("content-encoding", "");
        _reserved.put("connection", "");
        _reserved.put("host", "");
    }
}

