/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.AlwaysModified;
import com.caucho.management.server.HostMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.Server;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.port.Port;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
extends WebAppContainer
implements EnvironmentBean,
Dependency,
SchemaBean,
EnvironmentDeployInstance {
    private static final Logger log = Logger.getLogger(Host.class.getName());
    private static final L10N L = new L10N(Host.class);
    private static EnvironmentLocal<Host> _hostLocal = new EnvironmentLocal("caucho.host");
    private HostContainer _parent;
    private HostController _controller;
    private String _hostName = "";
    private String _url;
    private String _serverName = "";
    private int _serverPort = 0;
    private String _secureHostName;
    private boolean _isDefaultHost;
    private ArrayList<String> _aliasList = new ArrayList();
    private Throwable _configException;
    private boolean _isRootDirSet;
    private boolean _isDocDirSet;
    private final Lifecycle _lifecycle;
    private String _configETag = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host(HostContainer parent, HostController controller, String hostName) {
        super(new EnvironmentClassLoader("host:" + hostName));
        try {
            try {
                this._controller = controller;
                this.setParent(parent);
                this.setHostName(hostName);
                _hostLocal.set(this, this.getClassLoader());
            }
            catch (Throwable e) {
                this._configException = e;
                Object var6_5 = null;
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            }
            Object var6_4 = null;
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            throw throwable;
        }
    }

    public static Host getLocal() {
        return _hostLocal.get();
    }

    private void setHostName(String name) throws ConfigException {
        this._hostName = name;
        if (name.equals("")) {
            this._isDefaultHost = true;
        }
        this.addHostAlias(name);
        this.getEnvironmentClassLoader().setId("host:" + name);
        int p = name.indexOf("://");
        if (p >= 0) {
            name = name.substring(p + 3);
        }
        this._serverName = name;
        p = name.lastIndexOf(58);
        if (p > 0) {
            this._serverName = name.substring(0, p);
            boolean isPort = true;
            int port = 0;
            ++p;
            while (p < name.length()) {
                char ch = name.charAt(p);
                if ('0' <= ch && ch <= '9') {
                    port = 10 * port + ch - 48;
                } else {
                    isPort = false;
                }
                ++p;
            }
            if (isPort) {
                this._serverPort = port;
            }
        }
    }

    public String getName() {
        return this._controller.getName();
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    @Override
    public Host getHost() {
        return this;
    }

    public String getSecureHostName() {
        return this._secureHostName;
    }

    public void setSecureHostName(String secureHostName) {
        this._secureHostName = secureHostName;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/host/host.rnc";
    }

    @Override
    public String getURL() {
        if (this._url != null) {
            return this._url;
        }
        if (this._hostName == null || this._hostName.equals("")) {
            Server server = this.getServer();
            if (server == null) {
                return "";
            }
            for (Port port : server.getPorts()) {
                if (!"http".equals(port.getProtocolName())) continue;
                String address = port.getAddress();
                if (address == null) {
                    address = "localhost";
                }
                return "http://" + address + ":" + port.getPort();
            }
            for (Port port : server.getPorts()) {
                if (!"https".equals(port.getProtocolName())) continue;
                String address = port.getAddress();
                if (address == null) {
                    address = "localhost";
                }
                return "https://" + address + ":" + port.getPort();
            }
            return "";
        }
        if (this._hostName.startsWith("http:") || this._hostName.startsWith("https:")) {
            return this._hostName;
        }
        return "http://" + this._hostName;
    }

    public void addHostAlias(String name) {
        if (!this._aliasList.contains(name = name.toLowerCase())) {
            this._aliasList.add(name);
        }
        if (name.equals("") || name.equals("*")) {
            this._isDefaultHost = true;
        }
        this._controller.addExtHostAlias(name);
    }

    public ArrayList<String> getAliasList() {
        return this._aliasList;
    }

    public void addHostAliasRegexp(String name) {
        name = name.trim();
        Pattern pattern = Pattern.compile(name, 2);
        this._controller.addExtHostAliasRegexp(pattern);
    }

    public boolean isDefaultHost() {
        return this._isDefaultHost;
    }

    private void setParent(HostContainer parent) {
        this._parent = parent;
        this.setDispatchServer(parent.getDispatchServer());
        if (!this._isRootDirSet) {
            this.setRootDirectory(parent.getRootDirectory());
            this._isRootDirSet = false;
        }
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return (EnvironmentClassLoader)this.getClassLoader();
    }

    @Override
    public void setRootDirectory(Path rootDir) {
        super.setRootDirectory(rootDir);
        this._isRootDirSet = true;
        if (!this._isDocDirSet) {
            this.setDocumentDirectory(rootDir);
            this._isDocDirSet = false;
        }
    }

    @Override
    public void setDocumentDirectory(Path docDir) {
        super.setDocumentDirectory(docDir);
        this._isDocDirSet = true;
    }

    @Override
    public void setConfigException(Throwable e) {
        if (e != null) {
            this._configException = e;
            this.getEnvironmentClassLoader().addDependency((Dependency)AlwaysModified.create());
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public Server getServer() {
        DispatchServer server;
        if (this._parent != null && (server = this._parent.getDispatchServer()) instanceof Server) {
            return (Server)server;
        }
        return null;
    }

    public Cluster getCluster() {
        Server server = this.getServer();
        if (server != null) {
            return server.getCluster();
        }
        return null;
    }

    public String getConfigETag() {
        return this._configETag;
    }

    public void setConfigETag(String etag) {
        this._configETag = etag;
    }

    public HostMXBean getAdmin() {
        return this._controller.getAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        if (this.getURL().equals("") && this._parent != null) {
            this._url = this._parent.getURL();
        }
        EnvironmentClassLoader loader = this.getEnvironmentClassLoader();
        loader.setId("host:" + this.getURL());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            super.start();
            loader.start();
            if (this._parent != null) {
                this._parent.clearCache();
            }
            Object var5_4 = null;
            this._lifecycle.toActive();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        thread.setContextClassLoader(oldLoader);
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.setConfigETag(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocation buildInvocation(Invocation invocation) throws Exception {
        ClassLoader oldLoader;
        Thread thread;
        block3: {
            invocation.setHostName(this._serverName);
            invocation.setPort(this._serverPort);
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.getClassLoader());
                if (this._configException != null) break block3;
                Invocation invocation2 = super.buildInvocation(invocation);
                Object var6_6 = null;
                thread.setContextClassLoader(oldLoader);
                return invocation2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        invocation.setFilterChain(new ExceptionFilterChain(this._configException));
        invocation.setDependency((Dependency)AlwaysModified.create());
        Invocation invocation3 = invocation;
        Object var6_7 = null;
        thread.setContextClassLoader(oldLoader);
        return invocation3;
    }

    @Override
    public boolean isModified() {
        return this.isDestroyed() || this.getEnvironmentClassLoader().isModified();
    }

    @Override
    public boolean isModifiedNow() {
        return this.isDestroyed() || this.getEnvironmentClassLoader().isModifiedNow();
    }

    @Override
    public boolean logModified(Logger log) {
        if (this.isDestroyed()) {
            return true;
        }
        return this.getEnvironmentClassLoader().logModified(log);
    }

    @Override
    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        EnvironmentClassLoader envLoader;
        ClassLoader oldLoader;
        Thread thread;
        block3: {
            boolean bl;
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                envLoader = this.getEnvironmentClassLoader();
                thread.setContextClassLoader(envLoader);
                if (this._lifecycle.toStopping()) break block3;
                bl = false;
                Object var6_6 = null;
                this._lifecycle.toStop();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this._lifecycle.toStop();
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            thread.setContextClassLoader(oldLoader);
            return bl;
        }
        super.stop();
        envLoader.stop();
        boolean bl = true;
        Object var6_7 = null;
        this._lifecycle.toStop();
        thread.setContextClassLoader(oldLoader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (this.isDestroyed()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentClassLoader classLoader = this.getEnvironmentClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            super.destroy();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
            classLoader.destroy();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            classLoader.destroy();
            throw throwable;
        }
    }

    public String toString() {
        return "Host[" + this.getHostName() + "]";
    }
}

