/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.make.AlwaysModified;
import com.caucho.server.cluster.Server;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.DomainName;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.server.host.HostRegexpDeployGenerator;
import com.caucho.server.host.HostSingleDeployGenerator;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppFilterChain;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostContainer
implements DispatchBuilder {
    private static final Logger log = Logger.getLogger(HostContainer.class.getName());
    private static final L10N L = new L10N(HostContainer.class);
    private EnvironmentClassLoader _classLoader;
    private DispatchServer _dispatchServer;
    private WebApp _errorWebApp;
    private String _url = "";
    private Path _rootDir;
    private RewriteDispatch _rewriteDispatch;
    private ArrayList<HostConfig> _hostDefaultList = new ArrayList();
    private DeployContainer<HostController> _hostDeploy = new DeployContainer();
    private HashMap<String, HostController> _hostMap = new HashMap();
    private ArrayList<HostConfig> _hostRegexpList = new ArrayList();
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle();

    public HostContainer() {
        this._classLoader = new EnvironmentClassLoader();
        this._rootDir = Vfs.lookup();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(EnvironmentClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURL() {
        return this._url;
    }

    public void setDispatchServer(DispatchServer server) {
        this._dispatchServer = server;
    }

    public DispatchServer getDispatchServer() {
        return this._dispatchServer;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
    }

    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    public void addHostDefault(HostConfig init) {
        this._hostDefaultList.add(init);
    }

    public ArrayList<HostConfig> getHostDefaultList() {
        return this._hostDefaultList;
    }

    public HostExpandDeployGenerator createHostDeploy() {
        return new HostExpandDeployGenerator(this._hostDeploy, this);
    }

    public void addHostDeploy(HostExpandDeployGenerator hostDeploy) {
        this._hostDeploy.add(hostDeploy);
    }

    public void addHost(HostConfig hostConfig) throws Exception {
        if (hostConfig.getRegexp() != null) {
            this._hostDeploy.add(new HostRegexpDeployGenerator(this._hostDeploy, this, hostConfig));
            return;
        }
        HostSingleDeployGenerator deploy = new HostSingleDeployGenerator(this._hostDeploy, this, hostConfig);
        this._hostDeploy.add(deploy);
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public void addEarDefault(EarConfig init) {
        this._earDefaultList.add(init);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public RewriteDispatch createRewriteDispatch() {
        if (this._rewriteDispatch == null) {
            this._rewriteDispatch = new RewriteDispatch(this.getErrorWebApp());
        }
        return this._rewriteDispatch;
    }

    public void clearCache() {
        this._hostMap.clear();
        this._dispatchServer.clearCache();
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) throws Throwable {
        FilterChain chain;
        String queryString;
        String url;
        FilterChain rewriteChain;
        boolean isAlwaysModified;
        String rawHost = invocation.getHost();
        int rawPort = invocation.getPort();
        String hostName = rawHost == null ? "" : DomainName.fromAscii(rawHost);
        invocation.setHostName(hostName);
        Host host = this.getHost(hostName, rawPort);
        if (host != null) {
            invocation = host.buildInvocation(invocation);
            isAlwaysModified = false;
        } else {
            ErrorFilterChain chain2 = new ErrorFilterChain(404);
            invocation.setFilterChain(chain2);
            invocation.setWebApp(this.getErrorWebApp());
            isAlwaysModified = true;
        }
        if (this._rewriteDispatch != null && (rewriteChain = this._rewriteDispatch.map(url = invocation.isSecure() ? "https://" + hostName + invocation.getURI() : "http://" + hostName + invocation.getURI(), queryString = invocation.getQueryString(), chain = invocation.getFilterChain())) != chain) {
            Server server = (Server)this._dispatchServer;
            WebApp webApp = server.getDefaultWebApp();
            invocation.setWebApp(webApp);
            if (webApp != null) {
                rewriteChain = new WebAppFilterChain(rewriteChain, webApp);
            }
            invocation.setFilterChain(rewriteChain);
            isAlwaysModified = false;
        }
        if (isAlwaysModified) {
            invocation.setDependency((Dependency)AlwaysModified.create());
        }
        return invocation;
    }

    public ArrayList<HostController> getHostList() {
        return this._hostDeploy.getControllers();
    }

    public Host getHost(String hostName, int port) {
        try {
            HostController controller = this.findHost(hostName, port);
            if (controller != null) {
                return (Host)controller.request();
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostController findHost(String rawHost, int rawPort) throws Exception {
        if (rawHost == null) {
            rawHost = "";
        }
        int p = rawHost.indexOf(58);
        String shortHost = rawHost;
        if (p > 0) {
            shortHost = rawHost.substring(0, p);
        }
        String fullHost = shortHost + ':' + rawPort;
        HostController hostController = null;
        HashMap<String, HostController> hashMap = this._hostMap;
        synchronized (hashMap) {
            hostController = this._hostMap.get(fullHost);
            if (hostController != null && !hostController.isDestroyed()) {
                return hostController;
            }
        }
        if (hostController == null || hostController.isDestroyed()) {
            hostController = this._hostMap.get(shortHost);
        }
        if (hostController == null || hostController.isDestroyed()) {
            hostController = this.findHostController(fullHost);
        }
        if (hostController == null || hostController.isDestroyed()) {
            hostController = this.findHostController(shortHost);
        }
        if (hostController == null || hostController.isDestroyed()) {
            hostController = this.findHostController("");
        }
        hashMap = this._hostMap;
        synchronized (hashMap) {
            if (hostController != null && !hostController.isDestroyed()) {
                this._hostMap.put(fullHost, hostController);
            } else {
                hostController = null;
                this._hostMap.remove(fullHost);
            }
        }
        return hostController;
    }

    private HostController findHostController(String hostName) throws Exception {
        return this._hostDeploy.findController(hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getErrorWebApp() {
        if (this._errorWebApp == null && this._classLoader != null && !this._classLoader.isModified()) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    this._errorWebApp = new WebApp(this.getRootDirectory().lookup("caucho-host-error"));
                    this._errorWebApp.init();
                    this._errorWebApp.start();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var5_4 = null;
                    thread.setContextClassLoader(loader);
                }
                Object var5_3 = null;
                thread.setContextClassLoader(loader);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                thread.setContextClassLoader(loader);
                throw throwable;
            }
        }
        return this._errorWebApp;
    }

    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        this._classLoader.start();
        this._lifecycle.toActive();
        this._hostDeploy.start();
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        this._hostDeploy.stop();
        this._classLoader.stop();
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._hostDeploy.destroy();
        this._classLoader.destroy();
    }
}

