/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.management.server.HostMXBean;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostAdmin;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.webbeans.Standard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostController
extends EnvironmentDeployController<Host, HostConfig> {
    private static final Logger log = Logger.getLogger(HostController.class.getName());
    private static final L10N L = new L10N(HostController.class);
    private HostContainer _container;
    private String _hostName;
    private String _regexpName;
    private Pattern _regexp;
    private String _rootDirectoryPattern;
    private ArrayList<String> _entryHostAliases = new ArrayList();
    private ArrayList<Pattern> _entryHostAliasRegexps = new ArrayList();
    private ArrayList<String> _hostAliases = new ArrayList();
    private ArrayList<Pattern> _hostAliasRegexps = new ArrayList();
    private final Var _hostVar = new Var();
    private final HostAdmin _admin = new HostAdmin(this);
    private ArrayList<Dependency> _dependList = new ArrayList();

    HostController(String id, HostConfig config, HostContainer container, Map<String, Object> varMap) {
        super(id, config);
        this.setHostName(id);
        if (varMap != null) {
            this.getVariableMap().putAll(varMap);
        }
        this.getVariableMap().put("host", this._hostVar);
        this.setContainer(container);
        this.setRootDirectory(config.calculateRootDirectory(this.getVariableMap()));
    }

    HostController(String id, Path rootDirectory, HostContainer container) {
        super(id, rootDirectory);
        this.addHostAlias(id);
        this.setHostName(id);
        this.getVariableMap().put("host", this._hostVar);
        this.setContainer(container);
    }

    public void setContainer(HostContainer container) {
        this._container = container;
        if (this._container != null) {
            for (HostConfig defaultConfig : this._container.getHostDefaultList()) {
                this.addConfigDefault(defaultConfig);
            }
        }
    }

    public String getName() {
        String name = super.getId();
        if (name != null) {
            return name;
        }
        return this.getHostName();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setHostName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        this._hostName = name = name.toLowerCase();
    }

    public void setRegexpName(String name) {
        this._regexpName = name.toLowerCase();
    }

    public void addHostAlias(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        if (!this._entryHostAliases.contains(name = name.toLowerCase())) {
            this._entryHostAliases.add(name);
        }
        this.addExtHostAlias(name);
    }

    public void addExtHostAlias(String name) {
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void addExtHostAliasRegexp(Pattern name) {
        if (!this._hostAliasRegexps.contains(name)) {
            this._hostAliasRegexps.add(name);
        }
    }

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public void setRootDirectoryPattern(String rootDirectoryPattern) {
        this._rootDirectoryPattern = rootDirectoryPattern;
    }

    public void addDepend(Path depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add((Dependency)new Depend(depend));
        }
    }

    public HostMXBean getAdmin() {
        return this._admin;
    }

    @Override
    protected DeployControllerAdmin getDeployAdmin() {
        return this._admin;
    }

    @Override
    protected void initBegin() {
        try {
            try {
                if (this.getConfig() != null && this.getHostName() == null && ((HostConfig)this.getConfig()).getHostName() != null) {
                    this.setHostName(EL.evalString(((HostConfig)this.getConfig()).getHostName(), EL.getEnvironment()));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (this._regexpName != null && this._hostName == null) {
                this._hostName = this._regexpName;
            }
            if (this._hostName == null) {
                this._hostName = "";
            }
            ArrayList<String> aliases = null;
            if (this.getConfig() != null) {
                aliases = ((HostConfig)this.getConfig()).getHostAliases();
                this._entryHostAliasRegexps.addAll(((HostConfig)this.getConfig()).getHostAliasRegexps());
                this._hostAliasRegexps.addAll(((HostConfig)this.getConfig()).getHostAliasRegexps());
            }
            for (int i = 0; aliases != null && i < aliases.size(); ++i) {
                String alias = aliases.get(i);
                alias = EL.evalString(alias, EL.getEnvironment());
                this.addHostAlias(alias);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.initBegin();
    }

    @Override
    protected String getMBeanId() {
        String name = this._hostName;
        if (name == null) {
            name = "";
        } else if (name.indexOf(58) >= 0) {
            name = name.replace(':', '-');
        }
        if (name.equals("")) {
            return "default";
        }
        return name;
    }

    @Override
    public boolean isNameMatch(String name) {
        Matcher matcher;
        int i;
        if (this._hostName.equalsIgnoreCase(name)) {
            return true;
        }
        for (i = this._hostAliases.size() - 1; i >= 0; --i) {
            if (!name.equalsIgnoreCase(this._hostAliases.get(i))) continue;
            return true;
        }
        for (i = this._hostAliasRegexps.size() - 1; i >= 0; --i) {
            Pattern alias = this._hostAliasRegexps.get(i);
            if (!alias.matcher(name).find()) continue;
            return true;
        }
        if (this._regexp != null && (matcher = this._regexp.matcher(name)).matches()) {
            Path rootDirectory = this.calculateRoot(matcher);
            if (this.getRootDirectory().equals((Object)rootDirectory)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path calculateRoot(Matcher matcher) {
        ClassLoader oldLoader;
        Thread thread;
        block6: {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getParentClassLoader());
            if (this._rootDirectoryPattern != null) break block6;
            Path path = Vfs.lookup();
            Object var10_7 = null;
            thread.setContextClassLoader(oldLoader);
            return path;
        }
        try {
            Path path;
            int length = matcher.end() - matcher.start();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put("host" + j, matcher.group(j));
            }
            varMap.put("regexp", vars);
            varMap.put("host", new TestVar(matcher.group(0), vars));
            Path path2 = path = PathBuilder.lookupPath(this._rootDirectoryPattern, varMap);
            Object var10_8 = null;
            thread.setContextClassLoader(oldLoader);
            return path2;
        }
        catch (Exception e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                Path path = Vfs.lookup(this._rootDirectoryPattern);
                Object var10_9 = null;
                thread.setContextClassLoader(oldLoader);
                return path;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostController merge(HostController newController) {
        if (this.getConfig() != null && ((HostConfig)this.getConfig()).getRegexp() != null) {
            return newController;
        }
        if (newController.getConfig() != null && ((HostConfig)newController.getConfig()).getRegexp() != null) {
            return this;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            HostController mergedController = new HostController(newController.getHostName(), this.getRootDirectory(), this._container);
            mergedController.mergeController(this);
            mergedController.mergeController(newController);
            if (!this.getHostName().equals(newController.getHostName())) {
                ConfigException e = new ConfigException(L.l("Illegal merge of {0} and {1}.  Both hosts have the same root-directory '{2}'.", (Object)this.getHostName(), (Object)newController.getHostName(), (Object)this.getRootDirectory()));
                log.warning(e.getMessage());
                log.log(Level.FINEST, e.toString(), e);
                mergedController.setConfigException(e);
            }
            HostController hostController = mergedController;
            Object var7_8 = null;
            thread.setContextClassLoader(oldLoader);
            return hostController;
        }
        catch (Throwable e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                HostController hostController = null;
                Object var7_9 = null;
                thread.setContextClassLoader(oldLoader);
                return hostController;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    @Override
    protected void mergeController(DeployController oldControllerV) {
        super.mergeController(oldControllerV);
        HostController oldController = (HostController)oldControllerV;
        this._entryHostAliases.addAll(oldController._entryHostAliases);
        if (!oldController.getHostName().equals("")) {
            this._entryHostAliases.add(oldController.getHostName());
        }
        this._entryHostAliasRegexps.addAll(oldController._entryHostAliasRegexps);
        this._hostAliases.addAll(oldController._hostAliases);
        this._hostAliasRegexps.addAll(oldController._hostAliasRegexps);
        if (this._regexp == null) {
            this._regexp = oldController._regexp;
            this._rootDirectoryPattern = oldController._rootDirectoryPattern;
        }
    }

    @Override
    protected Host instantiateDeployInstance() {
        return new Host(this._container, this, this._hostName);
    }

    @Override
    protected void configureInstance(Host host) throws Throwable {
        this._hostAliases.clear();
        this._hostAliases.addAll(this._entryHostAliases);
        WebBeansContainer webBeans = WebBeansContainer.create();
        for (Map.Entry<String, Object> entry : this.getVariableMap().entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            webBeans.addSingleton(value, entry.getKey(), Standard.class);
        }
        if (this._container != null) {
            for (EarConfig earConfig : this._container.getEarDefaultList()) {
                host.addEarDefault(earConfig);
            }
            for (WebAppConfig webAppConfig : this._container.getWebAppDefaultList()) {
                host.addWebAppDefault(webAppConfig);
            }
        }
        super.configureInstance(host);
    }

    @Override
    protected void extendJMXContext(Map<String, String> context) {
        context.put("Host", this.getMBeanId());
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HostController)) {
            return false;
        }
        HostController entry = (HostController)o;
        return this._hostName.equals(entry._hostName);
    }

    @Override
    public String toString() {
        return "HostController[" + this.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestVar {
        private String _name;
        private ArrayList<String> _regexp;

        TestVar(String name, ArrayList<String> regexp) {
            this._name = name;
            this._regexp = regexp;
        }

        public String getName() {
            return this._name;
        }

        public String getHostName() {
            return this._name;
        }

        public ArrayList<String> getRegexp() {
            return this._regexp;
        }
    }

    public class Var {
        public String getName() {
            return HostController.this.getName();
        }

        public String getHostName() {
            return HostController.this.getHostName();
        }

        public String getUrl() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getURL();
            }
            if (HostController.this._hostName.equals("")) {
                return "";
            }
            if (HostController.this._hostName.startsWith("http:") || HostController.this._hostName.startsWith("https:")) {
                return HostController.this._hostName;
            }
            return "http://" + HostController.this._hostName;
        }

        public ArrayList getRegexp() {
            return (ArrayList)HostController.this.getVariableMap().get("regexp");
        }

        public Path getRoot() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getRootDirectory();
            }
            return HostController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public Path getDocumentDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getDocumentDirectory();
            }
            return null;
        }

        public Path getDocDir() {
            return this.getDocumentDirectory();
        }

        public Path getWarDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getWarDir();
            }
            return null;
        }

        public Path getWarDir() {
            return this.getWarDirectory();
        }

        public Path getWarExpandDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getWarExpandDir();
            }
            return null;
        }

        public Path getWarExpandDir() {
            return this.getWarExpandDirectory();
        }

        public String toString() {
            return "Host[" + HostController.this.getId() + "]";
        }
    }
}

