/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGeneratorAdmin;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostExpandDeployGenerator
extends ExpandDeployGenerator<HostController> {
    private static final Logger log = Log.open(HostExpandDeployGenerator.class);
    private final HostExpandDeployGeneratorAdmin _admin = new HostExpandDeployGeneratorAdmin(this);
    private HostContainer _container;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private String _hostName;

    public HostExpandDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer) {
        super(container, hostContainer.getRootDirectory());
        this._container = hostContainer;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setHostName(RawString name) {
        this._hostName = name.getValue();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addHostDefault(HostConfig config) {
        this._hostDefaults.add(config);
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
    }

    @Override
    protected void startImpl() throws ConfigException {
        super.startImpl();
        this._admin.register();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public HostController createController(String name) {
        if (name.equals("")) {
            return null;
        }
        Path rootDirectory = this.getExpandDirectory().lookup("./" + name);
        HostController controller = new HostController(name, rootDirectory, this._container);
        Path jarPath = this.getArchiveDirectory().lookup("./" + name + ".jar");
        controller.setArchivePath(jarPath);
        if (rootDirectory.isDirectory() && !this.isValidDirectory(rootDirectory, name)) {
            return null;
        }
        if (!rootDirectory.isDirectory() && !jarPath.isFile()) {
            return null;
        }
        try {
            String hostName = this.getHostName();
            if (hostName != null) {
                ELContext parentEnv = Config.getEnvironment();
                MapVariableResolver resolver = new MapVariableResolver(controller.getVariableMap());
                ConfigELContext env = new ConfigELContext(resolver);
                controller.setHostName(EL.evalString(hostName, env));
            } else {
                controller.setHostName(name);
            }
            controller.addDepend(jarPath);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            controller.setConfigException(e);
        }
        return controller;
    }

    @Override
    protected HostController mergeController(HostController controller, String key) {
        try {
            controller.setStartupMode(this.getStartupMode());
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
            }
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            controller.setConfigException(e);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            controller.setConfigException(e);
        }
        return controller;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        super.destroyImpl();
    }

    @Override
    public boolean equals(Object o) {
        Path deployExpandPath;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HostExpandDeployGenerator deploy = (HostExpandDeployGenerator)o;
        Path expandPath = this.getExpandDirectory();
        return expandPath == (deployExpandPath = deploy.getExpandDirectory()) || expandPath != null && expandPath.equals((Object)deployExpandPath);
    }

    @Override
    public String toString() {
        return "HostExpandDeployGenerator[" + this.getExpandDirectory() + "]";
    }
}

