/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSingleDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Log.open(HostSingleDeployGenerator.class);
    private HostContainer _container;
    private HostConfig _config;
    private HostController _controller;

    public HostSingleDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostSingleDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) throws Exception {
        super(container);
        this._container = hostContainer;
        this._config = config;
        this.init();
    }

    public HostContainer getContainer() {
        return this._container;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this._container.getClassLoader();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void initImpl() {
        super.initImpl();
        String hostName = null;
        String id = null;
        String rawId = this._config.getId();
        String rawHostName = this._config.getHostName();
        if (rawId != null && (id = Config.evalString(rawId)).equals("*")) {
            id = "";
        }
        if (rawHostName != null) {
            hostName = Config.evalString(rawHostName);
            if (rawHostName.equals("*")) {
                hostName = "";
            }
        }
        if (hostName != null) {
            this._controller = new HostController(hostName, this._config, this._container, null);
            if (id != null) {
                this._controller.addHostAlias(id);
            }
        } else {
            this._controller = id != null ? new HostController(id, this._config, this._container, null) : new HostController("", this._config, this._container, null);
        }
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._controller.getName());
    }

    @Override
    public HostController generateController(String name) {
        if (this._controller.isNameMatch(name)) {
            return new HostController(this._controller.getName(), this._config, this._container, null);
        }
        return null;
    }

    @Override
    public HostController mergeController(HostController controller, String name) {
        if (this._controller.isNameMatch(name)) {
            return controller.merge(this._controller);
        }
        return controller;
    }

    @Override
    public Throwable getConfigException() {
        Throwable configException = super.getConfigException();
        if (configException == null && this._controller != null) {
            configException = this._controller.getConfigException();
        }
        return configException;
    }

    @Override
    public String toString() {
        if (this._config == null) {
            return "HostSingleDeployGenerator[]";
        }
        return "HostSingleDeployGenerator[" + this._config.getHostName() + "]";
    }
}

