/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.cluster.Server;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.connection.ConnectionController;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.ContentLengthStream;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends AbstractHttpRequest
implements ServerRequest {
    static final Logger log = Logger.getLogger(HttpRequest.class.getName());
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    static final char[] _hostCb = "Host".toCharArray();
    static final char[] _userAgentCb = "User-Agent".toCharArray();
    static final CharBuffer _http11Cb = new CharBuffer("HTTP/1.1");
    static final CharBuffer _http10Cb = new CharBuffer("HTTP/1.0");
    private String _scheme;
    private boolean _isSecure;
    private CharBuffer _method;
    private String _methodString;
    private CharBuffer _uriHost;
    private CharSequence _host;
    private CharBuffer _hostBuffer = new CharBuffer();
    private final byte[] _uri;
    private int _uriLength;
    private int _urlLengthMax = 8192;
    private CharBuffer _protocol;
    private int _version;
    private final InvocationKey _invocationKey = new InvocationKey();
    private final char[] _headerBuffer = new char[16384];
    private CharSegment[] _headerKeys;
    private CharSegment[] _headerValues;
    private int _headerCapacity = 256;
    private int _headerSize;
    private ChunkedInputStream _chunkedInputStream = new ChunkedInputStream();
    private ContentLengthStream _contentLengthStream = new ContentLengthStream();
    private ErrorPageManager _errorManager = new ErrorPageManager();
    private boolean _initAttributes;

    public HttpRequest(DispatchServer server, Connection conn) {
        super(server, conn);
        this._response = new HttpResponse(this);
        this._response.init(conn.getWriteStream());
        if (server instanceof Server) {
            this._urlLengthMax = ((Server)server).getUrlLengthMax();
        }
        this._uri = new byte[this._urlLengthMax];
        this._method = new CharBuffer();
        this._uriHost = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerCapacity = 256;
        this._headerSize = 0;
        this._headerKeys = new CharSegment[this._headerCapacity];
        this._headerValues = new CharSegment[this._headerCapacity];
        for (int i = 0; i < this._headerCapacity; ++i) {
            this._headerKeys[i] = new CharSegment();
            this._headerValues[i] = new CharSegment();
        }
    }

    @Override
    public final boolean isWaitForRead() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest() throws IOException {
        block38: {
            block37: {
                block35: {
                    hasRequest = false;
                    try {
                        try {
                            block36: {
                                this.startInvocation();
                                this.start();
                                this._response.start();
                                try {
                                    try {
                                        if (!this.readRequest(this._rawRead)) {
                                            if (HttpRequest.log.isLoggable(Level.FINE)) {
                                                HttpRequest.log.fine(this.dbgId() + "read timeout");
                                            }
                                            var2_2 = false;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (ClientDisconnectException e) {
                                        throw e;
                                    }
                                    catch (Throwable e) {
                                        HttpRequest.log.log(Level.FINER, e.toString(), e);
                                        throw new BadRequestException(String.valueOf(e));
                                    }
                                    var8_8 = null;
                                }
                                catch (Throwable var7_25) {
                                    var8_11 = null;
                                    this.finish();
                                    throw var7_25;
                                }
                                this.finish();
                                var10_12 = null;
                                break block35;
lbl-1000:
                                // 1 sources

                                {
                                    this.setStartTime();
                                    hasRequest = true;
                                    v0 = this._isSecure = this._conn.isSecure() != false || this._conn.getLocalPort() == 443;
                                    if (this._protocol.length() == 0) {
                                        this._protocol.append("HTTP/0.9");
                                    }
                                    if (HttpRequest.log.isLoggable(Level.FINE)) {
                                        HttpRequest.log.fine(this.dbgId() + this._method + " " + new String(this._uri, 0, this._uriLength) + " " + this._protocol);
                                        HttpRequest.log.fine(this.dbgId() + "Remote-IP: " + this._conn.getRemoteHost() + ":" + this._conn.getRemotePort());
                                    }
                                    this.parseHeaders(this._rawRead);
                                    if (this.getVersion() < 257 || !this.isForce10()) break block36;
                                    this._protocol.clear();
                                    this._protocol.append("HTTP/1.0");
                                    this._version = 256;
                                }
                            }
                            if ((host = this.getHost()) == null && this.getVersion() >= 257) {
                                throw new BadRequestException("HTTP/1.1 requires host");
                            }
                            ipHost = this._conn.getVirtualHost();
                            if (ipHost != null) {
                                host = ipHost;
                            }
                            this._invocationKey.init(this._isSecure, host, this._conn.getLocalPort(), this._uri, this._uriLength);
                            invocation = this._server.getInvocation(this._invocationKey);
                            if (invocation != null) ** GOTO lbl82
                            invocation = this._server.createInvocation();
                            invocation.setSecure(this._isSecure);
                            if (host != null) {
                                hostName = host.toString().toLowerCase();
                                invocation.setHost(hostName);
                                invocation.setPort(this._conn.getLocalPort());
                                p = hostName.indexOf(58);
                                if (p > 0) {
                                    invocation.setHostName(hostName.substring(0, p));
                                } else {
                                    invocation.setHostName(hostName);
                                }
                            }
                            decoder = this._server.getInvocationDecoder();
                            decoder.splitQueryAndUnescape(invocation, this._uri, this._uriLength);
                            if (!this._server.isModified()) ** GOTO lbl-1000
                            this._server.logModified(HttpRequest.log);
                            this._invocation = invocation;
                            if (this._server instanceof Server) {
                                this._invocation.setWebApp(((Server)this._server).getDefaultWebApp());
                            }
                            this.restartServer();
                            var6_24 = false;
                            var8_9 = null;
                            this.finish();
                            break block37;
lbl-1000:
                            // 1 sources

                            {
                                invocation = this._server.buildInvocation(this._invocationKey.clone(), invocation);
lbl82:
                                // 2 sources

                                invocation = invocation.getRequestInvocation(this);
                                this.setInvocation(invocation);
                                invocation.service((ServletRequest)this, (ServletResponse)this._response);
                                var8_10 = null;
                                this.finish();
                                break block38;
                            }
                        }
                        catch (ClientDisconnectException e) {
                            this._response.killCache();
                            throw e;
                        }
                        catch (Throwable e) {
                            HttpRequest.log.log(Level.FINE, e.toString(), e);
                            this._response.killCache();
                            this.killKeepalive();
                            try {
                                this._errorManager.sendServletError(e, (ServletRequest)this, (ServletResponse)this._response);
                            }
                            catch (ClientDisconnectException e1) {
                                throw e1;
                            }
                            catch (Throwable e1) {
                                HttpRequest.log.log(Level.FINE, e1.toString(), e1);
                            }
                            if (this._server instanceof Server && (webApp = ((Server)this._server).getDefaultWebApp()) != null) {
                                webApp.accessLog(this, this._response);
                            }
                            var3_21 = false;
                            var10_15 = null;
                            this.finishInvocation();
                            if (hasRequest) {
                                this._response.finish();
                                return var3_21;
                            }
                            super.finish();
                            return var3_21;
                        }
                    }
                    catch (Throwable var9_26) {
                        var10_16 = null;
                        this.finishInvocation();
                        if (hasRequest) {
                            this._response.finish();
                            throw var9_26;
                        }
                        super.finish();
                        throw var9_26;
                    }
                }
                this.finishInvocation();
                if (hasRequest) {
                    this._response.finish();
                    return var2_2;
                }
                super.finish();
                return var2_2;
            }
            var10_13 = null;
            this.finishInvocation();
            if (hasRequest) {
                this._response.finish();
                return var6_24;
            }
            super.finish();
            return var6_24;
        }
        var10_14 = null;
        this.finishInvocation();
        if (hasRequest) {
            this._response.finish();
        } else {
            super.finish();
        }
        if (HttpRequest.log.isLoggable(Level.FINE) == false) return this.isKeepalive();
        HttpRequest.log.fine(this.dbgId() + (this.isKeepalive() != false ? "keepalive" : "no-keepalive"));
        return this.isKeepalive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleResume() throws IOException {
        boolean isResume = false;
        ConnectionController controller = null;
        try {
            try {
                this.startInvocation();
                try {
                    this.setStartTime();
                    Connection conn = this.getConnection();
                    controller = conn.getController();
                    if (controller == null || this._invocation == null) {
                        this.killKeepalive();
                    } else if (this._invocation.doResume((ServletRequest)this, (ServletResponse)this._response)) {
                        controller = null;
                        isResume = true;
                    } else {
                        this.killKeepalive();
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.finish();
                    if (controller != null) {
                        controller.close();
                    }
                    throw throwable;
                }
                this.finish();
                if (controller != null) {
                    controller.close();
                }
                Object var7_10 = null;
            }
            catch (ClientDisconnectException e) {
                this._response.killCache();
                isResume = false;
                throw e;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                isResume = false;
                this._response.killCache();
                this.killKeepalive();
                boolean bl = false;
                Object var7_11 = null;
                this.finishInvocation();
                this._response.finish();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.finishInvocation();
            this._response.finish();
            throw throwable;
        }
        this.finishInvocation();
        this._response.finish();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (this.isKeepalive() ? "keepalive" : "no-keepalive"));
        }
        return isResume && controller == null;
    }

    private boolean isForce10() {
        return false;
    }

    @Override
    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void start() throws IOException {
        super.start();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._uriLength = 0;
        this._uriHost.clear();
        this._host = null;
        this._headerSize = 0;
        this._initAttributes = false;
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    private boolean readRequest(ReadStream s) throws IOException {
        int readLength;
        boolean i = false;
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        if (readOffset >= (readLength = s.getLength())) {
            try {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
            }
            catch (InterruptedIOException e) {
                log.fine(this.dbgId() + "keepalive timeout");
                return false;
            }
            readOffset = 0;
        }
        byte ch = readBuffer[readOffset++];
        while (ch == 32 || ch == 9 || ch == 13 || ch == 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        char[] buffer = this._method.getBuffer();
        int length = buffer.length;
        int offset = 0;
        while (true) {
            if (length > offset) {
                if (ch >= 97 && ch <= 122) {
                    buffer[offset++] = (char)(ch + 65 - 97);
                } else {
                    if (ch <= 32) break;
                    buffer[offset++] = (char)ch;
                }
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        this._method.setLength(offset);
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        byte[] uriBuffer = this._uri;
        int uriLength = 0;
        if (ch != 47) {
            byte ch1;
            while (ch > 32 && ch != 47) {
                if (readOffset >= readLength) {
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return false;
                    }
                    readOffset = 0;
                }
                ch = readBuffer[readOffset++];
            }
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    if (ch == 47) {
                        uriBuffer[uriLength++] = ch;
                        this._uriLength = uriLength;
                    }
                    return true;
                }
                readOffset = 0;
            }
            if ((ch1 = readBuffer[readOffset++]) != 47) {
                uriBuffer[uriLength++] = ch;
                ch = ch1;
            } else {
                block14: while (true) {
                    if (readOffset >= readLength) {
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            return true;
                        }
                        readOffset = 0;
                    }
                    ch = readBuffer[readOffset++];
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block14;
                        }
                        case 63: {
                            break block14;
                        }
                        case 47: {
                            break block14;
                        }
                        default: {
                            this._uriHost.append((char)ch);
                            continue block14;
                        }
                    }
                    break;
                }
            }
        }
        block15: while (true) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break block15;
                }
                default: {
                    uriBuffer[uriLength++] = ch;
                    if (readOffset >= readLength) {
                        readOffset = 0;
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            this._uriLength = uriLength;
                            return true;
                        }
                    }
                    ch = readBuffer[readOffset++];
                    continue block15;
                }
            }
            break;
        }
        this._uriLength = uriLength;
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        buffer = this._protocol.getBuffer();
        length = buffer.length;
        offset = 0;
        while (ch != 32 && ch != 9 && ch != 13 && ch != 10) {
            if (offset < length) {
                buffer[offset++] = ch >= 97 && ch <= 122 ? (char)(ch + 65 - 97) : (char)ch;
            }
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    this._protocol.setLength(offset);
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        this._protocol.setLength(offset);
        if (offset != 8) {
            this._protocol.append("HTTP/0.9");
            this._version = 9;
        } else {
            this._version = buffer[7] == '1' ? 257 : (buffer[7] == '0' ? 256 : 9);
        }
        while (ch != 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        s.setOffset(readOffset);
        return true;
    }

    private void parseHeaders(ReadStream s) throws IOException {
        int version = this.getVersion();
        if (version < 256) {
            return;
        }
        if (version < 257) {
            this.killKeepalive();
        }
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        char[] headerBuffer = this._headerBuffer;
        int headerOffset = 1;
        int headerBufferSize = headerBuffer.length;
        headerBuffer[0] = 122;
        int headerSize = 0;
        this._headerSize = 0;
        CharSegment[] headerKeys = this._headerKeys;
        CharSegment[] headerValues = this._headerValues;
        boolean debug = log.isLoggable(Level.FINE);
        while (true) {
            int ch;
            int keyOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) {
                        return;
                    }
                }
                if ((ch = readBuffer[readOffset++]) == 10) {
                    s.setOffset(readOffset);
                    return;
                }
                if (ch == 58) break;
                headerBuffer[headerOffset++] = (char)ch;
            }
            while (headerBuffer[headerOffset - 1] == ' ') {
                --headerOffset;
            }
            int keyLength = headerOffset - keyOffset;
            headerKeys[headerSize].init(headerBuffer, keyOffset, keyLength);
            do {
                if (readLength > readOffset) continue;
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength > 0) continue;
                return;
            } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9);
            int valueOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) break;
                }
                if (ch == 10) {
                    byte ch1 = readBuffer[readOffset];
                    if (ch1 != 32 && ch1 != 9) break;
                    ch = 32;
                    ++readOffset;
                    if (headerBuffer[headerOffset - 1] == '\r') {
                        // empty if block
                    }
                }
                int n = --headerOffset;
                ++headerOffset;
                headerBuffer[n] = (char)ch;
                ch = readBuffer[readOffset++];
            }
            while (headerBuffer[headerOffset - 1] <= ' ') {
                --headerOffset;
            }
            int valueLength = headerOffset - valueOffset;
            headerValues[headerSize].init(headerBuffer, valueOffset, valueLength);
            if (debug) {
                log.fine(this.dbgId() + headerKeys[headerSize] + ": " + headerValues[headerSize]);
            }
            if (this.addHeaderInt(headerBuffer, keyOffset, keyLength, headerValues[headerSize])) {
                // empty if block
            }
            this._headerSize = ++headerSize;
        }
    }

    int getVersion() {
        char ch;
        if (this._version > 0) {
            return this._version;
        }
        CharSegment protocol = this.getProtocolBuffer();
        if (protocol.length() < 8) {
            this._version = 9;
            return this._version;
        }
        if (protocol.equals((Object)"HTTP/1.0")) {
            this._version = 256;
            return this._version;
        }
        if (protocol.equals((Object)"HTTP/1.1")) {
            this._version = 257;
            return 257;
        }
        if (protocol.equals((Object)"HTTP/0.9")) {
            this._version = 9;
            return 9;
        }
        int i = protocol.indexOf('/');
        int len = protocol.length();
        int major = 0;
        ++i;
        while (i < len) {
            char ch2 = protocol.charAt(i);
            if (ch2 < '0' || ch2 > '9') {
                if (ch2 == '.') break;
                this._version = 256;
                return this._version;
            }
            major = 10 * major + ch2 - 48;
            ++i;
        }
        int minor = 0;
        ++i;
        while (i < len && (ch = protocol.charAt(i)) >= '0' && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        this._version = 256 * major + minor;
        return this._version;
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals((CharSegment)_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals((CharSegment)_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals((CharSegment)_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    protected CharSequence getHost() {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this._conn.getVirtualHost();
        this._host = virtualHost != null ? virtualHost : (this._uriHost.length() > 0 ? this._uriHost : this._hostHeader);
        return this._host;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri;
    }

    @Override
    public int getUriLength() {
        return this._uriLength;
    }

    @Override
    public String getProtocol() {
        switch (this._version) {
            case 257: {
                return "HTTP/1.1";
            }
            case 256: {
                return "HTTP/1.0";
            }
        }
        return "HTTP/0.9";
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    @Override
    public void setHeader(String key, String value) {
        int i;
        int tail = this._headerSize > 0 ? this._headerValues[this._headerSize - 1].getOffset() + this._headerValues[this._headerSize - 1].getLength() : 0;
        char[] headerBuffer = this._headerBuffer;
        for (i = key.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = key.charAt(i);
        }
        this._headerKeys[this._headerSize].init(headerBuffer, tail, key.length());
        tail += key.length();
        for (i = value.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = value.charAt(i);
        }
        this._headerValues[this._headerSize].init(headerBuffer, tail, value.length());
        ++this._headerSize;
    }

    @Override
    public int getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public CharSegment getHeaderKey(int index) {
        return this._headerKeys[index];
    }

    @Override
    public CharSegment getHeaderValue(int index) {
        return this._headerValues[index];
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this._headerBuffer;
        CharSegment[] headerKeys = this._headerKeys;
        for (int i = this._headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this._headerSize;
        int length = key.length();
        char[] keyBuf = this._headerBuffer;
        while (i < size) {
            CharSegment header = this._headerKeys[i];
            if (header.length() == length) {
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[offset + j])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this._headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawRead) throws IOException {
        String te;
        long contentLength = this.getLongContentLength();
        rawRead.setSibling(null);
        if (contentLength < 0L && 257 <= this.getVersion() && (te = this.getHeader("Transfer-Encoding")) != null) {
            this._chunkedInputStream.init(rawRead);
            readStream.init((StreamImpl)this._chunkedInputStream, null);
            return true;
        }
        if (contentLength >= 0L) {
            this._contentLengthStream.init(rawRead, contentLength);
            this._readStream.init((StreamImpl)this._contentLengthStream, null);
            return true;
        }
        if (this.getMethod().equals("POST")) {
            this._contentLengthStream.init(rawRead, 0L);
            this._readStream.init((StreamImpl)this._contentLengthStream, null);
            throw new BadRequestException("POST requires content-length");
        }
        this._contentLengthStream.init(rawRead, 0L);
        this._readStream.init((StreamImpl)this._contentLengthStream, null);
        return false;
    }

    @Override
    protected void skip() throws IOException {
        if (this.getMethod() == "GET") {
            return;
        }
        super.skip();
    }

    @Override
    public Object getAttribute(String name) {
        if (!this._initAttributes) {
            this.initAttributes();
        }
        return super.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (!this._initAttributes) {
            this.initAttributes();
        }
        return super.getAttributeNames();
    }

    @Override
    public String findSessionIdFromConnection() {
        TcpConnection tcpConn = this._tcpConn;
        if (!this._isSecure || tcpConn == null) {
            return null;
        }
        QSocket socket = tcpConn.getSocket();
        return null;
    }

    @Override
    public ReadStream getRawInput() {
        return this._rawRead;
    }

    private void initAttributes() {
        this._initAttributes = true;
        TcpConnection tcpConn = this._tcpConn;
        if (!this._isSecure || tcpConn == null) {
            return;
        }
        QSocket socket = tcpConn.getSocket();
        String cipherSuite = socket.getCipherSuite();
        super.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
        int keySize = socket.getCipherBits();
        if (keySize != 0) {
            super.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        try {
            X509Certificate[] certs = socket.getClientCertificates();
            if (certs != null && certs.length > 0) {
                super.setAttribute("javax.servlet.request.X509Certificate", certs[0]);
                super.setAttribute("com.caucho.servlet.login.name", certs[0].getSubjectDN());
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public void protocolCloseEvent() {
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        ConnectionController comet = this.getConnection().getController();
        if (comet == null) {
            this.skip();
        }
    }

    @Override
    protected String dbgId() {
        if ("".equals(this._server.getServerId())) {
            return "Http[" + this._conn.getId() + "] ";
        }
        return "Http[" + this._server.getServerId() + ", " + this._conn.getId() + "] ";
    }

    public String toString() {
        if ("".equals(this._server.getServerId())) {
            return "HttpRequest[" + this._conn.getId() + "]";
        }
        return "HttpRequest[" + this._server.getServerId() + ", " + this._conn.getId() + "]";
    }
}

