/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLogWriter;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessLog
extends AbstractAccessLog
implements AlarmListener {
    protected static final L10N L = new L10N(AccessLog.class);
    protected static final Logger log = Logger.getLogger(AccessLog.class.getName());
    private static final long ROLLOVER_SIZE = 0x40000000L;
    private static final long DAY = 86400000L;
    private static final long ROLLOVER_CHECK_TIME = 600000L;
    public static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private QDate _calendar = QDate.createLocal();
    private String _timeFormat;
    private int _timeFormatSecondOffset = -1;
    private final AccessLogWriter _logWriter = new AccessLogWriter(this);
    private Object _streamLock = new Object();
    private String _format;
    private Segment[] _segments;
    private ArrayList<Pattern> _excludeList = new ArrayList();
    private Pattern[] _excludes = new Pattern[0];
    private boolean _isAutoFlush;
    private boolean _isSharedBuffer = true;
    private Object _sharedBufferLock;
    private long _autoFlushTime = 60000L;
    private final CharBuffer _cb = new CharBuffer();
    private final CharBuffer _timeCharBuffer = new CharBuffer();
    private final ByteBuffer _timeBuffer = new ByteBuffer();
    private long _lastTime;
    private Alarm _alarm = new Alarm((AlarmListener)this);
    private boolean _isActive;

    public AccessLog() {
        this.setRolloverSize(new Bytes(0x40000000L));
    }

    public void setFormat(String format) {
        this._format = format;
    }

    @Override
    public void setPath(Path path) {
        super.setPath(path);
        this._logWriter.setPath(path);
    }

    @Override
    public void setPathFormat(String pathFormat) throws ConfigException {
        super.setPathFormat(pathFormat);
        this._logWriter.setPathFormat(pathFormat);
    }

    public void setArchiveFormat(String format) {
        this._logWriter.setArchiveFormat(format);
    }

    public void setRolloverCount(int count) {
        this._logWriter.setRolloverCount(count);
    }

    public void setRolloverPeriod(Period period) {
        this._logWriter.setRolloverPeriod(period);
    }

    public void setRolloverSize(Bytes bytes) {
        this._logWriter.setRolloverSize(bytes);
    }

    public void setRolloverCheckTime(long period) {
        this._logWriter.setRolloverCheckPeriod(period);
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this._isAutoFlush = isAutoFlush;
    }

    public void setAutoFlushTime(Period period) {
        this._autoFlushTime = period.getPeriod();
    }

    public void setSharedBuffer(boolean isSharedBuffer) {
        this._isSharedBuffer = isSharedBuffer;
    }

    public void addExclude(Pattern pattern) {
        this._excludeList.add(pattern);
        this._excludes = new Pattern[this._excludeList.size()];
        this._excludeList.toArray(this._excludes);
    }

    @Override
    @PostConstruct
    public void init() throws ServletException, IOException {
        this._isActive = true;
        this._alarm.queue(60000L);
        Environment.addClassLoaderListener(new CloseListener(this));
        if (this._format == null) {
            this._format = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        ArrayList<Segment> segments = this.parseFormat(this._format);
        this._segments = new Segment[segments.size()];
        segments.toArray(this._segments);
        if (this._timeFormat == null || this._timeFormat.equals("")) {
            this._timeFormat = "[%d/%b/%Y:%H:%M:%S %z]";
            this._timeFormatSecondOffset = 0;
        }
        this._logWriter.init();
        this._sharedBufferLock = this._logWriter.getBufferLock();
        if (this._autoFlushTime > 0L) {
            this._alarm.queue(this._autoFlushTime);
        }
    }

    private ArrayList<Segment> parseFormat(String format) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        block4: while (i < this._format.length()) {
            char ch;
            if ((ch = this._format.charAt(i++)) != '%' || i >= this._format.length()) {
                cb.append(ch);
                continue;
            }
            String arg = null;
            if ((ch = this._format.charAt(i++)) == '>') {
                ch = this._format.charAt(i++);
            } else if (ch == '{') {
                if (cb.length() > 0) {
                    segments.add(new Segment(this, 0, cb.toString()));
                }
                cb.clear();
                while (i < this._format.length() && this._format.charAt(i++) != '}') {
                    cb.append(this._format.charAt(i - 1));
                }
                arg = cb.toString();
                cb.clear();
                ch = this._format.charAt(i++);
            }
            switch (ch) {
                case 'D': 
                case 'T': 
                case 'U': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 'r': 
                case 's': 
                case 'u': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
                case 't': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    if (arg != null) {
                        this._timeFormat = arg;
                    }
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
            }
            cb.append('%');
            --i;
        }
        cb.append(CauchoSystem.getNewlineString());
        segments.add(new Segment(this, 0, cb.toString()));
        return segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(HttpServletRequest req, HttpServletResponse res, ServletContext application) throws IOException {
        Object data;
        AbstractHttpRequest request = (AbstractHttpRequest)req;
        AbstractHttpResponse response = (AbstractHttpResponse)res;
        if (this._excludes.length > 0) {
            data = request.getUriBuffer();
            int sublen = request.getUriLength();
            String uri = new String((byte[])data, 0, sublen);
            for (Pattern pattern : this._excludes) {
                if (!pattern.matcher(uri).find()) continue;
                return;
            }
        }
        if (this._isSharedBuffer && (!this._isAutoFlush || this._autoFlushTime <= 0L)) {
            Object object = this._sharedBufferLock;
            data = object;
            synchronized (object) {
                byte[] buffer = this._logWriter.getBuffer(8192);
                int length = this._logWriter.getLength();
                length = this.log(request, response, buffer, length, buffer.length - length);
                this._logWriter.setLength(length);
                // ** MonitorExit[data /* !! */ ] (shouldn't be in output)
            }
        } else {
            byte[] buffer = request.getLogBuffer();
            int length = this.log(request, response, buffer, 0, buffer.length);
            if (this._isAutoFlush && this._autoFlushTime > 0L) {
                this._logWriter.writeThrough(buffer, 0, length);
            } else {
                this._logWriter.writeBuffer(buffer, 0, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int log(AbstractHttpRequest request, AbstractHttpResponse response, byte[] buffer, int offset, int length) throws IOException {
        block22: for (Segment segment : this._segments) {
            String value = null;
            Object cbValue = null;
            CharSegment csValue = null;
            switch (segment._code) {
                case 0: {
                    int sublen = segment._data.length;
                    byte[] data = segment._data;
                    for (int j = 0; j < sublen; ++j) {
                        buffer[offset++] = data[j];
                    }
                    continue block22;
                }
                case 1: {
                    buffer[offset++] = segment._ch;
                    continue block22;
                }
                case 98: {
                    if (response.getStatusCode() == 304) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    offset = this.print(buffer, offset, response.getContentLength());
                    continue block22;
                }
                case 99: {
                    Cookie cookie = request.getCookie(segment._string);
                    if (cookie == null) {
                        cookie = response.getCookie(segment._string);
                    }
                    if (cookie == null) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    offset = this.print(buffer, offset, cookie.getValue());
                    continue block22;
                }
                case 2: {
                    ArrayList cookies = response.getCookies();
                    if (cookies == null || cookies.size() == 0) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    this._cb.clear();
                    response.fillCookie(this._cb, (Cookie)cookies.get(0), 0L, 0, false);
                    offset = this.print(buffer, offset, this._cb.getBuffer(), 0, this._cb.getLength());
                    continue block22;
                }
                case 104: {
                    offset = request.printRemoteAddr(buffer, offset);
                    continue block22;
                }
                case 105: {
                    csValue = request.getHeaderBuffer(segment._string);
                    if (csValue == null) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    offset = this.print(buffer, offset, csValue);
                    continue block22;
                }
                case 108: {
                    buffer[offset++] = 45;
                    continue block22;
                }
                case 110: {
                    Object oValue = request.getAttribute(segment._string);
                    if (oValue == null) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    offset = this.print(buffer, offset, String.valueOf(oValue));
                    continue block22;
                }
                case 111: {
                    value = response.getHeader(segment._string);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block22;
                }
                case 114: {
                    offset = this.print(buffer, offset, request.getMethod());
                    buffer[offset++] = 32;
                    byte[] data = request.getUriBuffer();
                    int sublen = request.getUriLength();
                    System.arraycopy(data, 0, buffer, offset, sublen);
                    offset += sublen;
                    buffer[offset++] = 32;
                    offset = this.print(buffer, offset, request.getProtocol());
                    continue block22;
                }
                case 115: {
                    int status = response.getStatusCode();
                    buffer[offset++] = (byte)(48 + status / 100 % 10);
                    buffer[offset++] = (byte)(48 + status / 10 % 10);
                    buffer[offset++] = (byte)(48 + status % 10);
                    continue block22;
                }
                case 116: {
                    long date = Alarm.getCurrentTime();
                    if (date / 1000L != this._lastTime / 1000L) {
                        this.fillTime(date);
                    }
                    int sublen = this._timeBuffer.getLength();
                    byte[] data = this._timeBuffer.getBuffer();
                    ByteBuffer byteBuffer = this._timeBuffer;
                    synchronized (byteBuffer) {
                        System.arraycopy(data, 0, buffer, offset, sublen);
                    }
                    offset += sublen;
                    continue block22;
                }
                case 84: {
                    long startTime = request.getStartTime();
                    long endTime = Alarm.getExactTime();
                    offset = this.print(buffer, offset, (int)((endTime - startTime + 500L) / 1000L));
                    continue block22;
                }
                case 68: {
                    long startTime = request.getStartTime();
                    long endTime = Alarm.getExactTime();
                    offset = this.print(buffer, offset, (int)((endTime - startTime) * 1000L));
                    continue block22;
                }
                case 117: {
                    value = request.getRemoteUser(false);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block22;
                    }
                    buffer[offset++] = 34;
                    offset = this.print(buffer, offset, value);
                    buffer[offset++] = 34;
                    continue block22;
                }
                case 85: {
                    offset = this.print(buffer, offset, request.getRequestURI());
                    continue block22;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return offset;
    }

    private int print(byte[] buffer, int offset, CharSegment cb) {
        char[] charBuffer = cb.getBuffer();
        int cbOffset = cb.getOffset();
        int length = cb.getLength();
        if (buffer.length - offset - 256 < length) {
            length = buffer.length - offset - 256;
        }
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[cbOffset + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, String s) {
        int length = s.length();
        this._cb.ensureCapacity(length);
        char[] cBuf = this._cb.getBuffer();
        s.getChars(0, length, cBuf, 0);
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cBuf[i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, char[] cb, int cbOff, int length) {
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cb[cbOff + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, long v) {
        if (v == 0L) {
            buffer[offset] = 48;
            return offset + 1;
        }
        if (v < 0L) {
            buffer[offset++] = 45;
            v = -v;
        }
        int length = 0;
        int exp = 10;
        while ((long)exp <= v && exp > 0) {
            exp = 10 * exp;
            ++length;
        }
        offset += length;
        for (int i = 0; i <= length; ++i) {
            buffer[offset - i] = (byte)(v % 10L + 48L);
            v /= 10L;
        }
        return offset + 1;
    }

    @Override
    public void flush() {
        this._logWriter.flush();
        this._logWriter.waitForFlush(5000L);
        this._logWriter.rollover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAlarm(Alarm alarm) {
        try {
            this.flush();
            Object var3_2 = null;
            alarm = this._alarm;
            if (alarm == null || !this._isActive || this._autoFlushTime <= 0L) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            alarm = this._alarm;
            if (alarm == null || !this._isActive || this._autoFlushTime <= 0L) throw throwable;
            alarm.queue(this._autoFlushTime);
            throw throwable;
        }
        alarm.queue(this._autoFlushTime);
    }

    @Override
    public void destroy() throws IOException {
        this._isActive = false;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        this._logWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTime(long date) throws IOException {
        if (date / 1000L == this._lastTime / 1000L) {
            return;
        }
        ByteBuffer byteBuffer = this._timeBuffer;
        synchronized (byteBuffer) {
            if (this._timeFormatSecondOffset >= 0 && date / 60000L == this._lastTime / 60000L) {
                byte[] bBuf = this._timeBuffer.getBuffer();
                int sec = (int)(date / 1000L % 60L);
                bBuf[this._timeFormatSecondOffset + 0] = (byte)(48 + sec / 10);
                bBuf[this._timeFormatSecondOffset + 1] = (byte)(48 + sec % 10);
                return;
            }
            this._timeCharBuffer.clear();
            QDate.formatLocal((CharBuffer)this._timeCharBuffer, (long)date, (String)this._timeFormat);
            if (this._timeFormatSecondOffset >= 0) {
                this._timeFormatSecondOffset = this._timeCharBuffer.lastIndexOf(':') + 1;
            }
            char[] cBuf = this._timeCharBuffer.getBuffer();
            int length = this._timeCharBuffer.getLength();
            this._timeBuffer.setLength(length);
            byte[] bBuf = this._timeBuffer.getBuffer();
            for (int i = length - 1; i >= 0; --i) {
                bBuf[i] = (byte)cBuf[i];
            }
        }
        this._lastTime = date;
    }

    static class Segment {
        static final int TEXT = 0;
        static final int CHAR = 1;
        static final int SET_COOKIE = 2;
        int _code;
        byte[] _data;
        byte _ch;
        String _string;
        AccessLog _log;

        Segment(AccessLog log, int code, String string) {
            this._log = log;
            this._code = code;
            this._string = string;
            if (string != null) {
                if (code == 111 && string.equalsIgnoreCase("Set-Cookie")) {
                    this._code = 2;
                }
                this._data = this._string.getBytes();
                if (code == 0 && this._string.length() == 1) {
                    this._ch = (byte)this._string.charAt(0);
                    this._code = 1;
                }
            }
        }
    }
}

