/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.log.AbstractRolloverLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.log.AccessLogBuffer;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLogWriter
extends AbstractRolloverLog
implements Runnable {
    protected static final L10N L = new L10N(AccessLogWriter.class);
    protected static final Logger log = Logger.getLogger(AccessLogWriter.class.getName());
    private static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private static final FreeList<AccessLogBuffer> _freeBuffers = new FreeList(4);
    private final AccessLog _log;
    private final Object _bufferLock = new Object();
    private AccessLogBuffer _logBuffer;
    private byte[] _buffer;
    private int _length;
    private boolean _hasThread;
    private boolean _isFlushing;
    private int _maxQueueLength = 32;
    private final ArrayList<AccessLogBuffer> _writeQueue = new ArrayList();

    AccessLogWriter(AccessLog log) {
        this._log = log;
        this._logBuffer = this.getLogBuffer();
        this._buffer = this._logBuffer.getBuffer();
        this._length = 0;
    }

    private AccessLogBuffer getLogBuffer() {
        AccessLogBuffer buffer = (AccessLogBuffer)_freeBuffers.allocate();
        if (buffer == null) {
            buffer = new AccessLogBuffer();
        }
        return buffer;
    }

    Object getBufferLock() {
        return this._bufferLock;
    }

    byte[] getBuffer(int requiredLength) {
        if (this._buffer.length - this._length < requiredLength || this.isRollover()) {
            this.flush();
        }
        return this._buffer;
    }

    int getLength() {
        return this._length;
    }

    void setLength(int length) {
        this._length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBuffer(byte[] buffer, int offset, int length) {
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._buffer.length - this._length < length || this.isRollover()) {
                this.flush();
            }
            if (this._buffer.length < length) {
                length = this._buffer.length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._length, length);
            this._length += length;
        }
    }

    void writeThrough(byte[] buffer, int offset, int length) {
        try {
            this.write(buffer, offset, length);
            this.flush();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessLogBuffer write(AccessLogBuffer logBuffer) {
        while (true) {
            ArrayList<AccessLogBuffer> arrayList = this._writeQueue;
            synchronized (arrayList) {
                if (this._writeQueue.size() < this._maxQueueLength) {
                    this._writeQueue.add(logBuffer);
                    if (!this._hasThread) {
                        this._hasThread = true;
                        ThreadPool.getThreadPool().startPriority((Runnable)this);
                    }
                    break;
                }
                if (!this._isFlushing) {
                    Object var5_4;
                    try {
                        try {
                            this._isFlushing = true;
                            log.fine("AccessLogWriter flushing log directly.");
                            this.run();
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.toString(), e);
                            var5_4 = null;
                            this._isFlushing = false;
                        }
                        var5_4 = null;
                        this._isFlushing = false;
                    }
                    catch (Throwable throwable) {
                        var5_4 = null;
                        this._isFlushing = false;
                        throw throwable;
                    }
                }
            }
        }
        AccessLogBuffer buffer = (AccessLogBuffer)_freeBuffers.allocate();
        if (buffer == null) {
            buffer = new AccessLogBuffer();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        boolean isFlush = false;
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._length > 0) {
                this._logBuffer.setLength(this._length);
                this._logBuffer = this.write(this._logBuffer);
                this._buffer = this._logBuffer.getBuffer();
                this._length = 0;
                isFlush = true;
            }
        }
        try {
            if (isFlush) {
                super.flush();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void waitForFlush(long timeout) {
        long expire = !Alarm.isTest() ? Alarm.getCurrentTime() + timeout : System.currentTimeMillis() + timeout;
        ArrayList<AccessLogBuffer> arrayList = this._writeQueue;
        synchronized (arrayList) {
            block5: while (true) {
                while (true) {
                    if (this._writeQueue.size() == 0) {
                        return;
                    }
                    long delta = !Alarm.isTest() ? expire - Alarm.getCurrentTime() : expire - System.currentTimeMillis();
                    if (delta < 0L) {
                        return;
                    }
                    try {
                        this._writeQueue.wait(delta);
                        continue block5;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void writeBuffer(AccessLogBuffer buffer) throws IOException {
        long now = Alarm.getCurrentTime();
        this.write(buffer.getBuffer(), 0, buffer.getLength());
        super.flush();
        _freeBuffers.free((Object)buffer);
        this.rolloverLog(now);
    }

    public void destroy() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    AccessLogBuffer buffer = null;
                    ArrayList<AccessLogBuffer> arrayList = this._writeQueue;
                    synchronized (arrayList) {
                        if (this._writeQueue.size() <= 0) {
                            this._hasThread = false;
                            return;
                        }
                        buffer = this._writeQueue.remove(0);
                        this._writeQueue.notifyAll();
                    }
                    if (buffer == null) continue;
                    this.writeBuffer(buffer);
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                continue;
            }
            break;
        }
    }
}

