/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.management.server.PortMXBean;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Server;
import com.caucho.server.connection.ConnectionController;
import com.caucho.server.connection.TcpConnectionController;
import com.caucho.server.port.AbstractSelectManager;
import com.caucho.server.port.PortAdmin;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ProtocolDispatchServer;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.port.Throttle;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.JsseSSLFactory;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.SSLFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class Port
implements EnvironmentListener,
Runnable {
    private static final L10N L = new L10N(Port.class);
    private static final Logger log = Logger.getLogger(Port.class.getName());
    private static final int DEFAULT = -51966;
    private FreeList<TcpConnection> _freeConn = new FreeList(32);
    private ProtocolDispatchServer _server;
    private String _serverId = "";
    private String _address;
    private int _port;
    private Protocol _protocol;
    private SSLFactory _sslFactory;
    private boolean _isSecure;
    private InetAddress _socketAddress;
    private int _acceptThreadMin = -51966;
    private int _acceptThreadMax = -51966;
    private int _acceptListenBacklog = -51966;
    private int _connectionMax = -51966;
    private int _keepaliveMax = -51966;
    private long _keepaliveTimeMax = -51966L;
    private long _keepaliveTimeout = -51966L;
    private long _keepaliveSelectThreadTimeout = -51966L;
    private int _minSpareConnection = 16;
    private long _socketTimeout = -51966L;
    private long _suspendTimeMax = -51966L;
    private boolean _tcpNoDelay = true;
    private String _virtualHost;
    private final PortAdmin _admin = new PortAdmin(this);
    private QServerSocket _serverSocket;
    private Throttle _throttle;
    private AbstractSelectManager _selectManager;
    private ArrayList<TcpConnection> _suspendList = new ArrayList();
    private Alarm _suspendAlarm;
    private ArrayList<TcpConnection> _writeSuspendList = new ArrayList();
    private volatile int _threadCount;
    private final Object _threadCountLock = new Object();
    private volatile int _idleThreadCount;
    private volatile int _startThreadCount;
    private volatile int _connectionCount;
    private volatile long _lifetimeRequestCount;
    private volatile long _lifetimeKeepaliveCount;
    private volatile long _lifetimeClientDisconnectCount;
    private volatile long _lifetimeRequestTime;
    private volatile long _lifetimeReadBytes;
    private volatile long _lifetimeWriteBytes;
    private volatile int _keepaliveCount;
    private volatile int _keepaliveThreadCount;
    private final Object _keepaliveCountLock = new Object();
    private volatile boolean _isBind;
    private volatile boolean _isPostBind;
    private final Lifecycle _lifecycle = new Lifecycle();

    public Port() {
    }

    public Port(ClusterServer server) {
    }

    public void setParent(ProtocolDispatchServer parent) {
        this.setServer(parent);
    }

    public void setServer(ProtocolDispatchServer protocolServer) {
        this._server = protocolServer;
        if (this._protocol != null) {
            this._protocol.setServer(protocolServer);
        }
        if (protocolServer instanceof Server) {
            Server server = (Server)protocolServer;
            if (this._acceptThreadMax == -51966) {
                this._acceptThreadMax = server.getAcceptThreadMax();
            }
            if (this._acceptThreadMin == -51966) {
                this._acceptThreadMin = server.getAcceptThreadMin();
            }
            if (this._acceptListenBacklog == -51966) {
                this._acceptListenBacklog = server.getAcceptListenBacklog();
            }
            if (this._connectionMax == -51966) {
                this._connectionMax = server.getConnectionMax();
            }
            if (this._keepaliveMax == -51966) {
                this._keepaliveMax = server.getKeepaliveMax();
            }
            if (this._keepaliveTimeMax == -51966L) {
                this._keepaliveTimeMax = server.getKeepaliveConnectionTimeMax();
            }
            if (this._keepaliveTimeout == -51966L) {
                this._keepaliveTimeout = server.getKeepaliveTimeout();
            }
            if (this._keepaliveSelectThreadTimeout == -51966L) {
                this._keepaliveSelectThreadTimeout = server.getKeepaliveSelectThreadTimeout();
            }
            if (this._suspendTimeMax == -51966L) {
                this._suspendTimeMax = server.getSuspendTimeMax();
            }
            if (this._socketTimeout == -51966L) {
                this._socketTimeout = server.getSocketTimeout();
            }
        }
    }

    public ProtocolDispatchServer getServer() {
        return this._server;
    }

    public void setId(String id) {
        this._serverId = id;
    }

    public void setServerId(String id) {
        this._serverId = id;
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setType(Class cl) {
        this.setClass(cl);
    }

    public void setClass(Class cl) {
    }

    public PortMXBean getAdmin() {
        return this._admin;
    }

    public void setProtocol(Protocol protocol) throws ConfigException {
        this._protocol = protocol;
        this._protocol.setServer(this._server);
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getProtocolName() {
        if (this._protocol != null) {
            return this._protocol.getProtocolName();
        }
        return null;
    }

    public void setAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            address = null;
        }
        this._address = address;
        if (address != null) {
            this._socketAddress = InetAddress.getByName(address);
        }
    }

    public void setHost(String address) throws UnknownHostException {
        this.setAddress(address);
    }

    public String getAddress() {
        return this._address;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void setVirtualHost(String host) {
        this._virtualHost = host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setSSL(SSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory createOpenssl() throws ConfigException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.vfs.OpenSSLFactory", false, loader);
            this._sslFactory = (SSLFactory)cl.newInstance();
            return this._sslFactory;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("<openssl> requires Resin Professional.  See http://www.caucho.com for more information."));
        }
    }

    public JsseSSLFactory createJsse() {
        return new JsseSSLFactory();
    }

    public void setJsseSsl(JsseSSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory getSSL() {
        return this._sslFactory;
    }

    public boolean isSSL() {
        return this._sslFactory != null;
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isSecure() {
        return this._isSecure || this._sslFactory != null;
    }

    public void setServerSocket(QServerSocket socket) {
        this._serverSocket = socket;
    }

    public void setAcceptThreadMin(int minSpare) throws ConfigException {
        if (minSpare < 1) {
            throw new ConfigException(L.l("accept-thread-min must be at least 1."));
        }
        this._acceptThreadMin = minSpare;
    }

    public int getAcceptThreadMin() {
        return this._acceptThreadMin;
    }

    public void setAcceptThreadMax(int maxSpare) throws ConfigException {
        if (maxSpare < 1) {
            throw new ConfigException(L.l("accept-thread-max must be at least 1."));
        }
        this._acceptThreadMax = maxSpare;
    }

    public int getAcceptThreadMax() {
        return this._acceptThreadMax;
    }

    public void setAcceptListenBacklog(int listen) throws ConfigException {
        if (listen < 1) {
            throw new ConfigException(L.l("accept-listen-backlog must be at least 1."));
        }
        this._acceptListenBacklog = listen;
    }

    public int getAcceptListenBacklog() {
        return this._acceptListenBacklog;
    }

    public void setConnectionMax(int max) {
        this._connectionMax = max;
    }

    public int getConnectionMax() {
        return this._connectionMax;
    }

    public boolean isIgnoreClientDisconnect() {
        return this._server.isIgnoreClientDisconnect();
    }

    public void setSocketTimeout(Period period) {
        this._socketTimeout = period.getPeriod();
    }

    public void setReadTimeout(Period period) {
        this.setSocketTimeout(period);
    }

    public long getSocketTimeout() {
        return this._socketTimeout;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this._tcpNoDelay = tcpNoDelay;
    }

    public void setThrottleConcurrentMax(int max) {
        Throttle throttle = this.createThrottle();
        throttle.setMaxConcurrentRequests(max);
    }

    public long getThrottleConcurrentMax() {
        if (this._throttle != null) {
            return this._throttle.getMaxConcurrentRequests();
        }
        return -1L;
    }

    public void setWriteTimeout(Period period) {
    }

    private Throttle createThrottle() {
        if (this._throttle == null) {
            this._throttle = Throttle.createPro();
            if (this._throttle == null) {
                throw new ConfigException(L.l("throttle configuration requires Resin Professional"));
            }
        }
        return this._throttle;
    }

    public void setMinSpareListen(int minSpare) throws ConfigException {
        this.setAcceptThreadMin(minSpare);
    }

    public void setMaxSpareListen(int maxSpare) throws ConfigException {
        this.setAcceptThreadMax(maxSpare);
    }

    public int getConnectionCount() {
        return this._connectionCount;
    }

    public int getCometIdleCount() {
        return this._suspendList.size();
    }

    public int getDuplexCount() {
        return this._writeSuspendList.size();
    }

    public long getLifetimeRequestCount() {
        return this._lifetimeRequestCount;
    }

    public long getLifetimeKeepaliveCount() {
        return this._lifetimeKeepaliveCount;
    }

    public long getLifetimeClientDisconnectCount() {
        return this._lifetimeClientDisconnectCount;
    }

    public long getLifetimeRequestTime() {
        return this._lifetimeRequestTime;
    }

    public long getLifetimeReadBytes() {
        return this._lifetimeReadBytes;
    }

    public long getLifetimeWriteBytes() {
        return this._lifetimeWriteBytes;
    }

    public void setKeepaliveMax(int max) {
        this._keepaliveMax = max;
    }

    public int getKeepaliveMax() {
        return this._keepaliveMax;
    }

    public void setKeepaliveConnectionTimeMax(Period period) {
        this._keepaliveTimeMax = period.getPeriod();
    }

    public long getKeepaliveConnectionTimeMax() {
        return this._keepaliveTimeMax;
    }

    public long getSuspendTimeMax() {
        return this._suspendTimeMax;
    }

    public void setSuspendTimeMax(Period period) {
        this._suspendTimeMax = period.getPeriod();
    }

    public void setKeepaliveTimeout(Period period) {
        this._keepaliveTimeout = period.getPeriod();
    }

    public long getKeepaliveTimeout() {
        return this._keepaliveTimeout;
    }

    public long getKeepaliveSelectThreadTimeout() {
        return this._keepaliveSelectThreadTimeout;
    }

    public int getKeepaliveSelectMax() {
        if (this.getSelectManager() != null) {
            return this.getSelectManager().getSelectMax();
        }
        return -1;
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public int getActiveThreadCount() {
        return this._threadCount - this._idleThreadCount;
    }

    public int getIdleThreadCount() {
        return this._idleThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepaliveCount() {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            return this._keepaliveCount;
        }
    }

    public Lifecycle getLifecycleState() {
        return this._lifecycle;
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public int getActiveConnectionCount() {
        return this._threadCount - this._idleThreadCount;
    }

    public int getKeepaliveConnectionCount() {
        return this.getKeepaliveCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepaliveThreadCount() {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            return this._keepaliveThreadCount;
        }
    }

    public int getSelectConnectionCount() {
        if (this._selectManager != null) {
            return this._selectManager.getSelectCount();
        }
        return -1;
    }

    public int getFreeKeepalive() {
        int freeKeepalive = this._keepaliveMax - this._keepaliveCount;
        int freeConnections = this._connectionMax - this._connectionCount - this._minSpareConnection;
        int freeSelect = this._server.getFreeSelectKeepalive();
        if (freeKeepalive < freeConnections) {
            return freeSelect < freeKeepalive ? freeSelect : freeKeepalive;
        }
        return freeSelect < freeConnections ? freeSelect : freeConnections;
    }

    public boolean matchesServerId(String serverId) {
        return this.getServerId().equals("*") || this.getServerId().equals(serverId);
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        if (this._server instanceof EnvironmentBean) {
            Environment.addEnvironmentListener(this, ((EnvironmentBean)((Object)this._server)).getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws Exception {
        Port port = this;
        synchronized (port) {
            if (this._isBind) {
                return;
            }
            this._isBind = true;
        }
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("`{0}' must have a configured protocol before starting.", (Object)this));
        }
        if (this._port == 0) {
            return;
        }
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        if (this._serverSocket != null) {
            if (this._port != 0) {
                if (this._address != null) {
                    log.info("listening to " + this._address + ":" + this._port);
                } else {
                    log.info("listening to " + this._port);
                }
            }
        } else if (this._sslFactory != null && this._socketAddress != null) {
            this._serverSocket = this._sslFactory.create(this._socketAddress, this._port);
            log.info(this._protocol.getProtocolName() + "s listening to " + this._socketAddress.getHostName() + ":" + this._port);
        } else if (this._sslFactory != null) {
            if (this._address == null) {
                this._serverSocket = this._sslFactory.create(null, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to *:" + this._port);
            } else {
                InetAddress addr = InetAddress.getByName(this._address);
                this._serverSocket = this._sslFactory.create(addr, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to " + this._address + ":" + this._port);
            }
        } else if (this._socketAddress != null) {
            this._serverSocket = QJniServerSocket.create(this._socketAddress, this._port, this._acceptListenBacklog);
            log.info(this._protocol.getProtocolName() + " listening to " + this._socketAddress.getHostName() + ":" + this._port);
        } else {
            this._serverSocket = QJniServerSocket.create(this._port, this._acceptListenBacklog);
            log.info(this._protocol.getProtocolName() + " listening to *:" + this._port);
        }
        assert (this._serverSocket != null);
        this.postBind();
    }

    public void bind(QServerSocket ss) throws Exception {
        if (ss == null) {
            throw new NullPointerException();
        }
        this._isBind = true;
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("'{0}' must have a configured protocol before starting.", (Object)this));
        }
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        this._serverSocket = ss;
        String scheme = this._protocol.getProtocolName();
        if (this._address != null) {
            log.info(scheme + " listening to " + this._address + ":" + this._port);
        } else {
            log.info(scheme + " listening to *:" + this._port);
        }
        if (this._sslFactory != null) {
            this._serverSocket = this._sslFactory.bind(this._serverSocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBind() {
        Port port = this;
        synchronized (port) {
            if (this._isPostBind) {
                return;
            }
            this._isPostBind = true;
        }
        if (this._tcpNoDelay) {
            this._serverSocket.setTcpNoDelay(this._tcpNoDelay);
        }
        this._serverSocket.setConnectionSocketTimeout((int)this.getSocketTimeout());
        if (this._serverSocket.isJNI() && this._server.isSelectManagerEnabled()) {
            this._selectManager = this._server.getSelectManager();
            if (this._selectManager == null) {
                throw new IllegalStateException(L.l("Cannot load select manager"));
            }
        }
        if (this._keepaliveMax < 0) {
            this._keepaliveMax = this._server.getKeepaliveMax();
        }
        if (this._keepaliveMax < 0 && this._selectManager != null) {
            this._keepaliveMax = this._selectManager.getSelectMax();
        }
        if (this._keepaliveMax < 0) {
            this._keepaliveMax = 256;
        }
        this._admin.register();
    }

    public QServerSocket bindForWatchdog() throws IOException {
        QServerSocket ss;
        if (this._socketAddress != null) {
            ss = QJniServerSocket.createJNI(this._socketAddress, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to " + this._socketAddress.getHostName() + ":" + this._port);
        } else {
            ss = QJniServerSocket.createJNI(null, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to *:" + this._port);
        }
        if (!ss.isJNI()) {
            ss.close();
            return ss;
        }
        if (this._tcpNoDelay) {
            ss.setTcpNoDelay(this._tcpNoDelay);
        }
        ss.setConnectionSocketTimeout((int)this.getSocketTimeout());
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this._port == 0) {
            return;
        }
        if (!this._lifecycle.toStarting()) {
            return;
        }
        boolean isValid = false;
        try {
            this.bind();
            this.postBind();
            String name = "resin-port-" + this._serverSocket.getLocalPort();
            Thread thread = new Thread((Runnable)this, name);
            thread.setDaemon(true);
            thread.start();
            this.enable();
            this._suspendAlarm = new Alarm((AlarmListener)new SuspendReaper());
            this._suspendAlarm.queue(60000L);
            isValid = true;
            Object var5_4 = null;
            if (!isValid) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!isValid) {
                this.close();
            }
            throw throwable;
        }
    }

    void enable() {
        if (this._lifecycle.toActive()) {
            this._serverSocket.listen(this._acceptListenBacklog);
        }
    }

    void disable() {
        if (this._lifecycle.toStop()) {
            this._serverSocket.listen(0);
            if (this._port != 0) {
                if (this._address != null) {
                    log.info(this._protocol.getProtocolName() + " disabled " + this._address + ":" + this._port);
                } else {
                    log.info(this._protocol.getProtocolName() + " disabled *:" + this._port);
                }
            }
        }
    }

    public AbstractSelectManager getSelectManager() {
        return this._selectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(TcpConnection conn, boolean isFirst) {
        block26: {
            boolean bl;
            block25: {
                boolean bl2;
                block24: {
                    Port port;
                    boolean bl3;
                    block23: {
                        try {
                            try {
                                Port port2 = this;
                                synchronized (port2) {
                                    ++this._idleThreadCount;
                                    if (isFirst) {
                                        --this._startThreadCount;
                                        if (this._startThreadCount < 0) {
                                            Thread.dumpStack();
                                        }
                                    }
                                    if (this._acceptThreadMax < this._idleThreadCount) {
                                        bl3 = false;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 22] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                                        Object var7_8 = null;
                                        port = this;
                                        break block23;
                                    }
                                }
                                while (this._lifecycle.isActive()) {
                                    QSocket socket = conn.startSocket();
                                    Thread.interrupted();
                                    if (this._serverSocket.accept(socket)) {
                                        conn.initSocket();
                                        if (this._throttle.accept(socket)) {
                                            bl2 = true;
                                            break block24;
                                        } else {
                                            socket.close();
                                            continue;
                                        }
                                    }
                                    if (this._acceptThreadMax >= this._idleThreadCount) continue;
                                    bl = false;
                                    break block25;
                                }
                                break block26;
                            }
                            catch (Throwable e) {
                                if (this._lifecycle.isActive() && log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, e.toString(), e);
                                }
                                Object var7_12 = null;
                                Port port3 = this;
                                synchronized (port3) {
                                    --this._idleThreadCount;
                                    if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) return false;
                                    this.notify();
                                    return false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            Port port4 = this;
                            synchronized (port4) {
                                --this._idleThreadCount;
                                if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) throw throwable;
                                this.notify();
                                throw throwable;
                            }
                        }
                    }
                    synchronized (port) {
                        --this._idleThreadCount;
                        if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) return bl3;
                        this.notify();
                        return bl3;
                    }
                }
                Object var7_9 = null;
                Port port = this;
                synchronized (port) {
                    --this._idleThreadCount;
                    if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) return bl2;
                    this.notify();
                    return bl2;
                }
            }
            Object var7_10 = null;
            Port port = this;
            synchronized (port) {
                --this._idleThreadCount;
                if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) return bl;
                this.notify();
                return bl;
            }
        }
        Object var7_11 = null;
        Port port = this;
        synchronized (port) {
            --this._idleThreadCount;
            if (this._idleThreadCount + this._startThreadCount >= this._acceptThreadMin) return false;
            this.notify();
            return false;
        }
    }

    void closeSocket(QSocket socket) {
        if (this._throttle != null) {
            this._throttle.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startConnection(TcpConnection conn) {
        Port port = this;
        synchronized (port) {
            --this._startThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadBegin(TcpConnection conn) {
        Object object = this._threadCountLock;
        synchronized (object) {
            ++this._threadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadEnd(TcpConnection conn) {
        Object object = this._threadCountLock;
        synchronized (object) {
            --this._threadCount;
        }
    }

    public boolean allowKeepalive(long acceptStartTime) {
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (acceptStartTime + this._keepaliveTimeMax < Alarm.getCurrentTime()) {
            return false;
        }
        if (this._keepaliveMax <= this._keepaliveCount) {
            return false;
        }
        return this._connectionMax > this._connectionCount + this._minSpareConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean keepaliveBegin(TcpConnection conn, long acceptStartTime) {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            if (!this._lifecycle.isActive()) {
                return false;
            }
            if (this._connectionMax <= this._connectionCount + this._minSpareConnection) {
                log.warning(conn + " failed keepalive, connection-max=" + this._connectionCount);
                return false;
            }
            ++this._keepaliveCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepaliveEnd(TcpConnection conn) {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            --this._keepaliveCount;
            if (this._keepaliveCount < 0) {
                int count = this._keepaliveCount;
                this._keepaliveCount = 0;
                log.warning("internal error: negative keepalive count " + count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepaliveThreadBegin() {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            ++this._keepaliveThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepaliveThreadEnd() {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            --this._keepaliveThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean suspend(TcpConnection conn) {
        boolean isResume = false;
        ArrayList<TcpConnection> arrayList = this._suspendList;
        synchronized (arrayList) {
            if (!conn.isWake()) {
                if (conn.isComet()) {
                    this._suspendList.add(conn);
                    return true;
                }
                return false;
            }
            isResume = true;
            conn.setResume();
        }
        if (isResume) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(conn.dbgId() + "schedule resume");
            }
            ThreadPool.getThreadPool().schedule((Runnable)((Object)conn));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean detach(TcpConnection conn) {
        ArrayList<TcpConnection> arrayList = this._suspendList;
        synchronized (arrayList) {
            return this._suspendList.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resume(TcpConnection conn) {
        ArrayList<TcpConnection> arrayList = this._suspendList;
        synchronized (arrayList) {
            if (!this._suspendList.remove(conn)) {
                return false;
            }
            conn.setResume();
        }
        if (conn != null) {
            ThreadPool.getThreadPool().schedule((Runnable)((Object)conn));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerDuplex(TcpConnection conn) {
        Runnable readTask;
        ConnectionController connController = conn.getController();
        if (!(connController instanceof TcpConnectionController)) {
            log.warning(connController + " should be duplex TcpConnectionConroller");
            return false;
        }
        TcpConnectionController tcpController = (TcpConnectionController)connController;
        boolean isResumeWrite = false;
        ArrayList<TcpConnection> arrayList = this._writeSuspendList;
        synchronized (arrayList) {
            if (conn.isWake()) {
                isResumeWrite = true;
                conn.setResume();
            } else if (conn.isComet()) {
                this._writeSuspendList.add(conn);
            } else {
                return false;
            }
        }
        if (isResumeWrite) {
            Runnable writeTask = tcpController.getWriteTask();
            if (writeTask == null) {
                return false;
            }
            ThreadPool.getThreadPool().schedule(writeTask);
        }
        if ((readTask = tcpController.getReadTask()) == null) {
            return false;
        }
        ThreadPool.getThreadPool().schedule(readTask);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean suspendWrite(TcpConnection conn) {
        boolean isResumeWrite = false;
        ArrayList<TcpConnection> arrayList = this._writeSuspendList;
        synchronized (arrayList) {
            if (conn.isWake()) {
                conn.setResume();
                return false;
            }
            if (conn.isComet()) {
                this._writeSuspendList.add(conn);
                return true;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resumeWrite(TcpConnection conn, ConnectionController controller) {
        TcpConnectionController tcpController = (TcpConnectionController)controller;
        ArrayList<TcpConnection> arrayList = this._suspendList;
        synchronized (arrayList) {
            if (!this._writeSuspendList.remove(conn)) {
                return false;
            }
            conn.setResume();
        }
        Runnable writeTask = tcpController.getWriteTask();
        if (writeTask != null) {
            ThreadPool.getThreadPool().schedule(writeTask);
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this._lifecycle.isAfterActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this._lifecycle.isDestroyed()) {
            try {
                boolean isStart;
                Port port = this;
                synchronized (port) {
                    if (this._idleThreadCount > 0) {
                        this.wait(1L);
                    }
                    boolean bl = isStart = this._startThreadCount + this._idleThreadCount < this._acceptThreadMin;
                    if (this._connectionMax <= this._connectionCount) {
                        isStart = false;
                    }
                    if (!this._lifecycle.isActive()) {
                        isStart = false;
                    }
                    if (!isStart) {
                        Thread.interrupted();
                        this.wait(60000L);
                    }
                    if (isStart) {
                        ++this._connectionCount;
                        ++this._startThreadCount;
                    }
                }
                if (!isStart || !this._lifecycle.isActive()) continue;
                TcpConnection conn = (TcpConnection)this._freeConn.allocate();
                if (conn == null) {
                    conn = new TcpConnection(this, this._serverSocket.createSocket());
                    conn.setRequest(this._protocol.createRequest(conn));
                }
                conn.start();
                ThreadPool.getThreadPool().schedule((Runnable)((Object)conn));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void environmentBind(EnvironmentClassLoader loader) {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.close();
    }

    void free(TcpConnection conn) {
        this.closeConnection(conn);
        if (!this._freeConn.free((Object)conn)) {
            conn.destroy();
        }
    }

    void kill(TcpConnection conn) {
        this.closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(TcpConnection conn) {
        Port port = this;
        synchronized (port) {
            if (this._connectionCount-- == this._connectionMax) {
                try {
                    this.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TcpConnection conn;
        Environment.removeEnvironmentListener(this);
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " closing");
        }
        Alarm suspendAlarm = this._suspendAlarm;
        this._suspendAlarm = null;
        if (suspendAlarm != null) {
            suspendAlarm.dequeue();
        }
        QServerSocket serverSocket = this._serverSocket;
        this._serverSocket = null;
        this._selectManager = null;
        AbstractSelectManager selectManager = null;
        if (this._server != null) {
            selectManager = this._server.getSelectManager();
            this._server.initSelectManager(null);
        }
        InetAddress localAddress = null;
        int localPort = 0;
        if (serverSocket != null) {
            localAddress = serverSocket.getLocalAddress();
            localPort = serverSocket.getLocalPort();
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                QServerSocket e = serverSocket;
                synchronized (e) {
                    serverSocket.notifyAll();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (selectManager != null) {
            try {
                selectManager.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (localPort > 0) {
            int idleCount = this._idleThreadCount + this._startThreadCount;
            for (int i = 0; i < idleCount + 10; ++i) {
                try {
                    Socket socket = new Socket();
                    InetSocketAddress addr = localAddress == null || localAddress.getHostAddress().startsWith("0.") ? new InetSocketAddress("127.0.0.1", localPort) : new InetSocketAddress(localAddress, localPort);
                    socket.connect(addr, 100);
                    socket.close();
                    continue;
                }
                catch (ConnectException e) {
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
        }
        while ((conn = (TcpConnection)this._freeConn.allocate()) != null) {
            conn.destroy();
        }
        log.finest(this + " closed");
    }

    public String toString() {
        return "Port[" + this.getAddress() + ":" + this.getPort() + "]";
    }

    public class SuspendReaper
    implements AlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleAlarm(Alarm alarm) {
            try {
                ArrayList<TcpConnection> oldList = null;
                long now = Alarm.getCurrentTime();
                ArrayList arrayList = Port.this._suspendList;
                synchronized (arrayList) {
                    for (int i = Port.this._suspendList.size() - 1; i >= 0; --i) {
                        TcpConnection conn = (TcpConnection)Port.this._suspendList.get(i);
                        if (conn.getSuspendTime() + Port.this._suspendTimeMax >= now) continue;
                        Port.this._suspendList.remove(i);
                        if (oldList == null) {
                            oldList = new ArrayList<TcpConnection>();
                        }
                        oldList.add(conn);
                    }
                }
                if (oldList != null) {
                    for (int i = 0; i < oldList.size(); ++i) {
                        TcpConnection conn = (TcpConnection)oldList.get(i);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this + " comet idle timeout " + conn);
                        }
                        conn.destroy();
                    }
                }
                Object var10_10 = null;
                if (Port.this.isClosed()) return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (Port.this.isClosed()) throw throwable;
                alarm.queue(60000L);
                throw throwable;
            }
            alarm.queue(60000L);
        }
    }
}

