/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.port.Port;
import com.caucho.server.port.Protocol;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ProtocolPort
extends Port {
    private static final L10N L = new L10N(ProtocolPort.class);
    private static final Logger log = Logger.getLogger(ProtocolPort.class.getName());
    private Class _protocolClass;
    private ContainerProgram _init;

    public ProtocolPort() {
    }

    public ProtocolPort(ClusterServer server) {
        super(server);
    }

    public void setType(Class cl) {
        this.setClass(cl);
    }

    public void setClass(Class cl) {
        Config.validate(cl, Protocol.class);
        this._protocolClass = cl;
    }

    public void setInit(ContainerProgram init) {
        if (this._protocolClass == null) {
            throw new ConfigException(L.l("<init> requires a protocol class"));
        }
        this._init = init;
    }

    @PostConstruct
    public void init() throws ConfigException {
        Protocol protocol;
        if (this._protocolClass != null) {
            WebBeansContainer webBeans = WebBeansContainer.create();
            protocol = (Protocol)webBeans.createTransientObjectNoInit(this._protocolClass);
            if (this._init != null) {
                this._init.configure(protocol);
            }
        } else {
            throw new ConfigException(L.l("protocol requires either a class"));
        }
        Config.init(protocol);
        this.setProtocol(protocol);
    }
}

