/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.loader.Environment;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.TcpConnectionMXBean;
import com.caucho.server.connection.BroadcastTask;
import com.caucho.server.connection.ConnectionController;
import com.caucho.server.connection.TcpConnectionController;
import com.caucho.server.port.Port;
import com.caucho.server.port.PortConnection;
import com.caucho.server.resin.Resin;
import com.caucho.util.Alarm;
import com.caucho.util.ThreadPool;
import com.caucho.util.ThreadTask;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpConnection
extends PortConnection
implements ThreadTask {
    private static final Logger log = Logger.getLogger(TcpConnection.class.getName());
    private final QSocket _socket;
    private boolean _isInUse;
    private boolean _isActive;
    private boolean _isClosed;
    private boolean _isKeepalive;
    private boolean _isResume;
    private boolean _isWake;
    private boolean _isDead;
    private final Object _requestLock = new Object();
    private final String _id;
    private String _dbgId;
    private String _name;
    private boolean _isSecure;
    private final Admin _admin = new Admin();
    private String _state = "unknown";
    private long _connectionStartTime;
    private long _requestStartTime;
    private long _suspendTime;
    private Thread _thread;

    TcpConnection(Port port, QSocket socket) {
        this.setPort(port);
        this._isSecure = port.isSecure();
        int id = this.getId();
        String protocol = port.getProtocol().getProtocolName();
        if (port.getAddress() == null) {
            String serverId;
            Resin resin = Resin.getLocal();
            String string = serverId = resin != null ? resin.getServerId() : null;
            if (serverId == null) {
                serverId = "";
            }
            this._id = protocol + "-" + serverId + "-" + port.getPort() + "-" + id;
            this._name = protocol + "-" + port.getPort() + "-" + id;
        } else {
            this._id = protocol + "-" + port.getAddress() + ":" + port.getPort() + "-" + id;
            this._name = protocol + "-" + port.getAddress() + "-" + port.getPort() + "-" + id;
        }
        this._socket = socket;
    }

    public String getName() {
        return this._name;
    }

    public long getSuspendTime() {
        return this._suspendTime;
    }

    public void initSocket() throws IOException {
        this._isClosed = false;
        this._isInUse = true;
        this._isKeepalive = false;
        this.getWriteStream().init(this._socket.getStream());
        this.getReadStream().init(this._socket.getStream(), this.getWriteStream());
        if (log.isLoggable(Level.FINE)) {
            Port port = this.getPort();
            if (port != null) {
                log.fine(this.dbgId() + "starting connection " + this + ", total=" + port.getConnectionCount());
            } else {
                log.fine(this.dbgId() + "starting connection " + this);
            }
        }
    }

    public QSocket getSocket() {
        return this._socket;
    }

    public QSocket startSocket() {
        this._isClosed = false;
        return this._socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForKeepalive() throws IOException {
        Port port = this.getPort();
        QSocket socket = this._socket;
        if (port.isClosed()) {
            return false;
        }
        ReadStream is = this.getReadStream();
        if (this.getReadStream().getBufferAvailable() > 0) {
            return true;
        }
        long timeout = port.getKeepaliveTimeout();
        boolean isSelectManager = port.getServer().isSelectManagerEnabled();
        if (isSelectManager) {
            timeout = port.getKeepaliveSelectThreadTimeout();
        }
        if (timeout > 0L && timeout < port.getSocketTimeout()) {
            port.keepaliveThreadBegin();
            try {
                boolean isKeepalive;
                boolean bl = isKeepalive = is.fillWithTimeout(timeout);
                Object var10_8 = null;
                port.keepaliveThreadEnd();
                return bl;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                port.keepaliveThreadEnd();
                throw throwable;
            }
        }
        return !isSelectManager;
    }

    public boolean isSecure() {
        if (this._isClosed) {
            return false;
        }
        return this._socket.isSecure() || this._isSecure;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setKeepalive() {
        if (this._isKeepalive) {
            log.warning("illegal state: setting keepalive with active keepalive: " + this);
        }
        this._isKeepalive = true;
    }

    public void clearKeepalive() {
        if (!this._isKeepalive) {
            log.warning("illegal state: clearing keepalive with inactive keepalive: " + this);
        }
        this._isKeepalive = false;
    }

    public InetAddress getLocalAddress() {
        try {
            return this._socket.getLocalAddress();
        }
        catch (Exception e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception e1) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this._socket.getRemoteHost();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        return this._socket.getRemoteAddress(buffer, offset, length);
    }

    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    public String getVirtualHost() {
        return this.getPort().getVirtualHost();
    }

    public final String getState() {
        return this._state;
    }

    public final void setState(String state) {
        this._state = state;
    }

    public final void beginActive() {
        this._state = "active";
        this._requestStartTime = Alarm.getCurrentTime();
    }

    public final void endActive() {
        this._state = "idle";
        this._requestStartTime = 0L;
    }

    public final long getThreadId() {
        Thread thread = this._thread;
        if (thread != null) {
            return thread.getId();
        }
        return -1L;
    }

    public final long getRequestActiveTime() {
        if (this._requestStartTime > 0L) {
            return Alarm.getCurrentTime() - this._requestStartTime;
        }
        return -1L;
    }

    public boolean allowKeepalive() {
        return this.getPort().allowKeepalive(this._connectionStartTime);
    }

    private void keepalive() {
        Port port = this.getPort();
        ConnectionController controller = this.getController();
        if (controller != null) {
            this._suspendTime = Alarm.getCurrentTime();
            boolean isSuspended = false;
            if (controller.isDuplex()) {
                isSuspended = port.registerDuplex(this);
                this._isResume = true;
            } else if (port.suspend(this)) {
                isSuspended = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "suspend");
                }
            }
            if (!isSuspended) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "suspend fail");
                }
                this.free();
            }
        } else if (!port.keepaliveBegin(this, this._connectionStartTime)) {
            this.free();
        } else if (port.getSelectManager() != null) {
            if (port.getSelectManager().keepalive(this)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "keepalive (select)");
                }
            } else {
                log.warning(this.dbgId() + "failed keepalive (select)");
                port.keepaliveEnd(this);
                this.free();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + "keepalive (thread)");
            }
            this.setKeepalive();
            ThreadPool.getThreadPool().schedule((Runnable)((Object)this));
        }
    }

    public boolean waitForSelect() {
        Port port = this.getPort();
        if (!port.keepaliveBegin(this, this._connectionStartTime)) {
            this.free();
            return false;
        }
        if (port.getSelectManager() != null) {
            if (port.getSelectManager().keepalive(this)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "keepalive (select)");
                }
                return true;
            }
            log.warning(this.dbgId() + "failed keepalive (select)");
            port.keepaliveEnd(this);
            this.free();
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "keepalive (thread)");
        }
        return false;
    }

    void setResume() {
        this._isResume = true;
        this._isWake = false;
        this._suspendTime = 0L;
    }

    void setWake() {
        this._isWake = true;
    }

    boolean isWake() {
        return this._isWake;
    }

    boolean isComet() {
        ConnectionController controller = this.getController();
        return controller != null && !controller.isClosed();
    }

    protected boolean wake() {
        ConnectionController controller = this.getController();
        if (controller == null) {
            return false;
        }
        this._isWake = true;
        if (controller.isDuplex()) {
            if (this.getPort().resumeWrite(this, controller)) {
                log.fine(this.dbgId() + "wake");
                return true;
            }
        } else if (this.getPort().resume(this)) {
            log.fine(this.dbgId() + "wake");
            return true;
        }
        log.fine(this.dbgId() + "wake for non-suspended comet");
        return true;
    }

    public boolean suspendWrite() {
        return this.getPort().suspendWrite(this);
    }

    public void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        port = this.getPort();
        isKeepalive = this._isKeepalive;
        this._isKeepalive = false;
        isResume = this._isResume;
        this._isResume = false;
        this._isWake = false;
        isFirst = isKeepalive == false;
        request = this.getRequest();
        isWaitForRead = request.isWaitForRead();
        thread = Thread.currentThread();
        oldThreadName = thread.getName();
        thread.setName(this._id + "$" + System.identityHashCode(thread));
        if (isKeepalive) {
            port.keepaliveEnd(this);
        }
        port.threadBegin(this);
        systemLoader = ClassLoader.getSystemClassLoader();
        startTime = Alarm.getExactTime();
        thread.setContextClassLoader(systemLoader);
        try {
            try {
                this._thread = thread;
                if (isResume) {
                    if (TcpConnection.log.isLoggable(Level.FINE)) {
                        TcpConnection.log.fine(this.dbgId() + "resume");
                    }
                    if ((controller = this.getController()) != null && controller.isDuplex()) {
                        duplex = (TcpConnectionController)controller;
                        this._isResume = true;
                        readTask = duplex.getReadTask();
                        if (readTask != null) {
                            isKeepalive = true;
                            readTask.run();
                        }
                    } else if (request.handleResume()) {
                        isKeepalive = true;
                    } else {
                        if (controller != null) {
                            controller.close();
                        }
                        isKeepalive = false;
                        this.closeImpl();
                    }
                    var19_19 = null;
                    thread.setContextClassLoader(systemLoader);
                    port.threadEnd(this);
                    if (isKeepalive) {
                        this.keepalive();
                    } else {
                        this.free();
                    }
                    this._thread = null;
                    thread.setName(oldThreadName);
                    return;
                }
                while (!this._isDead) {
                    block46: {
                        if (!isKeepalive) {
                            if (port.accept(this, isFirst)) {
                                this._connectionStartTime = Alarm.getCurrentTime();
                            } else {
                                var19_20 = null;
                                thread.setContextClassLoader(systemLoader);
                                port.threadEnd(this);
                                if (isKeepalive) {
                                    this.keepalive();
                                } else {
                                    this.free();
                                }
                                this._thread = null;
                                thread.setName(oldThreadName);
                                return;
                            }
                        }
                        isFirst = false;
                        controller = null;
                        try {
                            thread.interrupted();
                            while (true) {
                                thread.setContextClassLoader(systemLoader);
                                controller = null;
                                isKeepalive = false;
                                if (port.isClosed() || isWaitForRead && !this.getReadStream().waitForRead()) continue;
                                duplex = this._requestLock;
                                synchronized (duplex) {
                                    isKeepalive = request.handleRequest();
                                }
                                controller = this.getController();
                                if (controller == null || !controller.isActive()) continue;
                                isKeepalive = true;
                                var17_26 = null;
                                thread.setContextClassLoader(systemLoader);
                                if (!isKeepalive) {
                                    this.closeImpl();
                                }
                                break;
                            }
                        }
                        catch (ClientDisconnectException e) {
                            isKeepalive = false;
                            if (controller != null) {
                                controller.close();
                            }
                            if (TcpConnection.log.isLoggable(Level.FINER)) {
                                TcpConnection.log.finer(this.dbgId() + (Object)e);
                            }
                            var17_26 = null;
                            thread.setContextClassLoader(systemLoader);
                            if (isKeepalive) continue;
                            this.closeImpl();
                            continue;
                        }
                        catch (IOException e) {
                            isKeepalive = false;
                            if (controller != null) {
                                controller.close();
                            }
                            if (TcpConnection.log.isLoggable(Level.FINE)) {
                                TcpConnection.log.log(Level.FINE, this.dbgId() + e, e);
                            }
                            var17_26 = null;
                            thread.setContextClassLoader(systemLoader);
                            if (isKeepalive) continue;
                            this.closeImpl();
                            continue;
                        }
                        catch (Throwable var16_27) {
                            var17_26 = null;
                            thread.setContextClassLoader(systemLoader);
                            if (isKeepalive != false) throw var16_27;
                            this.closeImpl();
                            throw var16_27;
                        }
                        var19_21 = null;
                        thread.setContextClassLoader(systemLoader);
                        port.threadEnd(this);
                        if (isKeepalive) {
                            this.keepalive();
                        } else {
                            this.free();
                        }
                        this._thread = null;
                        thread.setName(oldThreadName);
                        return;
                        {
                            if (isKeepalive && this.waitForKeepalive() && !port.isClosed()) ** continue;
                            if (!isKeepalive) ** GOTO lbl-1000
                            var17_26 = null;
                            thread.setContextClassLoader(systemLoader);
                            if (isKeepalive) break block46;
                            this.closeImpl();
                        }
                    }
                    var19_22 = null;
                    thread.setContextClassLoader(systemLoader);
                    port.threadEnd(this);
                    if (isKeepalive) {
                        this.keepalive();
                    } else {
                        this.free();
                    }
                    this._thread = null;
                    thread.setName(oldThreadName);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        this.getRequest().protocolCloseEvent();
                    }
                    var17_26 = null;
                    thread.setContextClassLoader(systemLoader);
                    if (isKeepalive) continue;
                    this.closeImpl();
                }
                var19_23 = null;
                thread.setContextClassLoader(systemLoader);
                port.threadEnd(this);
                if (isKeepalive) {
                    this.keepalive();
                } else {
                    this.free();
                }
                this._thread = null;
                thread.setName(oldThreadName);
                return;
            }
            catch (Throwable e) {
                TcpConnection.log.log(Level.WARNING, e.toString(), e);
                isKeepalive = false;
                var19_24 = null;
                thread.setContextClassLoader(systemLoader);
                port.threadEnd(this);
                if (isKeepalive) {
                    this.keepalive();
                } else {
                    this.free();
                }
                this._thread = null;
                thread.setName(oldThreadName);
                return;
            }
        }
        catch (Throwable var18_28) {
            var19_25 = null;
            thread.setContextClassLoader(systemLoader);
            port.threadEnd(this);
            if (isKeepalive) {
                this.keepalive();
            } else {
                this.free();
            }
            this._thread = null;
            thread.setName(oldThreadName);
            throw var18_28;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBroadcast(BroadcastTask task) {
        Object object = this._requestLock;
        synchronized (object) {
            task.execute(this);
        }
    }

    public void closeOnShutdown() {
        QSocket socket = this._socket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() {
        boolean isClosed;
        QSocket socket = this._socket;
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            isClosed = this._isClosed;
            this._isClosed = true;
        }
        this.getPort().detach(this);
        ConnectionController controller = this.getController();
        this._controller = null;
        if (controller != null) {
            controller.close();
        }
        if (!isClosed) {
            this._isActive = false;
            boolean isKeepalive = this._isKeepalive;
            this._isKeepalive = false;
            Port port = this.getPort();
            if (isKeepalive) {
                port.keepaliveEnd(this);
            }
            if (log.isLoggable(Level.FINE) && this._isInUse) {
                if (port != null) {
                    log.fine(this.dbgId() + "closing connection " + this + ", total=" + port.getConnectionCount());
                } else {
                    log.fine(this.dbgId() + "closing connection " + this);
                }
            }
            this._isInUse = false;
            this._isWake = false;
            this._isResume = false;
            try {
                this.getWriteStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                this.getReadStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                this.getPort().closeSocket(socket);
            }
        }
    }

    protected void closeControllerImpl() {
        this.getPort().resume(this);
    }

    public final void destroy() {
        this._isDead = true;
        this.closeImpl();
    }

    final void free() {
        this.closeImpl();
        this.setState("free");
        if (!this._isDead) {
            this.getPort().free(this);
        } else {
            this.getPort().kill(this);
        }
    }

    protected String dbgId() {
        if (this._dbgId == null) {
            Object serverId = Environment.getAttribute("caucho.server-id");
            String prefix = "";
            this._dbgId = serverId != null ? "Tcp[" + serverId + "," + this.getId() + "] " : "Tcp[" + this.getId() + "] ";
        }
        return this._dbgId;
    }

    public String toString() {
        if (this._isActive) {
            return "TcpConnection[id=" + this._id + ",socket=" + this._socket + ",active]";
        }
        return "TcpConnection[id=" + this._id + ",socket=" + this._socket + ",port=" + this.getPort() + "]";
    }

    class Admin
    extends AbstractManagedObject
    implements TcpConnectionMXBean {
        Admin() {
            super(ClassLoader.getSystemClassLoader());
        }

        public String getName() {
            return TcpConnection.this._name;
        }

        public long getThreadId() {
            return TcpConnection.this.getThreadId();
        }

        public long getRequestActiveTime() {
            return TcpConnection.this.getRequestActiveTime();
        }

        public String getState() {
            return TcpConnection.this.getState();
        }

        void register() {
            this.registerSelf();
        }

        void unregister() {
            this.unregisterSelf();
        }
    }
}

