/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.JsseSSLFactory;
import java.net.UnknownHostException;
import javax.annotation.PostConstruct;

public class ClusterCompatConfig {
    private static final L10N L = new L10N(ClusterCompatConfig.class);
    private final Resin _resin;
    private String _id = "";
    private Cluster _cluster;

    public ClusterCompatConfig(Resin resin) {
        this._resin = resin;
    }

    public void setId(String id) {
        this._id = id;
    }

    Cluster getCluster() {
        if (this._cluster != null) {
            return this._cluster;
        }
        this._cluster = this._resin.findCluster(this._id);
        if (this._cluster == null) {
            try {
                this._cluster = this._resin.createCluster();
                this._cluster.setId(this._id);
                this._resin.addCluster(this._cluster);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this._cluster;
    }

    public SrunCompatConfig createSrun() {
        return new SrunCompatConfig();
    }

    public class SrunCompatConfig {
        private String _id = "";
        private ClusterServer _server;

        SrunCompatConfig() {
            Cluster cluster = ClusterCompatConfig.this.getCluster();
        }

        public void setId(String id) {
            this._id = id;
        }

        public void setServerId(String id) {
            this.setId(id);
        }

        public void setHost(String host) throws UnknownHostException {
            this.getClusterPort().setAddress(host);
        }

        public void setPort(int port) {
            this.getClusterPort().setPort(port);
        }

        public void setJsseSsl(JsseSSLFactory ssl) {
            this.getClusterPort().setJsseSsl(ssl);
        }

        public void setIndex(int index) {
        }

        public void setBackup(boolean backup) {
        }

        private ClusterPort getClusterPort() {
            return this.getClusterServer().getClusterPort();
        }

        private ClusterServer getClusterServer() {
            if (this._server == null) {
                this._server = ClusterCompatConfig.this._cluster.findServer(this._id);
            }
            if (this._server == null) {
                try {
                    this._server = ClusterCompatConfig.this._cluster.createServer();
                    this._server.setId(this._id);
                    ClusterCompatConfig.this._cluster.addServer(this._server);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return this._server;
        }

        @PostConstruct
        public void init() throws Exception {
        }
    }
}

