/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.Version;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.functions.FmtFunctions;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.license.LicenseCheck;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.EnvironmentProperties;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.RotateStream;
import com.caucho.management.j2ee.J2EEDomain;
import com.caucho.management.j2ee.JVM;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.naming.Jndi;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.TransactionManager;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Server;
import com.caucho.server.resin.ResinAdmin;
import com.caucho.server.resin.ServerCompatConfig;
import com.caucho.server.resin.ThreadPoolAdmin;
import com.caucho.server.resin.ThreadPoolConfig;
import com.caucho.server.webbeans.ResinWebBeansProducer;
import com.caucho.util.Alarm;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.webbeans.manager.WebBeansAddLoaderListener;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.ObjectName;
import javax.webbeans.Standard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resin
implements EnvironmentBean,
SchemaBean {
    private static Logger _log;
    private static L10N _L;
    private static final String OBJECT_NAME = "resin:type=Resin";
    private static final EnvironmentLocal<Resin> _resinLocal;
    private final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private ObjectName _objectName;
    private EnvironmentClassLoader _classLoader;
    private boolean _isGlobal;
    private String _serverId = "";
    private Path _resinHome;
    private Path _rootDirectory;
    private boolean _isGlobalSystemProperties;
    private boolean _isResinProfessional;
    private long _minFreeMemory = 0x200000L;
    private long _shutdownWaitMax = 60000L;
    private SecurityManager _securityManager;
    private HashMap<String, Object> _variableMap = new HashMap();
    private ArrayList<ContainerProgram> _clusterDefaults = new ArrayList();
    private ArrayList<Cluster> _clusters = new ArrayList();
    private Lifecycle _lifecycle;
    private Server _server;
    private long _initialStartTime;
    private long _startTime;
    private J2EEDomain _j2eeDomainManagedObject;
    private JVM _jvmManagedObject;
    private String _configFile;
    private String _configServer;
    private Path _resinConf;
    private ClassLoader _systemClassLoader;
    private Thread _mainThread;
    private ArrayList<BoundPort> _boundPortList = new ArrayList();
    private Path _managementPath;
    private Management _management;
    private ThreadPoolAdmin _threadPoolAdmin;
    private ResinAdmin _resinAdmin;
    private InputStream _waitIn;
    private Socket _pingSocket;

    public Resin() {
        this(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resin(ClassLoader loader) {
        this._startTime = Alarm.getCurrentTime();
        DynamicClassLoader.setJarCacheEnabled(true);
        Environment.init();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        this._isGlobal = loader == ClassLoader.getSystemClassLoader();
        this._classLoader = loader instanceof EnvironmentClassLoader ? (EnvironmentClassLoader)loader : new EnvironmentClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            _resinLocal.set(this, this._classLoader);
            this._lifecycle = new Lifecycle(Resin.log(), "Resin[]");
            String resinHome = System.getProperty("resin.home");
            if (resinHome != null) {
                this.setResinHome(Vfs.lookup(resinHome));
            } else {
                this.setResinHome(Vfs.getPwd());
            }
            this.setRootDirectory(this.getResinHome());
            String serverRoot = System.getProperty("server.root");
            if (serverRoot != null) {
                this.setRootDirectory(Vfs.lookup(serverRoot));
            }
            if ((serverRoot = System.getProperty("resin.root")) != null) {
                this.setRootDirectory(Vfs.lookup(serverRoot));
            }
            this.setServerId("");
            Environment.addChildLoaderListener(new WebBeansAddLoaderListener());
            WebBeansContainer webBeans = WebBeansContainer.create();
            webBeans.addSingleton(this.getResinHome(), "resinHome", Standard.class);
            webBeans.addSingleton(new Var(), "resin", Standard.class);
            webBeans.addSingleton(new Var(), "server", Standard.class);
            webBeans.addSingleton(new JavaVar(), "java", Standard.class);
            webBeans.addSingleton(System.getProperties(), "system", Standard.class);
            webBeans.addSingleton(new FmtFunctions(), "fmt", Standard.class);
            ResinConfigLibrary.configure(webBeans);
            try {
                Method method = Jndi.class.getMethod("lookup", String.class);
                webBeans.addSingleton(method, "jndi", Standard.class);
                webBeans.addSingleton(method, "jndi:lookup", Standard.class);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            webBeans.addSingleton(new ResinWebBeansProducer());
            webBeans.update();
            this._threadPoolAdmin = ThreadPoolAdmin.create();
            this._resinAdmin = new ResinAdmin(this);
            this._threadPoolAdmin.register();
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public static Resin getLocal() {
        return _resinLocal.get();
    }

    public static Resin getCurrent() {
        return Resin.getLocal();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public ResinMXBean getAdmin() {
        return this._resinAdmin;
    }

    public ThreadPoolMXBean getThreadPoolAdmin() {
        return this._threadPoolAdmin;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/resin.rnc";
    }

    public void setServerId(String serverId) {
        WebBeansContainer.create().addSingletonByName(serverId, "serverId");
        this._serverId = serverId;
        this._serverIdLocal.set(serverId);
    }

    public String getServerId() {
        return this._serverId;
    }

    public String getDisplayServerId() {
        if ("".equals(this._serverId)) {
            return "default";
        }
        return this._serverId;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public void setResinHome(Path home) {
        this._resinHome = home;
    }

    public Path getResinHome() {
        return this._resinHome;
    }

    public void setRootDirectory(Path root) {
        this._rootDirectory = root;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getResinConf() {
        return this._resinConf;
    }

    void setResinProfessional(boolean isPro) {
        this._isResinProfessional = isPro;
    }

    public boolean isProfessional() {
        return this._isResinProfessional;
    }

    public ClusterMXBean[] getClusters() {
        ClusterMXBean[] clusters = new ClusterMXBean[this._clusters.size()];
        for (int i = 0; i < this._clusters.size(); ++i) {
            clusters[i] = this._clusters.get(i).getAdmin();
        }
        return clusters;
    }

    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaults.add(program);
    }

    public Cluster createCluster() throws ConfigException {
        Cluster cluster = new Cluster(this);
        for (int i = 0; i < this._clusterDefaults.size(); ++i) {
            this._clusterDefaults.get(i).configure(cluster);
        }
        return cluster;
    }

    public void addCluster(Cluster cluster) {
        this._clusters.add(cluster);
    }

    public ArrayList<Cluster> getClusterList() {
        return this._clusters;
    }

    public void setEnvironmentSystemProperties(boolean isEnable) {
        EnvironmentProperties.enableEnvironmentSystemProperties(isEnable);
    }

    public ServerCompatConfig createServer() {
        return new ServerCompatConfig(this);
    }

    public ThreadPoolConfig createThreadPool() throws Exception {
        return new ThreadPoolConfig();
    }

    public void setUserName(String userName) {
    }

    public void setGroupName(String groupName) {
    }

    public void setMinFreeMemory(Bytes minFreeMemory) {
        this._minFreeMemory = minFreeMemory.getBytes();
    }

    public long getMinFreeMemory() {
        return this._minFreeMemory;
    }

    public void setShutdownWaitMax(Period shutdownWaitMax) {
        this._shutdownWaitMax = shutdownWaitMax.getPeriod();
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setGlobalSystemProperties(boolean isGlobal) {
        this._isGlobalSystemProperties = isGlobal;
    }

    public SecurityManagerConfig createSecurityManager() {
        return new SecurityManagerConfig();
    }

    public void setWatchdogManager(ConfigProgram program) {
    }

    @Deprecated
    public TransactionManager createTransactionManager() throws ConfigException {
        Resin.log().warning(Resin.L().l("<transaction-manager> tag belongs in <management>"));
        return new TransactionManager(this);
    }

    public Management createManagement() {
        if (this._management == null) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.admin.ProManagement");
                this._management = (Management)cl.newInstance();
            }
            catch (Exception e) {
                Resin.log().log(Level.FINEST, e.toString(), e);
            }
            if (this._management == null) {
                this._management = new Management();
            }
            this._management.setResin(this);
        }
        return this._management;
    }

    @Deprecated
    public Path getManagementPath() {
        return this._managementPath;
    }

    public void addSecurityProvider(Class providerClass) throws Exception {
        if (!Provider.class.isAssignableFrom(providerClass)) {
            throw new ConfigException(Resin.L().l("security-provider {0} must implement java.security.Provider", (Object)providerClass.getName()));
        }
        Security.addProvider((Provider)providerClass.newInstance());
    }

    public JspPropertyGroup createJsp() {
        return new JspPropertyGroup();
    }

    public void addBoot(ContainerProgram program) throws Exception {
    }

    void setInitialStartTime(long now) {
        this._initialStartTime = now;
    }

    public Date getInitialStartTime() {
        return new Date(this._initialStartTime);
    }

    public Date getStartTime() {
        return new Date(this._startTime);
    }

    public LifecycleState getLifecycleState() {
        return this._lifecycle;
    }

    @PostConstruct
    public void init() {
        this._lifecycle.toInit();
    }

    public Server getServer() {
        return this._server;
    }

    public Management getManagement() {
        return this._management;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        long start = Alarm.getExactTime();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            this.startManagement();
            System.gc();
            for (Cluster cluster : this._clusters) {
                cluster.start();
            }
            ClusterServer clusterServer = this.findClusterServer(this._serverId);
            if (clusterServer == null) {
                throw new ConfigException(Resin.L().l("server-id '{0}' has no matching <server> definition.", (Object)this._serverId));
            }
            this._server = clusterServer.startServer();
            Environment.start(this.getClassLoader());
            Resin.log().info("Resin started in " + (Alarm.getExactTime() - this._startTime) + "ms");
            Object var8_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
    }

    public Cluster findCluster(String id) {
        for (int i = 0; i < this._clusters.size(); ++i) {
            Cluster cluster = this._clusters.get(i);
            if (!cluster.getId().equals(id)) continue;
            return cluster;
        }
        return null;
    }

    public ClusterServer findClusterServer(String id) {
        for (int i = 0; i < this._clusters.size(); ++i) {
            Cluster cluster = this._clusters.get(i);
            ClusterServer server = cluster.findServer(id);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isClosing() {
        return this._lifecycle.isDestroying();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this._lifecycle.toDestroying()) {
            return;
        }
        try {
            try {
                Resin resin = this;
                synchronized (resin) {
                    this.notifyAll();
                }
                Socket socket = this._pingSocket;
                if (socket != null) {
                    socket.setSoTimeout(1000);
                }
            }
            catch (Throwable e) {
                Resin.log().log(Level.WARNING, e.toString(), e);
            }
            try {
                Management management = this._management;
                this._management = null;
                if (management != null) {
                    management.destroy();
                }
            }
            catch (Throwable e) {
                Resin.log().log(Level.WARNING, e.toString(), e);
            }
            try {
                Server server = this._server;
                this._server = null;
                if (server != null) {
                    server.destroy();
                }
            }
            catch (Throwable e) {
                Resin.log().log(Level.WARNING, e.toString(), e);
            }
            this._threadPoolAdmin.unregister();
            if (this._isGlobal) {
                Environment.closeGlobal();
            } else {
                this._classLoader.destroy();
            }
            Object var4_6 = null;
            this._lifecycle.toDestroy();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this._lifecycle.toDestroy();
            if (this._mainThread != null) {
                System.exit(0);
            }
            throw throwable;
        }
        if (this._mainThread != null) {
            System.exit(0);
        }
    }

    private void parseCommandLine(String[] argv) throws Exception {
        int len = argv.length;
        int i = 0;
        while (i < len) {
            RotateStream stream;
            RandomUtil.addRandom((String)argv[i]);
            if (i + 1 < len && (argv[i].equals("-stdout") || argv[i].equals("--stdout"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStdout((OutputStream)out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-stderr") || argv[i].equals("--stderr"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStderr((OutputStream)out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-conf") || argv[i].equals("--conf"))) {
                this._configFile = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-log-directory") || argv[i].equals("--log-directory")) {
                i += 2;
                continue;
            }
            if (argv[i].equals("-config-server") || argv[i].equals("--config-server")) {
                this._configServer = argv[i + 1];
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-server") || argv[i].equals("--server"))) {
                this.setServerId(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-resin-home") || argv[i].equals("--resin-home")) {
                this._resinHome = Vfs.lookup(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-root-directory") || argv[i].equals("--root-directory")) {
                this._rootDirectory = this._resinHome.lookup(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-server-root") || argv[i].equals("--server-root")) {
                this._rootDirectory = this._resinHome.lookup(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-service")) {
                ++i;
                continue;
            }
            if (argv[i].equals("-version") || argv[i].equals("--version")) {
                System.out.println(Version.FULL_VERSION);
                System.exit(66);
                continue;
            }
            if (argv[i].equals("-watchdog-port") || argv[i].equals("--watchdog-port")) {
                i += 2;
                continue;
            }
            if (argv[i].equals("-socketwait") || argv[i].equals("--socketwait") || argv[i].equals("-pingwait") || argv[i].equals("--pingwait")) {
                int socketport = Integer.parseInt(argv[i + 1]);
                Socket socket = null;
                for (int k = 0; k < 15 && socket == null; ++k) {
                    try {
                        socket = new Socket("127.0.0.1", socketport);
                    }
                    catch (Throwable e) {
                        System.out.println(new Date());
                        e.printStackTrace();
                    }
                    if (socket != null) continue;
                    Thread.sleep(1000L);
                }
                if (socket == null) {
                    System.err.println("Can't connect to parent process through socket " + socketport);
                    System.err.println("Resin needs to connect to its parent.");
                    System.exit(0);
                }
                if (argv[i].equals("-socketwait") || argv[i].equals("--socketwait")) {
                    this._waitIn = socket.getInputStream();
                } else {
                    this._pingSocket = socket;
                }
                socket.setSoTimeout(60000);
                i += 2;
                continue;
            }
            if ("-port".equals(argv[i]) || "--port".equals(argv[i])) {
                int fd = Integer.parseInt(argv[i + 1]);
                String addr = argv[i + 2];
                if ("null".equals(addr)) {
                    addr = null;
                }
                int port = Integer.parseInt(argv[i + 3]);
                this._boundPortList.add(new BoundPort(QJniServerSocket.openJNI(fd, port), addr, port));
                i += 4;
                continue;
            }
            if ("start".equals(argv[i]) || "restart".equals(argv[i])) {
                ++i;
                continue;
            }
            if (argv[i].equals("-verbose") || argv[i].equals("--verbose")) {
                ++i;
                continue;
            }
            if (argv[i].equals("-fine") || argv[i].equals("--fine")) {
                ++i;
                continue;
            }
            if (argv[i].equals("-finer") || argv[i].equals("--finer")) {
                ++i;
                continue;
            }
            if (argv[i].startsWith("-D") || argv[i].startsWith("-J") || argv[i].startsWith("-X")) {
                ++i;
                continue;
            }
            System.out.println(Resin.L().l("unknown argument '{0}'", (Object)argv[i]));
            System.out.println();
            Resin.usage();
            System.exit(66);
        }
    }

    private static void usage() {
        System.err.println(Resin.L().l("usage: java -jar resin.jar [-options] [start | stop | restart]"));
        System.err.println(Resin.L().l(""));
        System.err.println(Resin.L().l("where options include:"));
        System.err.println(Resin.L().l("   -conf <file>          : select a configuration file"));
        System.err.println(Resin.L().l("   -log-directory <dir>  : select a logging directory"));
        System.err.println(Resin.L().l("   -resin-home <dir>     : select a resin home directory"));
        System.err.println(Resin.L().l("   -root-directory <dir> : select a root directory"));
        System.err.println(Resin.L().l("   -server <id>          : select a <server> to run"));
        System.err.println(Resin.L().l("   -watchdog-port <port> : override the watchdog-port"));
        System.err.println(Resin.L().l("   -verbose              : print verbose starting information"));
    }

    public void initMain() throws Throwable {
        this._mainThread = Thread.currentThread();
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        this.addRandom();
        System.out.println(Version.FULL_VERSION);
        System.out.println("Copyright(c) 1998-2008 Caucho Technology.  All rights reserved.");
        System.out.println();
        boolean isResinProfessional = false;
        try {
            Class<?> cl = Class.forName("com.caucho.license.LicenseCheckImpl", false, ClassLoader.getSystemClassLoader());
            LicenseCheck license = (LicenseCheck)cl.newInstance();
            try {
                license.validate(0);
                license.doLogging(1);
                license.validate(1);
                isResinProfessional = true;
                System.setProperty("isResinProfessional", "true");
                Vfs.initJNI();
            }
            catch (Throwable e) {
                String msg;
                if (e instanceof ConfigException) {
                    msg = e.getMessage() + "\n";
                } else {
                    e.printStackTrace();
                    msg = e.toString() + "\n";
                    Resin.log().log(Level.WARNING, e.toString(), e);
                }
                Resin.log().log(Level.FINE, e.toString(), e);
                msg = msg + Resin.L().l("\nUsing Resin Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional.\n");
                Resin.log().warning(msg);
                System.err.println(msg);
            }
        }
        catch (Throwable e) {
            Resin.log().log(Level.FINER, e.toString(), e);
            String msg = Resin.L().l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n");
            Resin.log().warning(msg);
            System.err.println(msg);
        }
        System.out.println("Starting Resin on " + QDate.formatLocal((long)Alarm.getCurrentTime()));
        System.out.println();
        EnvironmentClassLoader.initializeEnvironment();
        if (this._classLoader != null) {
            this._mainThread.setContextClassLoader(this._classLoader);
        }
        Path pwd = Vfs.getPwd();
        if (this._rootDirectory == null) {
            this._rootDirectory = this._resinHome;
        }
        Vfs.setPwd(this._rootDirectory);
        Path resinConf = null;
        if (this._configFile != null) {
            if (Resin.log().isLoggable(Level.FINER)) {
                Resin.log().log(Level.FINER, "looking for conf in " + pwd.lookup(this._configFile));
            }
            resinConf = pwd.lookup(this._configFile);
        }
        if (this._configFile == null) {
            this._configFile = "conf/resin.conf";
        }
        if (resinConf == null || !resinConf.exists()) {
            if (Resin.log().isLoggable(Level.FINER)) {
                Resin.log().log(Level.FINER, "looking for conf in " + this._rootDirectory.lookup(this._configFile));
            }
            resinConf = this._rootDirectory.lookup(this._configFile);
        }
        if (!resinConf.exists() && !this._resinHome.equals((Object)this._rootDirectory)) {
            if (Resin.log().isLoggable(Level.FINER)) {
                Resin.log().log(Level.FINER, "looking for conf in " + this._resinHome.lookup(this._configFile));
            }
            resinConf = this._resinHome.lookup(this._configFile);
        }
        if (!resinConf.exists()) {
            resinConf = this._rootDirectory.lookup(this._configFile);
        }
        this._resinConf = resinConf;
        this.setResinProfessional(isResinProfessional);
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        Config config = new Config();
        config.configure((Object)this, resinConf, this.getSchema());
        ClusterServer clusterServer = this.findClusterServer(this._serverId);
        for (int i = 0; i < this._boundPortList.size(); ++i) {
            BoundPort port = this._boundPortList.get(i);
            clusterServer.bind(port.getAddress(), port.getPort(), port.getServerSocket());
        }
        this.start();
    }

    private void startManagement() {
    }

    private void addRandom() {
        RandomUtil.addRandom((long)System.currentTimeMillis());
        RandomUtil.addRandom((long)Runtime.getRuntime().freeMemory());
        RandomUtil.addRandom((long)System.identityHashCode(this._mainThread));
        RandomUtil.addRandom((long)System.identityHashCode(this._systemClassLoader));
        RandomUtil.addRandom((String)Version.FULL_VERSION);
        try {
            RandomUtil.addRandom((String)InetAddress.getLocalHost().toString());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            FileInputStream is = new FileInputStream("/dev/urandom");
            for (int i = 0; i < 16; ++i) {
                RandomUtil.addRandom((long)((InputStream)is).read());
            }
            ((InputStream)is).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RandomUtil.addRandom((long)System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        int socketExceptionCount = 0;
        Runtime runtime = Runtime.getRuntime();
        while (!this.isClosing()) {
            try {
                long systemTime;
                Thread.sleep(10L);
                long minFreeMemory = this.getMinFreeMemory();
                if (minFreeMemory > 0L && 2L * minFreeMemory >= Resin.getFreeMemory(runtime)) {
                    if (Resin.log().isLoggable(Level.FINER)) {
                        Resin.log().finer(Resin.L().l("free memory {0} max:{1} total:{2} free:{3}", (Object)("" + Resin.getFreeMemory(runtime)), (Object)("" + runtime.maxMemory()), (Object)("" + runtime.totalMemory()), (Object)("" + runtime.freeMemory())));
                    }
                    Resin.log().info(Resin.L().l("Forcing GC due to low memory. {0} free bytes.", Resin.getFreeMemory(runtime)));
                    runtime.gc();
                    Thread.sleep(1000L);
                    runtime.gc();
                    if (Resin.getFreeMemory(runtime) < minFreeMemory) {
                        Resin.log().severe(Resin.L().l("Restarting due to low free memory. {0} free bytes", Resin.getFreeMemory(runtime)));
                        return;
                    }
                }
                Integer memoryTest = new Integer(0);
                long alarmTime = Alarm.getCurrentTime();
                long diff = alarmTime - (systemTime = System.currentTimeMillis());
                if (diff < 0L) {
                    diff = -diff;
                }
                if (600000L < diff) {
                    Resin.log().severe(Resin.L().l("Restarting due to frozen Resin timer manager thread (Alarm).  This error generally indicates a JVM freeze, not an application deadlock."));
                    return;
                }
                if (this._waitIn != null) {
                    int len = this._waitIn.read();
                    if (len >= 0) {
                        socketExceptionCount = 0;
                    } else {
                        Resin.log().warning(Resin.L().l("Stopping due to watchdog or user."));
                    }
                    return;
                }
                Resin resin = this;
                synchronized (resin) {
                    this.wait(10000L);
                }
            }
            catch (SocketTimeoutException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedIOException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedException e) {
                socketExceptionCount = 0;
            }
            catch (SocketException e) {
                if (socketExceptionCount++ == 0) {
                    Resin.log().log(Level.FINE, e.toString(), e);
                    continue;
                }
                if (socketExceptionCount <= 100) continue;
                return;
            }
            catch (OutOfMemoryError e) {
                Object var15_17;
                try {
                    try {
                        EnvironmentStream.getOriginalSystemErr().println("Resin halting due to out of memory");
                    }
                    catch (Exception e1) {
                        var15_17 = null;
                        Runtime.getRuntime().halt(1);
                        continue;
                    }
                    var15_17 = null;
                    Runtime.getRuntime().halt(1);
                }
                catch (Throwable throwable) {
                    var15_17 = null;
                    Runtime.getRuntime().halt(1);
                    throw throwable;
                }
            }
            catch (Throwable e) {
                Resin.log().log(Level.WARNING, e.toString(), e);
                return;
            }
        }
    }

    public String toString() {
        return "Resin[" + this._serverId + "]";
    }

    private static long getFreeMemory(Runtime runtime) {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        if (maxMemory < totalMemory) {
            return freeMemory;
        }
        return maxMemory - totalMemory + freeMemory;
    }

    public static void shutdown() {
        Resin resin = Resin.getLocal();
        if (resin != null) {
            resin.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) {
        try {
            try {
                EnvironmentClassLoader.initializeEnvironment();
                Resin.validateEnvironment();
                Resin resin = new Resin();
                resin.parseCommandLine(argv);
                resin.initMain();
                Server server = resin.getServer();
                DestroyThread destroyThread = new DestroyThread(resin);
                destroyThread.start();
                resin.waitForExit();
                destroyThread.shutdown();
                long stopTime = System.currentTimeMillis();
                long endTime = stopTime + 15000L;
                if (server != null) {
                    endTime = stopTime + server.getShutdownWaitMax();
                }
                while (System.currentTimeMillis() < endTime && !resin.isClosed()) {
                    try {
                        Thread.interrupted();
                        Thread.sleep(100L);
                    }
                    catch (Throwable e) {}
                }
                if (!resin.isClosed()) {
                    Runtime.getRuntime().halt(1);
                }
                System.exit(0);
            }
            catch (Throwable e) {
                Throwable cause;
                boolean isCompile = false;
                for (cause = e; cause != null && cause.getCause() != null; cause = cause.getCause()) {
                    if (!(cause instanceof CompileException)) continue;
                    isCompile = true;
                    break;
                }
                if (cause instanceof BindException) {
                    System.err.println(e.getMessage());
                    Resin.log().severe(e.toString());
                    Resin.log().log(Level.FINE, e.toString(), e);
                    System.exit(67);
                } else if (e instanceof CompileException) {
                    System.err.println(e.getMessage());
                    Resin.log().log(Level.CONFIG, e.toString(), e);
                } else {
                    e.printStackTrace(System.err);
                }
                Object var10_11 = null;
                System.exit(1);
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            System.exit(1);
            throw throwable;
        }
        System.exit(1);
    }

    private static void validateEnvironment() throws ConfigException {
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null || !loggingManager.equals("com.caucho.log.LogManagerImpl")) {
            Resin.log().warning(Resin.L().l("The following system property must be set:\n  -Djava.util.logging.manager=com.caucho.log.LogManagerImpl\nThe JDK 1.4 Logging manager must be set to Resin's log manager."));
        }
    }

    private static void validatePackage(String className, String[] versions) throws ConfigException {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (Throwable e) {
            throw new ConfigException(Resin.L().l("class {0} is not loadable on startup.  Resin requires {0} to be in the classpath on startup.", (Object)className), e);
        }
        Package pkg = cl.getPackage();
        if (pkg == null) {
            Resin.log().warning(Resin.L().l("package for class {0} is missing.  Resin requires class {0} in the classpath on startup.", (Object)className));
            return;
        }
        if (pkg.getSpecificationVersion() == null) {
            Resin.log().warning(Resin.L().l("{0} has no specification version.  Resin {1} requires version {2}.", (Object)pkg, (Object)Version.VERSION, (Object)versions[0]));
            return;
        }
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i].compareTo(pkg.getSpecificationVersion()) > 0) continue;
            return;
        }
        Resin.log().warning(Resin.L().l("Specification version {0} of {1} is not compatible with Resin {2}.  Resin {2} requires version {3}.", (Object)pkg.getSpecificationVersion(), (Object)pkg, (Object)Version.VERSION, (Object)versions[0]));
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(Resin.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(Resin.class.getName());
        }
        return _log;
    }

    static {
        _resinLocal = new EnvironmentLocal();
    }

    static class DestroyThread
    extends Thread {
        private final Resin _resin;
        private boolean _isDestroy;

        DestroyThread(Resin resin) {
            this._resin = resin;
            this.setName("resin-destroy");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            DestroyThread destroyThread = this;
            synchronized (destroyThread) {
                this._isDestroy = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DestroyThread destroyThread = this;
            synchronized (destroyThread) {
                while (!this._isDestroy) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            EnvironmentStream.logStderr("closing server");
            this._resin.destroy();
        }
    }

    class SecurityManagerConfig {
        private boolean _isEnable = true;

        SecurityManagerConfig() {
            if (Resin.this._securityManager == null) {
                Resin.this._securityManager = new SecurityManager();
            }
        }

        public void setEnable(boolean enable) {
            this._isEnable = enable;
        }

        public void setValue(boolean enable) {
            this.setEnable(enable);
        }

        public void setPolicyFile(Path path) throws ConfigException {
            if (!path.canRead()) {
                throw new ConfigException(Resin.L().l("policy-file '{0}' must be readable.", (Object)path));
            }
        }

        @PostConstruct
        public void init() {
            if (this._isEnable) {
                System.setSecurityManager(Resin.this._securityManager);
            }
        }
    }

    public class JavaVar {
        public boolean isJava5() {
            return true;
        }

        public Properties getProperties() {
            return System.getProperties();
        }

        public String getVersion() {
            return System.getProperty("java.version");
        }
    }

    public class Var {
        public String getId() {
            return Resin.this._serverId;
        }

        public String getAddress() {
            try {
                if (Alarm.isTest()) {
                    return "127.0.0.1";
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Resin.log().log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public Path getConf() {
            if (Alarm.isTest()) {
                return Vfs.lookup("file:/home/resin/conf/resin.conf");
            }
            return Resin.this.getResinConf();
        }

        public Path getHome() {
            if (Alarm.isTest()) {
                return Vfs.lookup("file:/home/resin");
            }
            return Resin.this.getResinHome();
        }

        public Path getRoot() {
            if (Alarm.isTest()) {
                return Vfs.lookup("file:/var/www");
            }
            return Resin.this.getRootDirectory();
        }

        public String getVersion() {
            if (Alarm.isTest()) {
                return "3.1.test";
            }
            return Version.VERSION;
        }

        public String getVersionDate() {
            if (Alarm.isTest()) {
                return "19980508T0251";
            }
            return Version.VERSION_DATE;
        }

        public String getHostName() {
            try {
                if (Alarm.isTest()) {
                    return "localhost";
                }
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                Resin.log().log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public boolean isProfessional() {
            return Resin.this._isResinProfessional;
        }

        public String getServerId() {
            return Resin.this._serverId;
        }
    }

    static class BoundPort {
        private QServerSocket _ss;
        private String _address;
        private int _port;

        BoundPort(QServerSocket ss, String address, int port) {
            if (ss == null) {
                throw new NullPointerException();
            }
            this._ss = ss;
            this._address = address;
            this._port = port;
        }

        public QServerSocket getServerSocket() {
            return this._ss;
        }

        public int getPort() {
            return this._port;
        }

        public String getAddress() {
            return this._address;
        }
    }
}

