/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.Version;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.server.cluster.Server;
import com.caucho.server.resin.Resin;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;

public class ResinAdmin
extends AbstractManagedObject
implements ResinMXBean {
    private static final L10N L = new L10N(ResinAdmin.class);
    private static final String THREAD_POOL_OBJECT_NAME = "resin:type=ThreadPool";
    private final Resin _resin;

    public ResinAdmin(Resin resin) {
        this._resin = resin;
        this.registerSelf();
    }

    public String getName() {
        return null;
    }

    public ClusterMXBean[] getClusters() {
        return this._resin.getClusters();
    }

    public String getConfigFile() {
        return this._resin.getResinConf().getNativePath();
    }

    public String getResinHome() {
        return this._resin.getResinHome().getNativePath();
    }

    public String getRootDirectory() {
        return this._resin.getRootDirectory().getNativePath();
    }

    public ServerMXBean getServer() {
        Server server = this._resin.getServer();
        if (server != null) {
            return server.getAdmin();
        }
        return null;
    }

    public String getVersion() {
        return Version.FULL_VERSION;
    }

    public boolean isProfessional() {
        return this._resin.isProfessional();
    }

    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    public String toString() {
        return "ResinAdmin[" + this.getObjectName() + "]";
    }
}

