/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.Server;
import com.caucho.server.host.HostController;
import com.caucho.server.port.AbstractSelectManager;
import com.caucho.server.port.Port;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Date;

public class ServerAdmin {
    private static final L10N L = new L10N(ServerAdmin.class);
    private final Server _server;

    ServerAdmin(Server server) {
        this._server = server;
    }

    public String getName() {
        return null;
    }

    public String getRootDirectory() {
        Path path = this._server.getRootDirectory();
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    public boolean isSelectManagerEnabled() {
        AbstractSelectManager manager = this._server.getSelectManager();
        return manager != null;
    }

    public String getId() {
        return this._server.getServerId();
    }

    public ThreadPoolMXBean getThreadPool() {
        throw new UnsupportedOperationException();
    }

    public PortMXBean[] getPorts() {
        Server server = this._server;
        if (server == null) {
            return new PortMXBean[0];
        }
        ArrayList<PortMXBean> portList = new ArrayList<PortMXBean>();
        for (Port port : server.getPorts()) {
            PortMXBean admin = port.getAdmin();
            if (admin == null) continue;
            portList.add(admin);
        }
        return portList.toArray(new PortMXBean[portList.size()]);
    }

    public PortMXBean getClusterPort() {
        return null;
    }

    public ClusterMXBean getCluster() {
        if (this._server == null) {
            return null;
        }
        Cluster cluster = this._server.getCluster();
        if (cluster != null) {
            return cluster.getAdmin();
        }
        return null;
    }

    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    public boolean isDetailedStatistics() {
        return CauchoSystem.isDetailedStatistics();
    }

    public HostMXBean[] getHosts() {
        if (this._server == null) {
            return new HostMXBean[0];
        }
        ArrayList<HostMXBean> hostList = new ArrayList<HostMXBean>();
        for (HostController host : this._server.getHostControllers()) {
            HostMXBean admin = host.getAdmin();
            if (admin == null) continue;
            hostList.add(admin);
        }
        return hostList.toArray(new HostMXBean[hostList.size()]);
    }

    public String getState() {
        throw new UnsupportedOperationException();
    }

    public Date getInitialStartTime() {
        throw new UnsupportedOperationException();
    }

    public Date getStartTime() {
        throw new UnsupportedOperationException();
    }

    public int getThreadActiveCount() {
        Server server = this._server;
        if (server == null) {
            return -1;
        }
        int activeThreadCount = -1;
        for (Port port : server.getPorts()) {
            if (port.getActiveThreadCount() < 0) continue;
            if (activeThreadCount == -1) {
                activeThreadCount = 0;
            }
            activeThreadCount += port.getActiveThreadCount();
        }
        return activeThreadCount;
    }

    public int getThreadKeepaliveCount() {
        Server server = this._server;
        if (server == null) {
            return -1;
        }
        int keepaliveThreadCount = -1;
        for (Port port : server.getPorts()) {
            if (port.getKeepaliveConnectionCount() < 0) continue;
            if (keepaliveThreadCount == -1) {
                keepaliveThreadCount = 0;
            }
            keepaliveThreadCount += port.getKeepaliveConnectionCount();
        }
        return keepaliveThreadCount;
    }

    public int getSelectKeepaliveCount() {
        Server server = this._server;
        if (server == null) {
            return -1;
        }
        int keepaliveSelectCount = -1;
        for (Port port : server.getPorts()) {
            if (port.getSelectConnectionCount() < 0) continue;
            if (keepaliveSelectCount == -1) {
                keepaliveSelectCount = 0;
            }
            keepaliveSelectCount += port.getSelectConnectionCount();
        }
        return keepaliveSelectCount;
    }

    public long getRequestCountTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeRequestCount = 0L;
        for (Port port : server.getPorts()) {
            lifetimeRequestCount += port.getLifetimeRequestCount();
        }
        return lifetimeRequestCount;
    }

    public long getRequestTimeTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeRequestTime = 0L;
        for (Port port : server.getPorts()) {
            lifetimeRequestTime += port.getLifetimeRequestTime();
        }
        return lifetimeRequestTime;
    }

    public long getRequestReadBytesTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeReadBytes = 0L;
        for (Port port : server.getPorts()) {
            lifetimeReadBytes += port.getLifetimeReadBytes();
        }
        return lifetimeReadBytes;
    }

    public long getRequestWriteBytesTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeWriteBytes = 0L;
        for (Port port : server.getPorts()) {
            lifetimeWriteBytes += port.getLifetimeWriteBytes();
        }
        return lifetimeWriteBytes;
    }

    public long getClientDisconnectCountTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeClientDisconnectCount = 0L;
        for (Port port : server.getPorts()) {
            lifetimeClientDisconnectCount += port.getLifetimeClientDisconnectCount();
        }
        return lifetimeClientDisconnectCount;
    }

    public long getKeepaliveCountTotal() {
        Server server = this._server;
        if (server == null) {
            return -1L;
        }
        long lifetimeKeepaliveCount = 0L;
        for (Port port : server.getPorts()) {
            lifetimeKeepaliveCount += port.getLifetimeKeepaliveCount();
        }
        return lifetimeKeepaliveCount;
    }

    public long getRuntimeMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getRuntimeMemoryFree() {
        return Runtime.getRuntime().freeMemory();
    }

    public void restart() {
        this._server.restart();
    }

    public void clearCache() {
        Server server = this._server;
        if (server != null) {
            server.clearCache();
        }
    }

    public void clearCacheByPattern(String hostRegexp, String urlRegexp) {
        Server server = this._server;
        if (server != null) {
            server.clearCacheByPattern(hostRegexp, urlRegexp);
        }
    }

    public long getInvocationCacheHitCountTotal() {
        Server server = this._server;
        if (server != null) {
            return server.getInvocationCacheHitCount();
        }
        return -1L;
    }

    public long getInvocationCacheMissCountTotal() {
        Server server = this._server;
        if (server != null) {
            return server.getInvocationCacheMissCount();
        }
        return -1L;
    }

    public long getProxyCacheHitCount() {
        Server server = this._server;
        if (server != null) {
            return server.getProxyCacheHitCount();
        }
        return -1L;
    }

    public long getProxyCacheMissCount() {
        Server server = this._server;
        if (server != null) {
            return server.getProxyCacheMissCount();
        }
        return -1L;
    }
}

