/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.port.Port;
import com.caucho.server.resin.ClusterCompatConfig;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ServerCompatConfig
implements SchemaBean {
    private static final L10N L = new L10N(ServerCompatConfig.class);
    private static final Logger log = Logger.getLogger(ServerCompatConfig.class.getName());
    private final Resin _resin;
    private ArrayList<HttpCompatConfig> _httpList = new ArrayList();
    private ContainerProgram _program = new ContainerProgram();

    public ServerCompatConfig(Resin resin) {
        if (resin == null) {
            throw new NullPointerException();
        }
        this._resin = resin;
    }

    public String getSchema() {
        return "com/caucho/server/resin/server.rnc";
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public HttpCompatConfig createHttp() {
        HttpCompatConfig http = new HttpCompatConfig();
        return http;
    }

    public ClusterCompatConfig createCluster() {
        return new ClusterCompatConfig(this._resin);
    }

    @PostConstruct
    public void init() {
        try {
            String serverId = this._resin.getServerId();
            ClusterServer clusterServer = this._resin.findClusterServer(serverId);
            if (clusterServer == null) {
                if (this._resin.getClusterList().size() > 0 || !"".equals(serverId)) {
                    log.warning(L.l("-server '{0}' does not match any defined servers", (Object)serverId));
                }
                Cluster cluster = this._resin.createCluster();
                this._resin.addCluster(cluster);
                clusterServer = cluster.createServer();
                clusterServer.setPort(0);
                cluster.addServer(clusterServer);
            }
            this._program.configure(clusterServer.getCluster());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public class HttpCompatConfig {
        private String _id = "";
        private ContainerProgram _program = new ContainerProgram();

        HttpCompatConfig() {
        }

        public void setId(String id) {
            this._id = id;
        }

        public void setServerId(String id) {
            this.setId(id);
        }

        public void addBuilderProgram(ConfigProgram program) {
            this._program.addProgram(program);
        }

        @PostConstruct
        public void init() throws Throwable {
            ClusterServer server = ServerCompatConfig.this._resin.findClusterServer(this._id);
            if (server == null) {
                Cluster cluster = ServerCompatConfig.this._resin.findCluster("");
                if (cluster == null) {
                    cluster = ServerCompatConfig.this._resin.createCluster();
                    ServerCompatConfig.this._resin.addCluster(cluster);
                }
                server = cluster.createServer();
                server.setId(this._id);
                server.getClusterPort().setPort(0);
                cluster.addServer(server);
            }
            Port http = server.createHttp();
            this._program.configure(http);
        }
    }
}

