/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthTypeCondition
extends AbstractCondition {
    private static final L10N L = new L10N(AuthTypeCondition.class);
    private final String _authType;
    private boolean _sendVary = true;

    public AuthTypeCondition(String authType) {
        if ("NONE".equalsIgnoreCase(authType)) {
            this._authType = null;
        } else if ("BASIC".equalsIgnoreCase(authType)) {
            this._authType = "BASIC";
        } else if ("CLIENT_CERT".equalsIgnoreCase(authType)) {
            this._authType = "CLIENT_CERT";
        } else if ("DIGEST".equalsIgnoreCase(authType)) {
            this._authType = "DIGEST";
        } else if ("FORM".equalsIgnoreCase(authType)) {
            this._authType = "FORM";
        } else {
            throw new ConfigException(L.l("auth-type expects a 'value' of BASIC, CLIENT-CERT, DIGEST, FORM, or NONE"));
        }
    }

    public String getTagName() {
        return "auth-type";
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", "Cookie");
        } else {
            this.addHeaderValue(response, "Cache-Control", "private");
        }
        String authType = request.getAuthType();
        if (authType == null) {
            authType = "none";
        }
        if (this._authType == null) {
            return "none".equalsIgnoreCase(authType);
        }
        return this._authType.equalsIgnoreCase(authType);
    }
}

