/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import java.util.regex.Matcher;
import javax.servlet.FilterChain;

public class ForwardRule
extends AbstractRuleWithConditions {
    private String _target;
    private String _targetHost;

    protected ForwardRule(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
    }

    public String getTagName() {
        return "forward";
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setTargetHost(String target) {
        this._targetHost = target;
    }

    public String rewrite(String uri, Matcher matcher) {
        return matcher.replaceAll(this._target);
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) {
        if (queryString == null) {
            return new ForwardFilterChain(uri);
        }
        if (uri.indexOf(63) >= 0) {
            return new ForwardFilterChain(uri + "&" + queryString);
        }
        return new ForwardFilterChain(uri + "?" + queryString);
    }

    public void init() throws ConfigException {
        super.init();
        this.required(this._target, "target");
    }
}

