/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jmx.Description;
import com.caucho.loader.Environment;
import com.caucho.management.server.RewriteImportMXBean;
import com.caucho.server.rewrite.AbstractRule;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.MatchRule;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public class ImportRule
extends AbstractRule
implements AlarmListener {
    private static L10N L = new L10N(ImportRule.class);
    private static Logger log = Logger.getLogger(ImportRule.class.getName());
    private Path _path;
    private boolean _isOptional;
    private long _dependencyCheckInterval = Environment.getDependencyCheckInterval();
    private long _errorCheckInterval = 2000L;
    private Depend _depend;
    private volatile MatchRule _matchRule;
    private volatile boolean _isError;
    private volatile String _redeployError;
    private volatile boolean _isDestroyed = false;
    private Alarm _alarm;

    protected ImportRule(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
    }

    public String getTagName() {
        return "import";
    }

    public void setDependencyCheckInterval(Period dependencyCheckInterval) {
        this._dependencyCheckInterval = dependencyCheckInterval.getPeriod();
    }

    public long getDependencyCheckInterval() {
        return this._dependencyCheckInterval;
    }

    public String getRedeployError() {
        return this._redeployError;
    }

    public void setOptional(boolean isOptional) {
        this._isOptional = isOptional;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void init() {
        if (this._path == null) {
            throw new ConfigException(L.l("'path' attribute missing from resin:import."));
        }
        if (this.getName() == null) {
            this.setName(this._path.getNativePath());
        }
        try {
            this.load();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        super.init();
        this._alarm = new Alarm("rewrite-dispatch-import", (AlarmListener)this, this._dependencyCheckInterval);
    }

    protected AbstractRule.RewriteRuleAdmin createAdmin() {
        return new RewriteImportAdmin(this);
    }

    public void setPassFilterChainMapper(FilterChainMapper passFilterChainMapper) {
        super.setPassFilterChainMapper(passFilterChainMapper);
        if (this._matchRule != null) {
            this._matchRule.setPassFilterChainMapper(passFilterChainMapper);
        }
    }

    public void setFailFilterChainMapper(FilterChainMapper failFilterChainMapper) {
        super.setFailFilterChainMapper(failFilterChainMapper);
        if (this._matchRule != null) {
            this._matchRule.setFailFilterChainMapper(failFilterChainMapper);
        }
    }

    public FilterChain map(String uri, String query, FilterChain accept) throws ServletException {
        if (this.isEnabled() && this._matchRule != null) {
            return this._matchRule.map(uri, query, accept);
        }
        if (this.getPassFilterChainMapper() != null) {
            return this.getPassFilterChainMapper().map(uri, query, accept);
        }
        return accept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void load() throws Exception {
        block5: {
            if (this._isDestroyed) {
                return;
            }
            if (this._depend != null && !this._depend.isModified()) {
                return;
            }
            try {
                this._depend = new Depend(this._path);
                this._isError = true;
                MatchRule matchRule = new MatchRule(this.getRewriteDispatch());
                matchRule.setPassFilterChainMapper(this.getPassFilterChainMapper());
                matchRule.setFailFilterChainMapper(this.getFailFilterChainMapper());
                if (this._path.canRead() && !this._path.isDirectory()) {
                    Config config = new Config();
                    config.configure((Object)matchRule, this._path);
                    this._isError = false;
                    this.setMatchRule(matchRule);
                    break block5;
                }
                if (!this._isOptional) throw new ConfigException(L.l("Required file '{0}' can not be read for import.", (Object)this._path.getNativePath()));
                log.finer(L.l("import '{0}' is not readable.", (Object)this._path));
                matchRule.init();
                this._isError = false;
                this.setMatchRule(matchRule);
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.clearCache();
                throw throwable;
            }
            this.clearCache();
            return;
        }
        Object var4_3 = null;
        this.clearCache();
    }

    private void setMatchRule(MatchRule matchRule) {
        MatchRule oldMatchRule = this._matchRule;
        if (oldMatchRule != null) {
            oldMatchRule.unregister();
        }
        matchRule.register();
        this._matchRule = matchRule;
        if (oldMatchRule != null) {
            oldMatchRule.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        long l;
        alarm = this._alarm;
        if (this._isDestroyed) {
            return;
        }
        try {
            try {
                this._redeployError = null;
                this.load();
            }
            catch (Exception ex) {
                this._redeployError = ex.toString();
                log.log(Level.WARNING, ex.toString(), ex);
                Object var4_3 = null;
                if (this._isDestroyed) return;
                long delta222 = this._isError ? this._errorCheckInterval : this._dependencyCheckInterval;
                alarm.queue(delta222);
                return;
            }
            Object var4_2 = null;
            if (this._isDestroyed) return;
            l = this._isError ? this._errorCheckInterval : this._dependencyCheckInterval;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this._isDestroyed) throw throwable;
            long delta222 = this._isError ? this._errorCheckInterval : this._dependencyCheckInterval;
            alarm.queue(delta222);
            throw throwable;
        }
        long delta222 = l;
        alarm.queue(delta222);
    }

    private void update() {
        this.handleAlarm(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this._isDestroyed = true;
            Alarm alarm = this._alarm;
            this._alarm = null;
            MatchRule matchRule = this._matchRule;
            this._matchRule = null;
            if (alarm != null) {
                alarm.dequeue();
            }
            if (matchRule != null) {
                matchRule.destroy();
            }
            Object var4_3 = null;
            super.destroy();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.destroy();
            throw throwable;
        }
    }

    public static class RewriteImportAdmin
    extends AbstractRule.RewriteRuleAdmin
    implements RewriteImportMXBean {
        private final ImportRule _rule;

        public RewriteImportAdmin(ImportRule rule) {
            super(rule);
            this._rule = rule;
        }

        public String getType() {
            return "RewriteImport";
        }

        public long getDependencyCheckInterval() {
            return this._rule.getDependencyCheckInterval();
        }

        public String getRedeployError() {
            return this._rule.getRedeployError();
        }

        @Description(value="Updates the imported rules if the file has changed")
        public void update() {
            this._rule.update();
        }
    }
}

