/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public class LoadBalanceRule
extends AbstractRuleWithConditions {
    private static final L10N L = new L10N(LoadBalanceRule.class);
    private static final Logger log = Logger.getLogger(LoadBalanceRule.class.getName());
    private final WebApp _webApp;
    private ServletConfigImpl _servlet;
    private ContainerProgram _program = new ContainerProgram();

    LoadBalanceRule(RewriteDispatch rewriteDispatch, WebApp webApp) {
        super(rewriteDispatch);
        this._webApp = webApp;
    }

    public String getTagName() {
        return "load-balance";
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) throws ServletException {
        return this._servlet.createServletChain();
    }

    public void init() throws ConfigException {
        super.init();
        try {
            this._servlet = new ServletConfigImpl();
            this._servlet.setServletName("resin-dispatch-lb");
            Class<?> cl = Class.forName("com.caucho.servlets.LoadBalanceServlet");
            this._servlet.setServletClass("com.caucho.servlets.LoadBalanceServlet");
            this._servlet.setInit(this._program);
            this._webApp.addServlet(this._servlet);
        }
        catch (ServletException ex) {
            throw ConfigException.create((Throwable)ex);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("load-balance requires Resin Professional"));
        }
    }
}

