/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.dispatch.AbstractFilterChain;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ProxyRule
extends AbstractRuleWithConditions {
    private static final L10N L = new L10N(ProxyRule.class);
    private static final Logger log = Logger.getLogger(ProxyRule.class.getName());
    private final WebApp _webApp;
    private ServletConfigImpl _servlet;
    private String _target;
    private ContainerProgram _program = new ContainerProgram();

    ProxyRule(RewriteDispatch rewriteDispatch, WebApp webApp) {
        super(rewriteDispatch);
        this._webApp = webApp;
    }

    public String getTagName() {
        return "proxy";
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) throws ServletException {
        if (this._target != null) {
            return new ProxyFilterChain(this._servlet.createServletChain(), this._target, queryString);
        }
        return new ProxyFilterChain(this._servlet.createServletChain(), uri, queryString);
    }

    public void init() throws ConfigException {
        super.init();
        try {
            this._servlet = new ServletConfigImpl();
            this._servlet.setServletName("resin-dispatch-lb");
            Class<?> cl = Class.forName("com.caucho.servlets.HttpProxyServlet");
            this._servlet.setServletClass("com.caucho.servlets.HttpProxyServlet");
            this._servlet.setInit(this._program);
            this._webApp.addServlet(this._servlet);
        }
        catch (ServletException ex) {
            throw ConfigException.create((Throwable)ex);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("load-balance requires Resin Professional"));
        }
    }

    public static class ProxyRequest
    extends HttpServletRequestWrapper {
        private String _uri;
        private String _queryString;

        ProxyRequest(ServletRequest req, String uri, String queryString) {
            super((HttpServletRequest)req);
            this._uri = uri;
            this._queryString = queryString;
        }

        public String getRequestURI() {
            return this._uri;
        }

        public String getQueryString() {
            return this._queryString;
        }
    }

    public static class ProxyFilterChain
    extends AbstractFilterChain {
        private final FilterChain _next;
        private final String _uri;
        private final String _queryString;

        ProxyFilterChain(FilterChain next, String uri, String queryString) {
            this._next = next;
            this._uri = uri;
            this._queryString = queryString;
        }

        public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            this._next.doFilter((ServletRequest)new ProxyRequest(req, this._uri, this._queryString), res);
        }
    }
}

