/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.server.connection.Form;
import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.HashMapImpl;
import com.caucho.vfs.Encoding;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QueryParamCondition
extends AbstractCondition {
    private static final Logger log = Logger.getLogger(QueryParamCondition.class.getName());
    private final String _param;
    private Pattern _regexp;
    private boolean _caseInsensitive;

    QueryParamCondition(String param) {
        this._param = param;
    }

    public String getTagName() {
        return "query-param";
    }

    public void setRegexp(Pattern pattern) {
        this._regexp = pattern;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    @PostConstruct
    public void init() {
        if (this._regexp != null && this._caseInsensitive) {
            this._regexp = Pattern.compile(this._regexp.pattern(), 2);
        }
    }

    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        String query = request.getQueryString();
        if (query == null) {
            return false;
        }
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = CharacterEncoding.getLocalEncoding();
        }
        String javaEncoding = Encoding.getJavaName((String)charEncoding);
        Form formParser = new Form();
        HashMapImpl form = new HashMapImpl();
        try {
            formParser.parseQueryString((HashMapImpl<String, String[]>)form, query, javaEncoding, true);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        String[] value = (String[])form.get((Object)this._param);
        if (value == null || value.length == 0) {
            return false;
        }
        return this._regexp == null || this._regexp.matcher(value[0]).find();
    }
}

