/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.cluster.Server;
import com.caucho.server.rewrite.MatchRule;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public class RewriteDispatch {
    private static final L10N L = new L10N(RewriteDispatch.class);
    private static final Logger log = Logger.getLogger(RewriteDispatch.class.getName());
    private final WebApp _webApp;
    private final Server _server;
    private MatchRule _matchRule;
    private ContainerProgram _program = new ContainerProgram();
    private final boolean _isFiner;
    private final boolean _isFinest;

    public RewriteDispatch(Server server) {
        this(server, null);
    }

    public RewriteDispatch(WebApp webApp) {
        this(null, webApp);
    }

    private RewriteDispatch(Server server, WebApp webApp) {
        this._server = server;
        this._webApp = webApp;
        this._isFiner = log.isLoggable(Level.FINER);
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    @PostConstruct
    public void init() {
        this._matchRule = new MatchRule(this);
        this._matchRule.setRegexp(Pattern.compile(".*"));
        this._program.configure(this._matchRule);
        this._matchRule.init();
    }

    public FilterChain map(String uri, String queryString, FilterChain next) throws ServletException {
        if (this._isFinest) {
            log.finest("rewrite-dispatch check uri '" + uri + "'");
        }
        if (this._matchRule == null || this._matchRule.isModified()) {
            if (this._matchRule != null) {
                this._matchRule.destroy();
            }
            this._matchRule = new MatchRule(this);
            this._matchRule.setRegexp(Pattern.compile(".*"));
            this._program.configure(this._matchRule);
            this._matchRule.init();
        }
        return this._matchRule.map(uri, queryString, next);
    }

    public void clearCache() {
        if (this._webApp != null) {
            this._webApp.clearCache();
        } else if (this._server != null) {
            this._server.clearCache();
        }
    }
}

