/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.security.BasicPrincipal;
import com.caucho.server.security.PasswordDigest;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.webbeans.component.HandleAware;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AbstractAuthenticator
implements ServletAuthenticator,
HandleAware,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractAuthenticator.class.getName());
    static final L10N L = new L10N(AbstractAuthenticator.class);
    public static final String LOGIN_NAME = "com.caucho.servlet.login.name";
    protected int _principalCacheSize = 4096;
    protected LruCache<String, PrincipalEntry> _principalCache;
    protected String _passwordDigestAlgorithm = "MD5-base64";
    protected String _passwordDigestRealm = "resin";
    protected PasswordDigest _passwordDigest;
    private boolean _logoutOnTimeout = true;
    private Object _serializationHandle;

    public int getPrincipalCacheSize() {
        return this._principalCacheSize;
    }

    public void setPrincipalCacheSize(int size) {
        this._principalCacheSize = size;
    }

    public PasswordDigest getPasswordDigest() {
        return this._passwordDigest;
    }

    public void setPasswordDigest(PasswordDigest digest) {
        this._passwordDigest = digest;
    }

    public String getPasswordDigestAlgorithm() {
        return this._passwordDigestAlgorithm;
    }

    public void setPasswordDigestAlgorithm(String digest) {
        this._passwordDigestAlgorithm = digest;
    }

    public String getPasswordDigestRealm() {
        return this._passwordDigestRealm;
    }

    public void setPasswordDigestRealm(String realm) {
        this._passwordDigestRealm = realm;
    }

    public boolean getLogoutOnSessionTimeout() {
        return this._logoutOnTimeout;
    }

    public void setLogoutOnSessionTimeout(boolean logout) {
        this._logoutOnTimeout = logout;
    }

    public void addRoleMapping(Principal principal, String role) {
    }

    @PostConstruct
    public void init() throws ServletException {
        int p;
        if (this._principalCacheSize > 0) {
            this._principalCache = new LruCache(this._principalCacheSize);
        }
        if (this._passwordDigest != null) {
            if (this._passwordDigest.getAlgorithm() == null || this._passwordDigest.getAlgorithm().equals("none")) {
                this._passwordDigest = null;
            }
        } else if (this._passwordDigestAlgorithm != null && !this._passwordDigestAlgorithm.equals("none") && (p = this._passwordDigestAlgorithm.indexOf(45)) > 0) {
            String algorithm = this._passwordDigestAlgorithm.substring(0, p);
            String format = this._passwordDigestAlgorithm.substring(p + 1);
            this._passwordDigest = new PasswordDigest();
            this._passwordDigest.setAlgorithm(algorithm);
            this._passwordDigest.setFormat(format);
            this._passwordDigest.setRealm(this._passwordDigestRealm);
            this._passwordDigest.init();
        }
    }

    public Principal login(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password) throws ServletException {
        String digestPassword = this.getPasswordDigest(request, response, app, user, password);
        Principal principal = this.loginImpl(request, response, app, user, digestPassword);
        if (principal != null) {
            SessionImpl session = (SessionImpl)request.getSession();
            session.setUser(principal);
            if (this._principalCache != null) {
                PrincipalEntry entry = new PrincipalEntry(principal);
                entry.addSession(session);
                this._principalCache.put((Object)session.getId(), (Object)entry);
            }
        }
        return principal;
    }

    public String getPasswordDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password) throws ServletException {
        if (this._passwordDigest != null) {
            return this._passwordDigest.getPasswordDigest(request, response, app, user, password);
        }
        return password;
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String user, String password) throws ServletException {
        return null;
    }

    public Principal loginDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String realm, String nonce, String uri, String qop, String nc, String cnonce, byte[] clientDigest) throws ServletException {
        Principal principal = this.loginDigestImpl(request, response, app, user, realm, nonce, uri, qop, nc, cnonce, clientDigest);
        if (principal != null) {
            SessionImpl session = (SessionImpl)request.getSession();
            session.setUser(principal);
            if (this._principalCache != null) {
                PrincipalEntry entry = new PrincipalEntry(principal);
                entry.addSession(session);
                this._principalCache.put((Object)session.getId(), (Object)entry);
            }
        }
        return principal;
    }

    public Principal loginDigestImpl(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String realm, String nonce, String uri, String qop, String nc, String cnonce, byte[] clientDigest) throws ServletException {
        try {
            int i;
            if (clientDigest == null) {
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] a1 = this.getDigestSecret(request, response, app, user, realm, "MD5");
            if (a1 == null) {
                return null;
            }
            this.digestUpdateHex(digest, a1);
            digest.update((byte)58);
            for (i = 0; i < nonce.length(); ++i) {
                digest.update((byte)nonce.charAt(i));
            }
            if (qop != null) {
                digest.update((byte)58);
                for (i = 0; i < nc.length(); ++i) {
                    digest.update((byte)nc.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; cnonce != null && i < cnonce.length(); ++i) {
                    digest.update((byte)cnonce.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; qop != null && i < qop.length(); ++i) {
                    digest.update((byte)qop.charAt(i));
                }
            }
            digest.update((byte)58);
            byte[] a2 = this.digest(request.getMethod() + ":" + uri);
            this.digestUpdateHex(digest, a2);
            byte[] serverDigest = digest.digest();
            if (clientDigest.length != serverDigest.length) {
                return null;
            }
            for (int i2 = 0; i2 < clientDigest.length; ++i2) {
                if (serverDigest[i2] == clientDigest[i2]) continue;
                return null;
            }
            return new BasicPrincipal(user);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void digestUpdateHex(MessageDigest digest, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int d1 = b >> 4 & 0xF;
            int d2 = b & 0xF;
            if (d1 < 10) {
                digest.update((byte)(d1 + 48));
            } else {
                digest.update((byte)(d1 + 97 - 10));
            }
            if (d2 < 10) {
                digest.update((byte)(d2 + 48));
                continue;
            }
            digest.update((byte)(d2 + 97 - 10));
        }
    }

    protected byte[] stringToDigest(String digest) {
        if (digest == null) {
            return null;
        }
        int len = (digest.length() + 1) / 2;
        byte[] clientDigest = new byte[len];
        int i = 0;
        while (i + 1 < digest.length()) {
            char ch1 = digest.charAt(i);
            char ch2 = digest.charAt(i + 1);
            int b = 0;
            if (ch1 >= '0' && ch1 <= '9') {
                b += ch1 - 48;
            } else if (ch1 >= 'a' && ch1 <= 'f') {
                b += ch1 - 97 + 10;
            }
            b *= 16;
            if (ch2 >= '0' && ch2 <= '9') {
                b += ch2 - 48;
            } else if (ch2 >= 'a' && ch2 <= 'f') {
                b += ch2 - 97 + 10;
            }
            clientDigest[i / 2] = (byte)b;
            i += 2;
        }
        return clientDigest;
    }

    protected byte[] getDigestSecret(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm, String algorithm) throws ServletException {
        String password = this.getDigestPassword(request, response, application, username, realm);
        if (password == null) {
            return null;
        }
        if (this._passwordDigest != null) {
            return this._passwordDigest.stringToDigest(password);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            String string = username + ":" + realm + ":" + password;
            byte[] data = string.getBytes("UTF8");
            return digest.digest(data);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected byte[] digest(String value) throws ServletException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] data = value.getBytes("UTF8");
            return digest.digest(data);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm) throws ServletException {
        return null;
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        SessionImpl session = (SessionImpl)request.getSession(false);
        Principal user = null;
        if (session != null) {
            user = session.getUser();
        }
        if (user != null) {
            return user;
        }
        PrincipalEntry entry = null;
        if (this._principalCache != null) {
            if (session != null) {
                entry = (PrincipalEntry)this._principalCache.get((Object)session.getId());
            } else if (request.getRequestedSessionId() != null) {
                entry = (PrincipalEntry)this._principalCache.get((Object)request.getRequestedSessionId());
            }
        }
        if (entry != null) {
            user = entry.getPrincipal();
            if (session == null) {
                session = (SessionImpl)request.getSession(true);
            }
            session.setUser(user);
            entry.addSession(session);
            return user;
        }
        user = this.getUserPrincipalImpl(request, application);
        if (user != null) {
            if (session != null) {
                entry = new PrincipalEntry(user);
                session.setUser(user);
                entry.addSession(session);
                this._principalCache.put((Object)session.getId(), (Object)entry);
            } else if (request.getRequestedSessionId() != null) {
                entry = new PrincipalEntry(user);
                this._principalCache.put((Object)request.getRequestedSessionId(), (Object)entry);
            }
        }
        return user;
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request, ServletContext application) throws ServletException {
        return null;
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user, String role) throws ServletException {
        return false;
    }

    public void logout(ServletContext application, HttpSession timeoutSession, String sessionId, Principal user) throws ServletException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout " + user);
        }
        if (sessionId != null) {
            Application app;
            SessionManager manager;
            if (this._principalCache != null) {
                PrincipalEntry entry;
                if (timeoutSession != null) {
                    entry = (PrincipalEntry)this._principalCache.get((Object)sessionId);
                    if (entry != null && entry.logout(timeoutSession)) {
                        this._principalCache.remove((Object)sessionId);
                    }
                } else {
                    entry = (PrincipalEntry)this._principalCache.remove((Object)sessionId);
                    if (entry != null) {
                        entry.logout();
                    }
                }
            }
            if ((manager = (app = (Application)application).getSessionManager()) != null) {
                try {
                    SessionImpl session = manager.getSession(sessionId, Alarm.getCurrentTime(), false, true);
                    if (session != null) {
                        session.finish();
                        session.logout();
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) throws ServletException {
        this.logout(application, null, request.getRequestedSessionId(), user);
    }

    public void logout(ServletContext application, String sessionId, Principal user) throws ServletException {
        this.logout(application, null, sessionId, user);
    }

    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._passwordDigestAlgorithm + "," + this._passwordDigestRealm + "]";
    }

    static class PrincipalEntry {
        private Principal _principal;
        private ArrayList<SoftReference<SessionImpl>> _sessions;

        PrincipalEntry(Principal principal) {
            this._principal = principal;
        }

        Principal getPrincipal() {
            return this._principal;
        }

        void addSession(SessionImpl session) {
            if (this._sessions == null) {
                this._sessions = new ArrayList();
            }
            this._sessions.add(new SoftReference<SessionImpl>(session));
        }

        boolean logout(HttpSession timeoutSession) {
            ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
            if (sessions == null) {
                return true;
            }
            boolean isEmpty = true;
            for (int i = sessions.size() - 1; i >= 0; --i) {
                SoftReference<SessionImpl> ref = sessions.get(i);
                SessionImpl session = ref.get();
                try {
                    if (session == timeoutSession) {
                        sessions.remove(i);
                        session.logout();
                        continue;
                    }
                    if (session == null) {
                        sessions.remove(i);
                        continue;
                    }
                    isEmpty = false;
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return isEmpty;
        }

        void logout() {
            ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
            this._sessions = null;
            for (int i = 0; sessions != null && i < sessions.size(); ++i) {
                SoftReference<SessionImpl> ref = sessions.get(i);
                SessionImpl session = ref.get();
                try {
                    if (session == null) continue;
                    session.logout();
                    session.invalidateLogout();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }
}

