/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.security.LoginFilter;
import com.caucho.server.security.NullAuthenticator;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.webbeans.ComponentFactory;

public abstract class AbstractLogin
implements LoginFilter {
    protected static final Logger log = Logger.getLogger(AbstractLogin.class.getName());
    protected ServletAuthenticator _auth;

    public void setAuthenticator(ServletAuthenticator auth) {
        this._auth = auth;
    }

    public ServletAuthenticator getAuthenticator() {
        if (this._auth == null) {
            try {
                WebBeansContainer webBeans = WebBeansContainer.create();
                ComponentFactory<ServletAuthenticator> factory = webBeans.resolveByType(ServletAuthenticator.class, new Annotation[0]);
                if (factory != null) {
                    this._auth = (ServletAuthenticator)factory.get();
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._auth == null) {
                this._auth = new NullAuthenticator();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.toString() + " using " + this._auth);
            }
        }
        return this._auth;
    }

    @PostConstruct
    public void init() throws ServletException {
    }

    public String getAuthType() {
        return "none";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = this.getUserPrincipal(request, response, application);
        if (user == null) {
            response.sendError(403);
        }
        return user;
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        return this.getAuthenticator().getUserPrincipal(request, response, application);
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user, String role) throws ServletException {
        return this.getAuthenticator().isUserInRole(request, response, application, user, role);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        Principal principal = this.getUserPrincipal(request, response, application);
        if (principal != null) {
            this.getAuthenticator().logout(application, null, request.getRequestedSessionId(), principal);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

