/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.server.security.PasswordUser;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractPasswordAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Logger.getLogger(AbstractPasswordAuthenticator.class.getName());

    protected abstract PasswordUser getUser(String var1);

    protected PasswordUser getUser(Principal principal) {
        return this.getUser(principal.getName());
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String password) throws ServletException {
        if (userName == null) {
            return null;
        }
        PasswordUser user = this.getUser(userName);
        if (user == null || user.isDisabled()) {
            return null;
        }
        char[] userPassword = user.getPassword();
        if (this.isMatch(password, user.getPassword())) {
            return user.getPrincipal();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " authentication of " + userName + " failed password");
        }
        return null;
    }

    private boolean isMatch(String password, char[] userPassword) {
        int len = password.length();
        if (len != userPassword.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (password.charAt(i) == userPassword[i]) continue;
            return false;
        }
        return true;
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String realm) throws ServletException {
        PasswordUser user = this.getUser(userName);
        if (user == null || user.isDisabled()) {
            return null;
        }
        return new String(user.getPassword());
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) throws ServletException {
        if (principal == null) {
            return false;
        }
        PasswordUser user = this.getUser(principal);
        if (user == null) {
            return false;
        }
        for (String userRole : user.getRoles()) {
            if (!userRole.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }
}

