/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.log.Log;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyMap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ForbidHost {
    protected static final Logger log = Log.open(ForbidHost.class);
    static final L10N L = new L10N(ForbidHost.class);
    private LongKeyMap _forbiddenHosts;
    private ArrayList _forbiddenNets;

    public void addForbidIP(String addrName) {
        try {
            InetAddress addr = InetAddress.getByName(addrName);
            if (this._forbiddenHosts == null) {
                this._forbiddenHosts = new LongKeyMap();
            }
            this._forbiddenHosts.put(ForbidHost.inetAddressToLong(addr), (Object)"true");
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void removeForbidIP(String addrName) {
        try {
            InetAddress addr = InetAddress.getByName(addrName);
            if (this._forbiddenHosts != null) {
                this._forbiddenHosts.remove(ForbidHost.inetAddressToLong(addr));
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void addForbidNet(String netmask) {
        try {
            InetNetwork net = InetNetwork.create((String)netmask);
            if (net == null) {
                return;
            }
            if (this._forbiddenNets == null) {
                this._forbiddenNets = new ArrayList();
            }
            this._forbiddenNets.add(net);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void removeForbidNet(String netmask) {
        try {
            InetNetwork net = InetNetwork.create((String)netmask);
            if (net == null) {
                return;
            }
            if (this._forbiddenNets != null) {
                this._forbiddenNets.remove(net);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @PostConstruct
    public void init() {
    }

    public boolean isForbidden(long addr) {
        if (this._forbiddenHosts != null && this._forbiddenHosts.get(addr) != null) {
            return true;
        }
        if (this._forbiddenNets != null) {
            for (int i = this._forbiddenNets.size(); i >= 0; --i) {
                InetNetwork net = (InetNetwork)this._forbiddenNets.get(i);
                if (!net.isMatch(addr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isForbidden(InetAddress addr) {
        if (this._forbiddenHosts == null && this._forbiddenNets == null) {
            return false;
        }
        long ip = ForbidHost.inetAddressToLong(addr);
        if (this._forbiddenHosts != null && this._forbiddenHosts.get(ip) != null) {
            return true;
        }
        if (this._forbiddenNets != null) {
            for (int i = this._forbiddenNets.size(); i >= 0; --i) {
                InetNetwork net = (InetNetwork)this._forbiddenNets.get(i);
                if (!net.isMatch(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private static long inetAddressToLong(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return address;
    }
}

