/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.security.FormLogin;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLoginServlet
extends GenericServlet {
    private final Logger log = Logger.getLogger(FormLoginServlet.class.getName());
    static final L10N L = new L10N(FormLoginServlet.class);

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String suffix;
        WebApp newApp;
        RequestDispatcher disp;
        boolean useInternalForward;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        WebApp app = (WebApp)this.getServletContext();
        if (!(app.getLogin() instanceof FormLogin)) {
            throw new ServletException(L.l("FormLoginServlet requires a form login auth-type configuration at '{0}'", (Object)app.getLogin().getAuthType()));
        }
        FormLogin login = (FormLogin)app.getLogin();
        if (login == null) {
            throw new ServletException(L.l("j_security_check requires a login"));
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        ServletAuthenticator auth = login.getAuthenticator();
        Principal user = auth.login(req, res, app, username, password);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine((Object)((Object)this) + " login " + user);
        }
        if (user == null) {
            String errorPage = login.getFormErrorPage();
            RequestDispatcherImpl disp2 = (RequestDispatcherImpl)app.getRequestDispatcher(errorPage);
            if (res instanceof CauchoResponse) {
                ((CauchoResponse)res).killCache();
                ((CauchoResponse)res).setNoCache(true);
            } else {
                res.setDateHeader("Expires", 0L);
                res.setHeader("Cache-Control", "no-cache");
            }
            disp2.error((ServletRequest)req, (ServletResponse)res);
            return;
        }
        HttpSession session = req.getSession();
        String uri = (String)session.getValue("com.caucho.servlet.login.path");
        String query = (String)session.getValue("com.caucho.servlet.login.query");
        session.removeAttribute("com.caucho.servlet.login.path");
        session.removeAttribute("com.caucho.servlet.login.query");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("old path:" + uri + " query:" + query + " j_uri:" + req.getParameter("j_uri"));
        }
        boolean formURIPriority = login.getFormURIPriority();
        if ((uri == null || formURIPriority) && req.getParameter("j_uri") != null) {
            uri = req.getParameter("j_uri");
        } else if (uri != null && query != null) {
            uri = uri + "?" + query;
        }
        if (uri == null) {
            this.log.warning(L.l("FormLogin: session has timed out for session '{0}'", (Object)req.getSession().getId()));
            RequestDispatcher disp3 = request.getRequestDispatcher("/");
            if (disp3 != null) {
                disp3.forward(request, response);
                return;
            }
            throw new ServletException(L.l("Session has timed out for form authentication, no forwarding URI is available.  Either the login form must specify j_uri or the session must have a saved URI."));
        }
        if (uri.indexOf(10) >= 0 || uri.indexOf(13) >= 0) {
            throw new ServletException(L.l("Forwarding URI '{0}' is invalid.", (Object)uri));
        }
        String uriPwd = req.getRequestURI();
        int p = uriPwd.indexOf("/j_security_check");
        if (p >= 0) {
            uriPwd = uriPwd.substring(0, p + 1);
        }
        if (uri.length() != 0) {
            if (uri.charAt(0) == '/') {
                uri = req.getContextPath() + uri;
            } else if (uri.indexOf(58) < 0 || uri.indexOf(58) >= uri.indexOf(47) && uri.indexOf(47) >= 0) {
                uri = uriPwd + uri;
            }
        }
        if ((useInternalForward = login.getInternalForward()) && uri.startsWith(uriPwd) && uri.indexOf(47, uriPwd.length() + 1) < 0 && (disp = (newApp = (WebApp)app.getContext(uri)).getLoginDispatcher(suffix = uri.substring(newApp.getContextPath().length()))) != null) {
            disp.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        res.sendRedirect(res.encodeRedirectURL(uri));
    }
}

