/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPConstraint
extends AbstractConstraint {
    static final Logger log = Log.open(IPConstraint.class);
    static L10N L = new L10N(IPConstraint.class);
    private ArrayList<InetNetwork> _allowNetworkList;
    private ArrayList<InetNetwork> _denyNetworkList;
    private int _cacheSize = 256;
    private int _errorCode = 403;
    private String _errorMessage = L.l("Forbidden IP Address");
    private LruCache<String, Boolean> _cache;
    private boolean _oldStyle = false;

    public void setErrorCode(int errorCode) {
        this._errorCode = errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this._errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void addAllow(String network) {
        if (this._allowNetworkList == null) {
            this._allowNetworkList = new ArrayList();
        }
        this._allowNetworkList.add(InetNetwork.create((String)network));
    }

    public void addDeny(String network) {
        if (this._denyNetworkList == null) {
            this._denyNetworkList = new ArrayList();
        }
        this._denyNetworkList.add(InetNetwork.create((String)network));
    }

    public void addText(String network) {
        this._oldStyle = true;
        this.addAllow(network);
    }

    boolean isOldStyle() {
        return this._oldStyle;
    }

    void copyInto(IPConstraint target) {
        int i;
        if (this._allowNetworkList != null) {
            for (i = 0; i < this._allowNetworkList.size(); ++i) {
                target.addAllowInetNetwork(this._allowNetworkList.get(i));
            }
        }
        if (this._denyNetworkList != null) {
            for (i = 0; i < this._denyNetworkList.size(); ++i) {
                target.addDenyInetNetwork(this._denyNetworkList.get(i));
            }
        }
    }

    private void addAllowInetNetwork(InetNetwork a) {
        if (this._allowNetworkList == null) {
            this._allowNetworkList = new ArrayList();
        }
        this._allowNetworkList.add(a);
    }

    private void addDenyInetNetwork(InetNetwork d) {
        if (this._denyNetworkList == null) {
            this._denyNetworkList = new ArrayList();
        }
        this._denyNetworkList.add(d);
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._allowNetworkList == null && this._denyNetworkList == null) {
            throw new ConfigException(L.l("either `{0}' or `{1}' or both are expected", (Object)"<allow>", (Object)"<deny>"));
        }
        if (this._allowNetworkList != null) {
            this._allowNetworkList.trimToSize();
        }
        if (this._denyNetworkList != null) {
            this._denyNetworkList.trimToSize();
        }
        int rules = this._allowNetworkList == null ? 0 : this._allowNetworkList.size();
        rules += this._denyNetworkList == null ? 0 : this._denyNetworkList.size();
        this._cache = new LruCache(this._cacheSize);
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        int i;
        String remoteAddr = request.getRemoteAddr();
        long addr = 0L;
        boolean allow = false;
        if (remoteAddr != null) {
            char ch;
            Boolean cacheValue;
            if (this._cache != null && (cacheValue = (Boolean)this._cache.get((Object)remoteAddr)) != null) {
                allow = cacheValue;
                if (!allow) {
                    response.sendError(this._errorCode, this._errorMessage);
                }
                return allow;
            }
            int len = remoteAddr.length();
            int i2 = 0;
            while (i2 < len && (ch = remoteAddr.charAt(i2)) >= '0' && ch <= '9') {
                int digit = 0;
                while (i2 < len && (ch = remoteAddr.charAt(i2)) >= '0' && ch <= '9') {
                    digit = 10 * digit + ch - 48;
                    ++i2;
                }
                addr = 256L * addr + (long)digit;
                if (ch != '.') continue;
                ++i2;
            }
        }
        if (this._allowNetworkList == null) {
            allow = true;
        } else {
            for (i = 0; i < this._allowNetworkList.size(); ++i) {
                InetNetwork net = this._allowNetworkList.get(i);
                if (!net.isMatch(addr)) continue;
                allow = true;
                break;
            }
        }
        if (allow && this._denyNetworkList != null) {
            for (i = 0; i < this._denyNetworkList.size(); ++i) {
                InetNetwork net = this._denyNetworkList.get(i);
                if (!net.isMatch(addr)) continue;
                allow = false;
                break;
            }
        }
        if (this._cache != null) {
            this._cache.put((Object)remoteAddr, (Object)(allow ? Boolean.TRUE : Boolean.FALSE));
        }
        if (!allow) {
            response.sendError(this._errorCode, this._errorMessage);
        }
        return allow;
    }
}

