/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.server.security.CachingPrincipal;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class JdbcAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Logger.getLogger(JdbcAuthenticator.class.getName());
    private static final L10N L = new L10N(JdbcAuthenticator.class);
    private DataSource _dataSource;
    private String _passwordQuery = "SELECT password FROM LOGIN WHERE username=?";
    private String _cookieUpdate = "UPDATE LOGIN SET cookie=? WHERE username=?";
    private String _cookieQuery = "SELECT username FROM LOGIN where cookie=?";
    private boolean _cookieLogout;
    private String _roleQuery;
    protected boolean _useCookie;
    protected int _cookieVersion = -1;
    protected String _cookieDomain;
    protected long _cookieMaxAge = 31536000000L;
    private CharBuffer _cb = new CharBuffer();

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getPasswordQuery() {
        return this._passwordQuery;
    }

    public void setPasswordQuery(String query) {
        this._passwordQuery = query;
    }

    public String getCookieAuthQuery() {
        return this._cookieQuery;
    }

    public void setCookieAuthQuery(String query) {
        this._cookieQuery = query;
    }

    public String getCookieAuthUpdate() {
        return this._cookieUpdate;
    }

    public void setCookieAuthUpdate(String query) {
        this._cookieUpdate = query;
    }

    public void setCookieLogout(boolean cookieLogout) {
        this._cookieLogout = cookieLogout;
    }

    public String getRoleQuery() {
        return this._roleQuery;
    }

    public void setRoleQuery(String query) {
        this._roleQuery = query;
    }

    public boolean getUseCookie() {
        return this._useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this._useCookie = useCookie;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int version) {
        this._cookieVersion = version;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this._cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period cookieMaxAge) {
        this._cookieMaxAge = cookieMaxAge.getPeriod();
    }

    @PostConstruct
    public void init() throws ServletException {
        int i;
        super.init();
        if (this._dataSource == null) {
            try {
                InitialContext ic = new InitialContext();
                this._dataSource = (DataSource)ic.lookup("java:comp/env/jdbc/db-pool");
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (this._dataSource == null) {
                throw new ServletConfigException(L.l("Unknown database pool jdbc/db-pool."));
            }
        }
        if ((i = this._passwordQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'password-query' expects a parameter"));
        }
        if (this._cookieQuery != null && (i = this._cookieQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'cookie-auth-query' expects a parameter"));
        }
        if (this._cookieUpdate != null) {
            i = this._cookieUpdate.indexOf(63);
            if (i < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters"));
            }
            int j = this._cookieUpdate.indexOf(63, i + 1);
            if (j < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters"));
            }
        }
        if (this._cookieUpdate != null && this._cookieQuery == null) {
            throw new ServletConfigException(L.l("<{0}> expects `{1}'", (Object)"cookie-auth-update", (Object)"cookie-query"));
        }
        if (this._roleQuery != null && (i = this._roleQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'role-query' expects a parameter"));
        }
    }

    public Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String password) throws ServletException {
        Principal user = this.loginImpl(username, password);
        if (this._cookieQuery == null || user == null) {
            return user;
        }
        String cookieAuth = (String)request.getAttribute("j_use_cookie_auth");
        if (cookieAuth == null) {
            cookieAuth = request.getParameter("j_use_cookie_auth");
        }
        if ("true".equals(cookieAuth) || "on".equals(cookieAuth) || this._useCookie && cookieAuth == null) {
            this.addAuthCookie(request, response, application, user);
        }
        return user;
    }

    protected void addAuthCookie(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) {
        Application app = (Application)application;
        SessionManager sm = app.getSessionManager();
        String id = sm.createSessionId(request);
        if (this.updateCookie(user, id)) {
            Cookie cookie = new Cookie("resinauthid", id);
            cookie.setPath("/");
            if (this.getCookieVersion() >= 0) {
                cookie.setVersion(this.getCookieVersion());
            } else {
                cookie.setVersion(sm.getCookieVersion());
            }
            if (this._cookieDomain != null) {
                cookie.setDomain(this._cookieDomain);
            } else if (this.getCookieDomain() != null) {
                cookie.setDomain(this.getCookieDomain());
            } else {
                cookie.setDomain(sm.getCookieDomain());
            }
            if (this._cookieMaxAge > 0L) {
                cookie.setMaxAge((int)(this._cookieMaxAge / 1000L));
            }
            response.addCookie(cookie);
        }
    }

    /*
     * Loose catch block
     */
    public Principal loginImpl(String username, String password) throws ServletException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block39: {
            block35: {
                conn = null;
                stmt = null;
                rs = null;
                conn = this._dataSource.getConnection();
                stmt = conn.prepareStatement(this._passwordQuery);
                stmt.setString(1, username);
                rs = stmt.executeQuery();
                if (rs.next()) break block35;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                Principal principal = null;
                Object var9_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String dbPassword = rs.getString(1);
            if (dbPassword == null || !dbPassword.equals(password)) break block39;
            CachingPrincipal cachingPrincipal = new CachingPrincipal(username);
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return cachingPrincipal;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("mismatched password:" + username);
        }
        Principal principal = null;
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm) throws ServletException {
        String dbPassword;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block27: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (rs.next()) break block27;
            if (log.isLoggable(Level.FINE)) {
                log.fine("no such user:" + username);
            }
            String string = null;
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return string;
        }
        String string = dbPassword = rs.getString(1);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return string;
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request, ServletContext application) throws ServletException {
        if (this._cookieQuery == null) {
            return null;
        }
        Cookie cookie = null;
        if (request instanceof CauchoRequest) {
            cookie = ((CauchoRequest)request).getCookie("resinauthid");
        } else {
            Cookie[] cookies = request.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("resinauthid")) continue;
                cookie = cookies[i];
                break;
            }
        }
        if (cookie == null) {
            return null;
        }
        return this.authenticateCookie(cookie.getValue());
    }

    /*
     * Loose catch block
     */
    public Principal authenticateCookie(String cookieValue) throws ServletException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block38: {
            block34: {
                if (this._cookieQuery == null) {
                    return null;
                }
                conn = null;
                stmt = null;
                rs = null;
                conn = this._dataSource.getConnection();
                stmt = conn.prepareStatement(this._cookieQuery);
                stmt.setString(1, cookieValue);
                rs = stmt.executeQuery();
                if (rs.next()) break block34;
                Principal principal = null;
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String user = rs.getString(1);
            if (user == null) break block38;
            CachingPrincipal cachingPrincipal = new CachingPrincipal(user);
            Object var8_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return cachingPrincipal;
        }
        Principal principal = null;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateCookie(Principal user, String cookieValue) {
        block20: {
            if (this._cookieUpdate == null || user == null || cookieValue == null) {
                return true;
            }
            Connection conn = null;
            PreparedStatement stmt = null;
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieUpdate);
            stmt.setString(1, cookieValue);
            stmt.setString(2, user.getName());
            stmt.executeUpdate();
            Object var7_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block20;
            }
            catch (SQLException e2) {}
            break block20;
            {
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var7_6 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block20;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) {
        Boolean isInRole;
        if (this._roleQuery == null) {
            return principal != null && "user".equals(role);
        }
        if (principal == null || role == null) {
            return false;
        }
        CachingPrincipal cachingPrincipal = null;
        if (principal instanceof CachingPrincipal && (isInRole = (cachingPrincipal = (CachingPrincipal)principal).isInRole(role)) != null) {
            return isInRole.equals(Boolean.TRUE);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this._dataSource.getConnection();
        stmt = conn.prepareStatement(this._roleQuery);
        stmt.setString(1, principal.getName());
        boolean inRole = false;
        rs = stmt.executeQuery();
        while (rs.next()) {
            String dbRole = rs.getString(1);
            if (cachingPrincipal != null) {
                cachingPrincipal.addRole(dbRole);
            }
            if (!role.equals(dbRole)) continue;
            inRole = true;
        }
        boolean bl = inRole;
        Object var13_15 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            try {
                log.log(Level.FINE, e.toString(), e);
                bl2 = false;
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return bl2;
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) throws ServletException {
        super.logout(request, response, application, user);
        if (this._cookieLogout) {
            this.updateCookie(user, "");
        }
    }
}

