/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.log.Log;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.security.BasicLogin;
import com.caucho.server.security.ClientCertLogin;
import com.caucho.server.security.DigestLogin;
import com.caucho.server.security.FormLogin;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.servlet.ServletException;

public class LoginConfig {
    static final Logger log = Log.open(LoginConfig.class);
    static final L10N L = new L10N(LoginConfig.class);
    private String _authMethod = "basic";
    private String _realmName;
    private Class _customType;
    private ContainerProgram _formLoginConfig;
    private ContainerProgram _init;
    private ServletAuthenticator _authenticator;

    public void setAuthMethod(String method) {
        this._authMethod = method;
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthenticator(ServletAuthenticator auth) {
        this._authenticator = auth;
    }

    public void setType(Class type) throws ConfigException {
        this._customType = type;
        Config.validate(type, AbstractLogin.class);
    }

    public void setRealmName(String realmName) {
        this._realmName = realmName;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public ContainerProgram createFormLoginConfig() {
        if (this._formLoginConfig == null) {
            this._formLoginConfig = new ContainerProgram();
        }
        return this._formLoginConfig;
    }

    public ContainerProgram createInit() {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        return this._init;
    }

    public AbstractLogin getLogin() throws Exception {
        AbstractLogin login;
        if (this._customType != null) {
            login = (AbstractLogin)this._customType.newInstance();
            if (this._init != null) {
                this._init.configure(login);
            }
        } else if (this._authMethod.equalsIgnoreCase("basic")) {
            BasicLogin basicLogin = new BasicLogin();
            basicLogin.setRealmName(this._realmName);
            login = basicLogin;
        } else if (this._authMethod.equalsIgnoreCase("digest")) {
            DigestLogin digestLogin = new DigestLogin();
            digestLogin.setRealmName(this._realmName);
            login = digestLogin;
        } else if (this._authMethod.equalsIgnoreCase("client-cert")) {
            ClientCertLogin certLogin = new ClientCertLogin();
            login = certLogin;
        } else if (this._authMethod.equalsIgnoreCase("form")) {
            login = new FormLogin();
            if (this._formLoginConfig == null) {
                throw new ConfigException(L.l("'form' authentication requires form-login"));
            }
            this._formLoginConfig.configure(login);
        } else {
            throw new ServletException(L.l("'{0}' is an unknown auth-type.", (Object)this._authMethod));
        }
        if (this._authenticator != null) {
            login.setAuthenticator(this._authenticator);
        }
        login.init();
        return login;
    }
}

