/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.security.AbstractConstraint;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RoleConstraint
extends AbstractConstraint {
    private String[] _roles;

    public void addRoleName(String role) {
        if (this._roles == null) {
            this._roles = new String[]{role};
        } else {
            String[] newRoles = new String[this._roles.length + 1];
            System.arraycopy(this._roles, 0, newRoles, 0, this._roles.length);
            newRoles[this._roles.length] = role;
            this._roles = newRoles;
        }
    }

    public boolean needsAuthentication() {
        return this._roles != null && this._roles.length > 0;
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        for (int i = 0; this._roles != null && i < this._roles.length; ++i) {
            if (this._roles[i].equals("*")) {
                return true;
            }
            if (!request.isUserInRole(this._roles[i])) continue;
            return true;
        }
        response.sendError(403, null);
        return false;
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append("RoleConstraint[");
        for (int i = 0; i < this._roles.length; ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(this._roles[i]);
        }
        cb.append("]");
        return cb.close();
    }
}

